/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.business.queries.queries.la;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.queries.AbstractQuery;
import org.polarsys.capella.common.queries.filters.IQueryFilter;
import org.polarsys.capella.common.queries.interpretor.QueryInterpretor;
import org.polarsys.capella.common.queries.queryContext.IQueryContext;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.capellamodeller.SystemEngineering;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.InterfacePkg;
import org.polarsys.capella.core.data.la.LogicalComponent;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.model.helpers.CapellaElementExt;
import org.polarsys.capella.core.model.helpers.InterfacePkgExt;
import org.polarsys.capella.core.model.helpers.SystemEngineeringExt;
import org.polarsys.capella.core.model.helpers.queries.QueryIdentifierConstants;
import org.polarsys.capella.core.model.helpers.queries.filters.RemoveRealizedInterfaces;
import org.polarsys.capella.core.model.utils.ListExt;
import org.polarsys.kitalpha.emde.model.ExtensibleElement;

public class GetAvailable_LogicalComponent_ImplementedInterfaces
extends AbstractQuery {
    public List<Object> execute(Object input, IQueryContext context) {
        CapellaElement element = (CapellaElement)input;
        ArrayList<Object> availableElements = new ArrayList();
        SystemEngineering systemEngineering = SystemEngineeringExt.getSystemEngineering((ExtensibleElement)element);
        if (systemEngineering != null && element instanceof LogicalComponent) {
            LogicalComponent currentPC = (LogicalComponent)element;
            for (Component cpnt : CapellaElementExt.getComponentHierarchy((CapellaElement)currentPC)) {
                InterfacePkg interfacePkg = cpnt.getOwnedInterfacePkg();
                if (interfacePkg == null) continue;
                availableElements.addAll(InterfacePkgExt.getAllInterfaces((InterfacePkg)interfacePkg));
            }
            BlockArchitecture currentBlock = BlockArchitectureExt.getRootBlockArchitecture((EObject)currentPC);
            if (currentBlock.getOwnedInterfacePkg() != null) {
                availableElements.addAll(InterfacePkgExt.getAllInterfaces((InterfacePkg)currentBlock.getOwnedInterfacePkg()));
            }
            currentBlock = BlockArchitectureExt.getPreviousBlockArchitecture((BlockArchitecture)currentBlock);
            List allInterfaces = QueryInterpretor.executeQuery((String)QueryIdentifierConstants.GET_ALL_INTERFACES, (Object)currentBlock, (IQueryContext)context);
            availableElements.addAll(allInterfaces);
        }
        availableElements = ListExt.removeDuplicates(availableElements);
        availableElements = QueryInterpretor.executeFilter(availableElements, (IQueryFilter)new RemoveRealizedInterfaces());
        return availableElements;
    }
}

