/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.ui.properties.fields;

import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.core.ui.properties.fields.AbstractSemanticButtonGroup;

public abstract class AbstractSemanticKindGroup
extends AbstractSemanticButtonGroup {
    protected Group _group;

    public AbstractSemanticKindGroup(Composite parent, TabbedPropertySheetWidgetFactory widgetFactory, String groupLabel, boolean enabled, int numColumns) {
        super(widgetFactory);
        this._group = this.createGroup(parent, groupLabel, enabled, numColumns);
    }

    public AbstractSemanticKindGroup(Composite parent, TabbedPropertySheetWidgetFactory widgetFactory, String groupLabel, int numColumns) {
        this(parent, widgetFactory, groupLabel, true, numColumns);
    }

    protected Button createButton(Enumerator enumerated) {
        return this.createButton(enumerated, true);
    }

    protected Button createButton(Enumerator enumerated, boolean enabled) {
        return this.createButton((Composite)this._group, enumerated.getLiteral(), enumerated, enabled, 16);
    }

    protected Group createGroup(Composite parent, String label, boolean enabled, int numColumns) {
        this._group = this.widgetFactory.createGroup(parent, label);
        this._group.setLayout((Layout)new GridLayout(numColumns, true));
        GridData gd = new GridData(768);
        gd.horizontalSpan = ((GridLayout)parent.getLayout()).numColumns;
        this._group.setLayoutData((Object)gd);
        this._group.setEnabled(enabled);
        return this._group;
    }

    @Override
    public void loadData(EObject semanticElement) {
        this.loadData(semanticElement, this.semanticFeature);
    }

    @Override
    public void loadData(EObject capellaElement, EStructuralFeature feature) {
        super.loadData(capellaElement, feature);
        Object value = this.semanticElement.eGet(this.semanticFeature);
        if (value == null) {
            Button defaultBtn = this.getDefaultSemanticField();
            if (defaultBtn != null) {
                defaultBtn.setSelection(true);
            }
        } else if (value instanceof Enumerator) {
            for (Button button : this.getSemanticFields()) {
                if (button == null) continue;
                this.selectButton(button, (Enumerator)value);
            }
        }
    }

    protected void selectButton(Button button, Enumerator enumerated) {
        button.setSelection(enumerated.equals(button.getData()));
    }

    @Override
    public void widgetSelected(SelectionEvent event) {
        Button source = (Button)event.widget;
        if (source.getSelection()) {
            this.setValue(source.getData());
        }
    }

    protected void setValue(final Object value) {
        AbstractReadWriteCommand command = new AbstractReadWriteCommand(){

            public void run() {
                AbstractSemanticKindGroup.this.semanticElement.eSet(AbstractSemanticKindGroup.this.semanticFeature, value);
            }
        };
        this.executeCommand((ICommand)command);
    }

    public abstract Button getDefaultSemanticField();

    public Group getGroup() {
        return this._group;
    }
}

