/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.ui.properties.fields;

import java.util.Collection;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.core.data.information.datavalue.DatavalueFactory;
import org.polarsys.capella.core.data.information.datavalue.LiteralNumericValue;
import org.polarsys.capella.core.model.utils.EObjectExt2;
import org.polarsys.capella.core.model.utils.NamingHelper;
import org.polarsys.capella.core.ui.properties.CapellaUIPropertiesPlugin;
import org.polarsys.capella.core.ui.properties.fields.AbstractSemanticField;
import org.polarsys.capella.core.ui.properties.fields.EditableSemanticFieldException;
import org.polarsys.capella.core.ui.properties.fields.Messages;
import org.polarsys.capella.core.ui.properties.helpers.LockHelper;
import org.polarsys.capella.core.ui.toolkit.ToolkitPlugin;

public class BrowseSemanticField
extends AbstractSemanticField {
    protected Button _valueAddBtn;
    protected Button _valueOpenBtn;
    protected Button _valueDelBtn;
    protected Button _valueEditBtn;
    protected Button _valueShortcutBtn;
    protected MenuItem menuitem1;
    protected MenuItem menuitem2;
    protected Menu menu;
    private Text _valueTextField;
    private CLabel _labelTextField;
    private Composite _valueTextContainer;
    private static final int _TEXTFIELD_DEFAULT_WIDTH = 200;

    public BrowseSemanticField(Composite parent_p, String label_p, TabbedPropertySheetWidgetFactory widgetFactory_p, int textFieldSpan_p) {
        super(widgetFactory_p);
        this._labelTextField = this.widgetFactory.createCLabel(parent_p, label_p);
        this.createTextField(parent_p, textFieldSpan_p);
    }

    protected void createDeleteButton(Composite parent_p) {
        ImageRegistry imgRegistry = ToolkitPlugin.getDefault().getImageRegistry();
        Image removeImage = imgRegistry.get("toolitem.remove");
        String tooltip = Messages.BrowseSemanticField_DelBtn;
        this._valueDelBtn = this.createButton(parent_p, removeImage, tooltip);
    }

    protected void createEditButton(Composite parent) {
        ImageRegistry imgRegistry = ToolkitPlugin.getDefault().getImageRegistry();
        Image editImage = imgRegistry.get("toolitem.edit");
        String tooltip = Messages.BrowseSemanticField_EditBtn;
        this._valueEditBtn = this.createButton(parent, editImage, tooltip);
    }

    protected void createOpenButton(Composite parent) {
        ImageRegistry imgRegistry = ToolkitPlugin.getDefault().getImageRegistry();
        Image openImage = imgRegistry.get("toolitem.browse");
        String tooltip = Messages.BrowseSemanticField_BrowseBtn;
        this._valueOpenBtn = this.createButton(parent, openImage, tooltip);
    }

    protected void createAddButton(Composite parent) {
        ImageRegistry imgRegistry = ToolkitPlugin.getDefault().getImageRegistry();
        Image addImage = imgRegistry.get("toolitem.add");
        String tooltip = Messages.BrowseSemanticField_AddBtn;
        this._valueAddBtn = this.createButton(parent, addImage, tooltip);
    }

    protected void createShortcutButton(Composite parent, int cardType) {
        Image image = null;
        switch (cardType) {
            case 0: {
                image = CapellaUIPropertiesPlugin.getDefault().getImage("EOccurrenceZeroToOne.gif");
                break;
            }
            case 1: {
                image = CapellaUIPropertiesPlugin.getDefault().getImage("EOccurrenceOneToUnbounded.gif");
                break;
            }
            case 2: {
                image = CapellaUIPropertiesPlugin.getDefault().getImage("EOccurrenceZero.gif");
                break;
            }
            case 3: {
                image = CapellaUIPropertiesPlugin.getDefault().getImage("EOccurrenceUnbounded.gif");
                break;
            }
        }
        String tooltip = Messages.BrowseSemanticField_ShortcutBtn;
        if (image != null) {
            this._valueShortcutBtn = this.createButton(parent, image, tooltip);
            this.menu = new Menu((Control)this._valueShortcutBtn);
            if (cardType == 0) {
                this.menuitem1 = new MenuItem(this.menu, 0);
                this.menuitem1.setText("0");
                Image imageMenuItem1 = CapellaUIPropertiesPlugin.getDefault().getImage("EOccurrenceZero.gif");
                this.menuitem1.setImage(imageMenuItem1);
                this.menuitem2 = new MenuItem(this.menu, 0);
                this.menuitem2.setText("1");
                Image imageMenuItem2 = CapellaUIPropertiesPlugin.getDefault().getImage("EOccurrenceOne.gif");
                this.menuitem2.setImage(imageMenuItem2);
            } else if (cardType == 1) {
                this.menuitem1 = new MenuItem(this.menu, 0);
                this.menuitem1.setText("1");
                Image imageMenuItem1 = CapellaUIPropertiesPlugin.getDefault().getImage("EOccurrenceOne.gif");
                this.menuitem1.setImage(imageMenuItem1);
                this.menuitem2 = new MenuItem(this.menu, 0);
                this.menuitem2.setText("*");
                Image imageMenuItem2 = CapellaUIPropertiesPlugin.getDefault().getImage("EOccurrenceUnbounded.gif");
                this.menuitem2.setImage(imageMenuItem2);
            } else if (cardType == 2) {
                this.menuitem1 = new MenuItem(this.menu, 0);
                this.menuitem1.setText("0");
                Image imageMenuItem1 = CapellaUIPropertiesPlugin.getDefault().getImage("EOccurrenceZero.gif");
                this.menuitem1.setImage(imageMenuItem1);
            } else if (cardType == 3) {
                this.menuitem1 = new MenuItem(this.menu, 0);
                this.menuitem1.setText("*");
                Image imageMenuItem1 = CapellaUIPropertiesPlugin.getDefault().getImage("EOccurrenceUnbounded.gif");
                this.menuitem1.setImage(imageMenuItem1);
            }
            this._valueShortcutBtn.setMenu(this.menu);
            if (this.menuitem1 != null) {
                this.menuitem1.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent event) {
                        BrowseSemanticField.this.setValueTextField(BrowseSemanticField.this.menuitem1.getText());
                        AbstractReadWriteCommand cmd = new AbstractReadWriteCommand(){

                            public void run() {
                                LiteralNumericValue newValue = DatavalueFactory.eINSTANCE.createLiteralNumericValue("");
                                newValue.setValue((this).BrowseSemanticField.this.menuitem1.getText());
                                (this).BrowseSemanticField.this.semanticElement.eSet((this).BrowseSemanticField.this.semanticFeature, (Object)newValue);
                            }
                        };
                        BrowseSemanticField.this.executeCommand((ICommand)cmd);
                    }
                });
            }
            if (this.menuitem2 != null) {
                this.menuitem2.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent event) {
                        BrowseSemanticField.this.setValueTextField(BrowseSemanticField.this.menuitem2.getText());
                        AbstractReadWriteCommand cmd = new AbstractReadWriteCommand(){

                            public void run() {
                                LiteralNumericValue newValue = DatavalueFactory.eINSTANCE.createLiteralNumericValue("");
                                newValue.setValue((this).BrowseSemanticField.this.menuitem2.getText());
                                (this).BrowseSemanticField.this.semanticElement.eSet((this).BrowseSemanticField.this.semanticFeature, (Object)newValue);
                            }
                        };
                        BrowseSemanticField.this.executeCommand((ICommand)cmd);
                    }
                });
            }
        }
    }

    protected void createTextField(Composite parent, int textFieldSpan) {
        this._valueTextContainer = this.widgetFactory.createComposite(parent);
        GridData gd = new GridData(768);
        gd.horizontalSpan = textFieldSpan;
        this._valueTextContainer.setLayoutData((Object)gd);
        this._valueTextContainer.setLayout((Layout)new GridLayout());
        this._valueTextField = this.widgetFactory.createText(this._valueTextContainer, "");
        gd = new GridData(768);
        gd.horizontalSpan = textFieldSpan;
        gd.widthHint = 200;
        this._valueTextField.setLayoutData((Object)gd);
        this._valueTextField.setEditable(false);
        this._valueTextField.setForeground(this._valueTextField.getDisplay().getSystemColor(16));
    }

    public void enableDeleteButton(boolean status) {
        if (this._valueDelBtn != null && !this._valueDelBtn.isDisposed()) {
            this._valueDelBtn.setEnabled(status);
        }
    }

    public void enableEditButton(boolean status) {
        if (this._valueEditBtn != null && !this._valueEditBtn.isDisposed()) {
            this._valueEditBtn.setEnabled(status);
        }
    }

    public void enableOpenButton(boolean status) {
        if (this._valueOpenBtn != null && !this._valueOpenBtn.isDisposed()) {
            this._valueOpenBtn.setEnabled(status);
        }
    }

    public void enableAddButton(boolean status) {
        if (this._valueAddBtn != null && !this._valueAddBtn.isDisposed()) {
            this._valueAddBtn.setEnabled(status);
        }
    }

    public void enableShortcutButton(boolean status) {
        if (this._valueShortcutBtn != null && !this._valueShortcutBtn.isDisposed()) {
            this._valueAddBtn.setEnabled(status);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        LockHelper.getInstance().enable((Control)this._valueAddBtn, enabled);
        LockHelper.getInstance().enable((Control)this._valueDelBtn, enabled);
        LockHelper.getInstance().enable((Control)this._valueEditBtn, enabled);
        LockHelper.getInstance().enable((Control)this._valueOpenBtn, enabled);
        LockHelper.getInstance().enable((Control)this._valueShortcutBtn, enabled);
        LockHelper.getInstance().update((Control)this._valueTextField, enabled);
    }

    protected void setVisibleDeleteButton(boolean status) {
        if (this._valueDelBtn != null) {
            this._valueDelBtn.setVisible(status);
        }
    }

    protected void setVisibleEditButton(boolean status) {
        if (this._valueEditBtn != null) {
            this._valueEditBtn.setVisible(status);
        }
    }

    protected void setVisibleOpenButton(boolean status) {
        if (this._valueOpenBtn != null) {
            this._valueOpenBtn.setVisible(status);
        }
    }

    protected void setVisibleAddButton(boolean status) {
        if (this._valueAddBtn != null) {
            this._valueAddBtn.setVisible(status);
        }
    }

    protected void setVisibleShortcutButton(boolean status) {
        if (this._valueShortcutBtn != null) {
            this._valueShortcutBtn.setVisible(status);
        }
    }

    public void setVisible(boolean status) {
        this.setVisibleAddButton(status);
        this.setVisibleDeleteButton(status);
        this.setVisibleEditButton(status);
        this.setVisibleOpenButton(status);
        this.setVisibleShortcutButton(status);
        if (this._valueTextField != null) {
            this._valueTextField.setVisible(status);
        }
        if (this._labelTextField != null) {
            this._labelTextField.setVisible(status);
        }
    }

    @Override
    public void loadData(EObject semanticElement) {
        this.loadData(semanticElement, this.semanticFeature);
    }

    public String getValueTextField() {
        if (this._valueTextField != null) {
            return this._valueTextField.getText();
        }
        return null;
    }

    public String getFullLabel(EObject eObject) {
        if (eObject instanceof ModelElement) {
            String path = ((ModelElement)eObject).getFullLabel();
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            String string = path.replaceAll("/", "::");
        }
        return null;
    }

    public void setValueTextField(Object object) {
        if (this._valueTextField == null) {
            return;
        }
        if (object != null) {
            if (object instanceof String) {
                this._valueTextField.setText((String)object);
            } else if (object instanceof EObject) {
                this._valueTextField.setText(NamingHelper.getValue((EObject)((EObject)object), (EStructuralFeature)this.semanticFeature));
                this._valueTextContainer.setToolTipText(this.getFullLabel((EObject)object));
            } else if (object instanceof Collection) {
                this._valueTextField.setText(EObjectExt2.formatValues((Collection)((Collection)object), (EStructuralFeature)this.semanticFeature));
            }
        } else {
            this._valueTextField.setText(Messages.UndefinedValue);
        }
    }

    protected boolean isLoaded() {
        return !this._valueTextField.getText().equals(Messages.UndefinedValue);
    }

    public void setLabel(String label) {
        if (this._labelTextField != null) {
            this._labelTextField.setText(label);
        }
    }

    @Override
    public void widgetSelected(SelectionEvent event) {
        Object source;
        if (event != null && (source = event.getSource()) != null) {
            if (source.equals(this._valueOpenBtn)) {
                this.handleOpenButtonClicked(this._valueOpenBtn);
            } else if (source.equals(this._valueDelBtn)) {
                this.handleDeleteButtonClicked();
            } else if (source.equals(this._valueShortcutBtn)) {
                this.handleShortcutButtonClicked();
            } else if (source.equals(this._valueEditBtn)) {
                try {
                    this.handleEditButtonClicked();
                }
                catch (EditableSemanticFieldException editableSemanticFieldException) {}
            } else if (this._valueAddBtn.equals(source)) {
                try {
                    this.handleAddButtonClicked();
                }
                catch (EditableSemanticFieldException editableSemanticFieldException) {
                    // empty catch block
                }
            }
        }
    }

    protected void handleOpenButtonClicked(Button button) {
    }

    protected void handleDeleteButtonClicked() {
        AbstractReadWriteCommand command = this.getDeleteCommand(this.semanticElement, this.semanticFeature);
        this.executeCommand((ICommand)command);
    }

    protected void handleEditButtonClicked() throws EditableSemanticFieldException {
    }

    protected void handleAddButtonClicked() throws EditableSemanticFieldException {
    }

    protected void handleShortcutButtonClicked() throws EditableSemanticFieldException {
        if (this.menu != null) {
            this.menu.setVisible(true);
        }
    }

    protected AbstractReadWriteCommand getDeleteCommand(final EObject element, final EStructuralFeature feature) {
        return new AbstractReadWriteCommand(){

            public void run() {
                BrowseSemanticField.this.doDeleteCommand(element, feature);
            }
        };
    }

    protected void doDeleteCommand(EObject element, EStructuralFeature feature) {
        if (feature.isMany()) {
            this.removeAllDataValue(element, feature);
        } else {
            this.setDataValue(element, feature, null);
        }
        if (this._valueEditBtn != null) {
            this._valueEditBtn.setEnabled(true);
        }
        this.setValueTextField(null);
    }
}

