/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.ui.properties.fields;

import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.polarsys.capella.core.ui.properties.fields.TextValueGroup;

public class IntegerValueGroup
extends TextValueGroup
implements VerifyListener {
    public IntegerValueGroup(Composite parent, String label, TabbedPropertySheetWidgetFactory widgetFactory) {
        this(parent, label, widgetFactory, false, false);
    }

    public IntegerValueGroup(Composite parent, String label, TabbedPropertySheetWidgetFactory widgetFactory, boolean skipGroup) {
        this(parent, label, widgetFactory, false, skipGroup);
    }

    public IntegerValueGroup(Composite parent, String label, TabbedPropertySheetWidgetFactory widgetFactory, boolean hasResetBtn, boolean skipGroup) {
        super(parent, label, widgetFactory, hasResetBtn, skipGroup);
    }

    @Override
    protected void addListeners() {
        this.valueField.addFocusListener((FocusListener)this);
        this.valueField.addKeyListener((KeyListener)this);
        this.valueField.addVerifyListener((VerifyListener)this);
    }

    public void verifyText(VerifyEvent e) {
        String currentText = ((Text)e.widget).getText();
        String newText = currentText.substring(0, e.start) + e.text + currentText.substring(e.end);
        if ("".equals(newText)) {
            e.doit = true;
            ((Text)e.widget).setText("0");
            return;
        }
        try {
            Integer.toString(Integer.parseInt(newText));
            e.doit = true;
        }
        catch (NumberFormatException ex) {
            e.doit = false;
        }
    }

    @Override
    protected void handleResetButtonClicked(Button button) {
        this.setDataValue(this.semanticElement, this.semanticFeature, "0");
        this.setTextValue(this.valueField, this.semanticElement, this.semanticFeature);
    }

    @Override
    protected void updateResetBtnStatus() {
        if (this.valueResetBtn != null) {
            this.valueResetBtn.setEnabled(this.semanticElement.eGet(this.semanticFeature) != null && !this.semanticElement.eGet(this.semanticFeature).equals("0"));
        }
    }
}

