/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.actions.pinning;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gef.Disposable;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.sirius.common.ui.tools.api.util.EclipseUIUtil;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.tools.api.layout.PinHelper;
import org.eclipse.sirius.diagram.tools.internal.commands.PinElementsCommand;
import org.eclipse.sirius.diagram.tools.internal.commands.UnpinElementsCommand;
import org.eclipse.sirius.diagram.ui.provider.DiagramUIPlugin;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.ecore.extender.business.api.permission.IAuthorityListener;
import org.eclipse.sirius.ecore.extender.business.api.permission.IPermissionAuthority;
import org.eclipse.sirius.ecore.extender.business.api.permission.ISimpleAuthorityListener;
import org.eclipse.sirius.ecore.extender.business.api.permission.PermissionAuthorityRegistry;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPage;

public final class PinElementsAction
extends Action
implements Disposable {
    private Map<DDiagramElement, ResourceSetListener> selectionElements;
    private Set<ResourceSet> selectionResourceSets;
    private ISelectionListener onChangeSelection = (part, selection) -> EclipseUIUtil.displaySyncExec(() -> this.updateActionState(selection));
    private ISimpleAuthorityListener authorityListener = () -> EclipseUIUtil.displaySyncExec(() -> this.updateActionState(this.getCurrentSelection()));
    private boolean isDisposed;

    private PinElementsAction() {
        super(Messages.PinElementsEclipseAction_text, 2);
        this.setId("pinElementsAction");
        IWorkbenchPage page = EclipseUIUtil.getActivePage();
        if (page != null) {
            page.addSelectionListener(this.onChangeSelection);
        }
        this.updateActionState(this.getCurrentSelection());
        this.isDisposed = false;
    }

    public static PinElementsAction createForToolbar() {
        PinElementsAction action = new PinElementsAction();
        action.setToolTipText(Messages.PinElementsEclipseAction_text);
        action.setImageDescriptor(DiagramUIPlugin.Implementation.getBundledImageDescriptor("icons/pin.gif"));
        return action;
    }

    public static PinElementsAction createForMenu() {
        PinElementsAction action = new PinElementsAction();
        action.setToolTipText(Messages.PinElementsEclipseAction_tooltip);
        return action;
    }

    public void run() {
        Set<DDiagramElement> elements = this.getSelectedDiagramElements(this.getCurrentSelection()).keySet();
        if (!elements.isEmpty()) {
            Object cmd = this.isChecked() ? new PinElementsCommand(elements) : new UnpinElementsCommand(elements);
            TransactionUtil.getEditingDomain((EObject)((EObject)this.getAny(elements).orElseThrow())).getCommandStack().execute((Command)cmd);
        }
    }

    public void dispose() {
        if (!this.isDisposed) {
            this.removePinListener();
            this.authorityListener = null;
            IWorkbenchPage page = EclipseUIUtil.getActivePage();
            if (page != null) {
                page.removeSelectionListener(this.onChangeSelection);
                this.onChangeSelection = null;
            }
            this.isDisposed = true;
        }
    }

    private void updateActionState(ISelection selection) {
        this.removePinListener();
        this.setEnabled(this.isAvailableFor(selection));
        this.selectionElements = this.getSelectedDiagramElements(selection);
        this.updatePinState();
        this.addPinListener();
    }

    private void addPinListener() {
        if (this.selectionElements != null) {
            this.selectionResourceSets = new LinkedHashSet<ResourceSet>();
            this.selectionElements = this.selectionElements.keySet().stream().mapMulti((elem, consumer) -> {
                TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)elem);
                if (domain != null) {
                    ResourceSetListener pinListener = new PinHelper().createPinListener(elem, () -> EclipseUIUtil.displayAsyncExec(this::updatePinState));
                    domain.addResourceSetListener(pinListener);
                    Resource resource = elem.eResource();
                    if (resource != null) {
                        this.selectionResourceSets.add(resource.getResourceSet());
                    }
                    consumer.accept(Map.entry(elem, pinListener));
                }
            }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            for (ResourceSet resourceSet : this.selectionResourceSets) {
                IPermissionAuthority permissionAuthoriry = PermissionAuthorityRegistry.getDefault().getPermissionAuthority(resourceSet);
                permissionAuthoriry.addAuthorityListener((IAuthorityListener)this.authorityListener);
            }
        }
    }

    private void removePinListener() {
        if (this.selectionElements != null) {
            for (ResourceSet resourceSet : this.selectionResourceSets) {
                IPermissionAuthority permissionAuthoriry = PermissionAuthorityRegistry.getDefault().getPermissionAuthority(resourceSet);
                permissionAuthoriry.removeAuthorityListener((IAuthorityListener)this.authorityListener);
            }
            for (Map.Entry entry : this.selectionElements.entrySet()) {
                DDiagramElement element = (DDiagramElement)entry.getKey();
                ResourceSetListener pinListener = (ResourceSetListener)entry.getValue();
                TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)element);
                if (domain == null) continue;
                domain.removeResourceSetListener(pinListener);
            }
            this.selectionResourceSets = null;
            this.selectionElements = null;
        }
    }

    private void updatePinState() {
        boolean isPinned = !this.selectionElements.isEmpty() && this.selectionElements.keySet().stream().allMatch(elem -> new PinHelper().isPinned(elem));
        this.setChecked(isPinned);
    }

    /*
     * WARNING - void declaration
     */
    private Map<DDiagramElement, ResourceSetListener> getSelectedDiagramElements(ISelection selection) {
        ISelection iSelection = selection;
        if (iSelection instanceof IStructuredSelection) {
            void structuredSelection;
            IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
            IStructuredSelection cfr_ignored_0 = (IStructuredSelection)iSelection;
            void iterableSelection = structuredSelection;
            return StreamSupport.stream(iterableSelection.spliterator(), false).filter(IGraphicalEditPart.class::isInstance).map(IGraphicalEditPart.class::cast).map(IGraphicalEditPart::resolveSemanticElement).filter(DDiagramElement.class::isInstance).map(DDiagramElement.class::cast).collect(HashMap::new, (map, element) -> {
                Object v0 = map.put(element, null);
            }, Map::putAll);
        }
        return Map.of();
    }

    private ISelection getCurrentSelection() {
        IWorkbenchPage page = EclipseUIUtil.getActivePage();
        if (page != null) {
            return page.getSelection();
        }
        return StructuredSelection.EMPTY;
    }

    private boolean isAvailableFor(ISelection selection) {
        Set<DDiagramElement> selectedDiagramElements = this.getSelectedDiagramElements(selection).keySet();
        if (!selectedDiagramElements.isEmpty()) {
            return selectedDiagramElements.stream().allMatch(this::canPinUnpin);
        }
        return false;
    }

    private boolean canEditElement(DDiagramElement dDiagramElement) {
        Resource resource = dDiagramElement.eResource();
        if (resource == null) {
            return false;
        }
        IPermissionAuthority permissionAuthoriry = PermissionAuthorityRegistry.getDefault().getPermissionAuthority(resource.getResourceSet());
        return permissionAuthoriry.canEditInstance((EObject)dDiagramElement.getParentDiagram());
    }

    private boolean canPinUnpin(DDiagramElement dDiagramElement) {
        return PinHelper.allowsPinUnpin((DDiagramElement)dDiagramElement) && this.canEditElement(dDiagramElement);
    }

    private Optional<DDiagramElement> getAny(Collection<DDiagramElement> elements) {
        return elements.stream().findAny();
    }
}

