/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.ui.navigator.actions;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.polarsys.capella.common.ui.toolkit.dialogs.OpenRepresentationDialog;
import org.polarsys.capella.core.commands.preferences.ui.sirius.DoubleClickBehaviourUtil;
import org.polarsys.capella.core.model.handler.helpers.RepresentationHelper;
import org.polarsys.capella.core.platform.sirius.ui.navigator.actions.Messages;
import org.polarsys.capella.core.sirius.ui.actions.NewRepresentationAction;
import org.polarsys.capella.core.sirius.ui.actions.OpenRepresentationsAction;
import org.polarsys.capella.core.sirius.ui.actions.SelectNewRepresentationAction;

public class OpenRelatedDiagramAction {
    EObject target;

    public OpenRelatedDiagramAction(EObject target) {
        this.target = DoubleClickBehaviourUtil.INSTANCE.getTargetSemanticElement(target);
    }

    public void run() {
        Collection representations = RepresentationHelper.getAllRepresentationDescriptorsTargetedBy(Collections.singleton(this.target));
        if (!representations.isEmpty()) {
            if (representations.size() > 1) {
                Shell activeShell = Display.getDefault().getActiveShell();
                OpenRepresentationDialog dialog = new OpenRepresentationDialog(activeShell, representations);
                dialog.open();
                if (dialog.getReturnCode() == 0) {
                    new OpenRepresentationsAction(dialog.getSelectedDescriptor()).run();
                }
            } else {
                DRepresentationDescriptor descriptor = (DRepresentationDescriptor)representations.toArray()[0];
                new OpenRepresentationsAction(descriptor).run();
            }
        } else {
            Session currentSession = SessionManager.INSTANCE.getSession(this.target);
            Collection selectedViewpoints = currentSession.getSelectedViewpoints(false);
            Collection descriptions = DialectManager.INSTANCE.getAvailableRepresentationDescriptions(selectedViewpoints, this.target);
            if (!descriptions.isEmpty()) {
                if (descriptions.size() > 1) {
                    new SelectNewRepresentationAction(descriptions, this.target, currentSession, Messages.OpenRelatedDiagram_Message).run();
                } else {
                    RepresentationDescription description = (RepresentationDescription)descriptions.iterator().next();
                    new NewRepresentationAction(description, this.target, currentSession, Messages.OpenRelatedDiagram_Message).run();
                }
            }
        }
    }
}

