/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.ui.navigator.actions.providers;

import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.CloseResourceAction;
import org.eclipse.ui.actions.CloseUnrelatedProjectsAction;
import org.eclipse.ui.actions.OpenResourceAction;
import org.eclipse.ui.ide.IDEActionFactory;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;
import org.polarsys.capella.core.platform.sirius.ui.navigator.actions.CapellaEditActionGroup;
import org.polarsys.capella.core.platform.sirius.ui.navigator.actions.RefreshAction;
import org.polarsys.capella.core.sirius.ui.helper.SessionHelper;

public class ProjectActionProvider
extends CommonActionProvider {
    private OpenResourceAction openProjectAction;
    private CloseResourceAction closeProjectAction;
    private CloseUnrelatedProjectsAction closeUnrelatedProjectsAction;
    private RefreshAction refreshAction;
    private Shell shell;
    private CapellaEditActionGroup editActionGroup;

    public void fillActionBars(IActionBars actionBars) {
        actionBars.setGlobalActionHandler(ActionFactory.REFRESH.getId(), (IAction)this.refreshAction);
        actionBars.setGlobalActionHandler(IDEActionFactory.OPEN_PROJECT.getId(), (IAction)this.openProjectAction);
        if (this.openProjectAction.isEnabled()) {
            actionBars.setGlobalActionHandler("org.eclipse.ui.navigator.Open", (IAction)this.openProjectAction);
        }
        actionBars.setGlobalActionHandler(IDEActionFactory.CLOSE_PROJECT.getId(), (IAction)this.closeProjectAction);
        actionBars.setGlobalActionHandler(IDEActionFactory.CLOSE_UNRELATED_PROJECTS.getId(), (IAction)this.closeUnrelatedProjectsAction);
        this.updateActionBars();
        this.editActionGroup.fillActionBars(actionBars);
    }

    public void fillContextMenu(IMenuManager menu) {
        IStructuredSelection selection = (IStructuredSelection)this.getContext().getSelection();
        boolean isProjectSelection = true;
        boolean hasOpenProjects = false;
        boolean hasClosedProjects = false;
        for (Object next : selection) {
            IProject project = null;
            if (next instanceof IProject) {
                project = (IProject)next;
            } else if (next instanceof IAdaptable) {
                project = (IProject)((IAdaptable)next).getAdapter(IProject.class);
            }
            if (project == null) {
                isProjectSelection = false;
                continue;
            }
            if (project.isOpen()) {
                hasOpenProjects = true;
                continue;
            }
            hasClosedProjects = true;
        }
        if (!hasClosedProjects) {
            this.refreshAction.selectionChanged(selection);
            menu.appendToGroup("group.build", (IAction)this.refreshAction);
        }
        if (isProjectSelection) {
            if (hasClosedProjects) {
                this.openProjectAction.selectionChanged(selection);
                menu.appendToGroup("group.build", (IAction)this.openProjectAction);
            }
            if (hasOpenProjects) {
                this.closeProjectAction.selectionChanged(selection);
                menu.appendToGroup("group.build", (IAction)this.closeProjectAction);
                this.closeUnrelatedProjectsAction.selectionChanged(selection);
                menu.appendToGroup("group.build", (IAction)this.closeUnrelatedProjectsAction);
            }
        }
        this.editActionGroup.fillContextMenu(menu);
    }

    protected ImageDescriptor getImageDescriptor(String relativePath) {
        return IDEWorkbenchPlugin.getIDEImageDescriptor((String)relativePath);
    }

    public void init(ICommonActionExtensionSite site) {
        super.init(site);
        this.shell = site.getViewSite().getShell();
        this.makeActions();
        this.editActionGroup = new CapellaEditActionGroup(this.shell);
    }

    protected void makeActions() {
        this.openProjectAction = new OpenResourceAction(this.shell);
        this.closeProjectAction = new CloseResourceAction(this.shell){

            public void run() {
                SessionHelper.closeUiSessions((List)this.getSelectedResources());
                super.run();
            }
        };
        this.closeUnrelatedProjectsAction = new CloseUnrelatedProjectsAction(this.shell);
        this.refreshAction = new RefreshAction(this.shell);
        this.refreshAction.setDisabledImageDescriptor(this.getImageDescriptor("dlcl16/refresh_nav.gif"));
        this.refreshAction.setImageDescriptor(this.getImageDescriptor("elcl16/refresh_nav.gif"));
        this.refreshAction.setActionDefinitionId("org.eclipse.ui.file.refresh");
    }

    public void setContext(ActionContext context) {
        super.setContext(context);
        this.editActionGroup.setContext(context);
    }

    public void updateActionBars() {
        IStructuredSelection selection = (IStructuredSelection)this.getContext().getSelection();
        this.refreshAction.selectionChanged(selection);
        this.openProjectAction.selectionChanged(selection);
        this.closeUnrelatedProjectsAction.selectionChanged(selection);
        this.closeProjectAction.selectionChanged(selection);
        this.editActionGroup.updateActionBars();
    }
}

