/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.ui.navigator.viewer;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.polarsys.capella.common.platform.sirius.ted.SemanticEditingDomainFactory;

public class ActiveSessionManager {
    final Map<TransactionalEditingDomain, Boolean> _activeSessions = new HashMap<TransactionalEditingDomain, Boolean>();
    private boolean isFullDisabled = false;

    private ActiveSessionManager() {
    }

    public static ActiveSessionManager getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public void disableContentNotifications(SemanticEditingDomainFactory.SemanticEditingDomain editingDomain) {
        this._activeSessions.put((TransactionalEditingDomain)editingDomain, Boolean.FALSE);
    }

    public void disableContentNotifications() {
        this.isFullDisabled = true;
        for (TransactionalEditingDomain key : this._activeSessions.keySet()) {
            this._activeSessions.put(key, Boolean.FALSE);
        }
    }

    public void enableContentNotifications(SemanticEditingDomainFactory.SemanticEditingDomain editingDomain) {
        this._activeSessions.put((TransactionalEditingDomain)editingDomain, Boolean.TRUE);
    }

    public void enableContentNotifications() {
        this.isFullDisabled = false;
        for (TransactionalEditingDomain key : this._activeSessions.keySet()) {
            this._activeSessions.put(key, Boolean.TRUE);
        }
    }

    public boolean isEnabledContentNotifications(TransactionalEditingDomain editingDomain) {
        if (this.isFullDisabled) {
            return false;
        }
        if (editingDomain == null) {
            return true;
        }
        if (!this._activeSessions.containsKey(editingDomain)) {
            return true;
        }
        return this._activeSessions.get(editingDomain);
    }

    public void remove(TransactionalEditingDomain editingDomain) {
        this._activeSessions.remove(editingDomain);
    }

    private static class SingletonHolder {
        private static final ActiveSessionManager INSTANCE = new ActiveSessionManager();

        private SingletonHolder() {
        }
    }
}

