/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.ui.navigator.viewer;

import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.UIJob;
import org.polarsys.capella.common.ef.domain.IEditingDomainListener;
import org.polarsys.capella.common.platform.sirius.ted.SemanticEditingDomainFactory;
import org.polarsys.capella.core.platform.sirius.ui.navigator.viewer.ActiveSessionManager;
import org.polarsys.capella.core.platform.sirius.ui.navigator.viewer.ICommandStackSelectionProvider;
import org.polarsys.capella.core.platform.sirius.ui.navigator.viewer.NavigatorCommandStackListener;
import org.polarsys.capella.core.platform.sirius.ui.navigator.viewer.NavigatorModelDataListener;

public class NavigatorEditingDomainDispatcher
implements IEditingDomainListener,
INotifyChangedListener,
ICommandStackSelectionProvider {
    private static Collection<INotifyChangedListener> _notifyListeners = new HashSet<INotifyChangedListener>();
    private static Collection<ICommandStackSelectionProvider> _commandStackListeners = new HashSet<ICommandStackSelectionProvider>();
    private NavigatorModelDataListener _dataListener = new NavigatorModelDataListener(this);
    private NavigatorCommandStackListener _csListener = new NavigatorCommandStackListener(this);

    public void createdEditingDomain(EditingDomain editingDomain) {
        this._dataListener.registerToDataNotifier((SemanticEditingDomainFactory.SemanticEditingDomain)editingDomain);
        this._csListener.registerCommandStackListener((SemanticEditingDomainFactory.SemanticEditingDomain)editingDomain);
    }

    public void disposedEditingDomain(EditingDomain editingDomain) {
        this._dataListener.unregisterFromDataNotifier((SemanticEditingDomainFactory.SemanticEditingDomain)editingDomain);
        this._csListener.unregisterCommandStackListener((SemanticEditingDomainFactory.SemanticEditingDomain)editingDomain);
        ActiveSessionManager.getInstance().remove((TransactionalEditingDomain)((SemanticEditingDomainFactory.SemanticEditingDomain)editingDomain));
    }

    public void notifyChanged(Notification notification) {
        for (INotifyChangedListener provider : _notifyListeners) {
            provider.notifyChanged(notification);
        }
    }

    @Override
    public void commandStackSelectionChanged(final ISelection selection) {
        UIJob job = new UIJob(PlatformUI.getWorkbench().getDisplay(), this.getClass().getName()){

            public IStatus runInUIThread(IProgressMonitor monitor_p) {
                for (ICommandStackSelectionProvider provider : _commandStackListeners) {
                    provider.commandStackSelectionChanged(selection);
                }
                return Status.OK_STATUS;
            }
        };
        job.setPriority(50);
        job.schedule();
    }

    public static void registerNotifyChangedListener(INotifyChangedListener listener) {
        _notifyListeners.add(listener);
    }

    public static void unregisterNotifyChangedListener(INotifyChangedListener listener) {
        _notifyListeners.remove(listener);
    }

    public static void registerCommandStackSelectionProvider(ICommandStackSelectionProvider listener) {
        _commandStackListeners.add(listener);
    }

    public static void unregisterCommandStackSelectionProvider(ICommandStackSelectionProvider listener) {
        _commandStackListeners.remove(listener);
    }
}

