/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.flexibility.wizards.renderer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.polarsys.capella.common.flexibility.properties.schema.IProperties;
import org.polarsys.capella.common.flexibility.properties.schema.IProperty;
import org.polarsys.capella.common.flexibility.properties.schema.IPropertyGroup;
import org.polarsys.capella.common.flexibility.wizards.loader.ILoadableRenderers;
import org.polarsys.capella.common.flexibility.wizards.schema.IGroupRenderer;
import org.polarsys.capella.common.flexibility.wizards.schema.IPropertyRenderer;
import org.polarsys.capella.common.flexibility.wizards.schema.IRenderers;

public class Renderers
implements IRenderers,
ILoadableRenderers {
    private HashMap<String, IPropertyRenderer> propertyRenderers;
    private HashMap<String, IGroupRenderer> groupRenderers;
    private Collection<IRenderers> parents;

    protected HashMap<String, IPropertyRenderer> getMapPropertyRenderers() {
        if (this.propertyRenderers == null) {
            this.propertyRenderers = new HashMap();
        }
        return this.propertyRenderers;
    }

    protected HashMap<String, IGroupRenderer> getMapGroupRenderers() {
        if (this.groupRenderers == null) {
            this.groupRenderers = new HashMap();
        }
        return this.groupRenderers;
    }

    public Collection<IRenderers> getParents() {
        if (this.parents == null) {
            this.parents = new ArrayList<IRenderers>();
        }
        return this.parents;
    }

    @Override
    public void addParent(IRenderers parent) {
        if (!this.getParents().contains(parent)) {
            this.getParents().add(parent);
        }
    }

    @Override
    public void addGroupRenderer(String group, IGroupRenderer renderer) {
        this.getMapGroupRenderers().put(group, renderer);
    }

    @Override
    public void addPropertyRenderer(String property, IPropertyRenderer renderer) {
        this.getMapPropertyRenderers().put(property, renderer);
    }

    @Override
    public IPropertyRenderer createRenderer(IProperty property) {
        if (this.getMapPropertyRenderers().containsKey(property.getId())) {
            return this.getMapPropertyRenderers().get(property.getId());
        }
        for (IRenderers parent : this.getParents()) {
            IPropertyRenderer result = parent.createRenderer(property);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public Collection<IPropertyRenderer> getPropertyRenderers() {
        return this.getMapPropertyRenderers().values();
    }

    @Override
    public Collection<IPropertyGroup> getGroups(IProperties properties, IPropertyGroup group) {
        if (properties == null) {
            return Collections.emptyList();
        }
        List values = properties.getGroups(group);
        ArrayList<IPropertyGroup> result = new ArrayList<IPropertyGroup>(values);
        return result;
    }

    @Override
    public Collection<IProperty> getItems(IProperties properties, IPropertyGroup group) {
        if (properties == null) {
            return Collections.emptyList();
        }
        List values = properties.getItems(group);
        ArrayList<IProperty> result = new ArrayList<IProperty>(values);
        return result;
    }

    @Override
    public Collection<IGroupRenderer> getGroupRenderers() {
        return this.getMapGroupRenderers().values();
    }

    @Override
    public IGroupRenderer createRenderer(IPropertyGroup propertyGroup) {
        if (this.getMapGroupRenderers().containsKey(propertyGroup.getId())) {
            return this.getMapGroupRenderers().get(propertyGroup.getId());
        }
        for (IRenderers parent : this.getParents()) {
            IGroupRenderer result = parent.createRenderer(propertyGroup);
            if (result == null) continue;
            return result;
        }
        return null;
    }
}

