/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.transition.common.handlers.session;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.business.api.session.resource.AirdResource;
import org.eclipse.sirius.viewpoint.DAnalysis;
import org.polarsys.capella.core.transition.common.handlers.session.ISessionHandler;
import org.polarsys.kitalpha.transposer.rules.handler.rules.api.IContext;

public class DefaultSessionHandler
implements ISessionHandler {
    @Override
    public IStatus init(IContext context) {
        return Status.OK_STATUS;
    }

    @Override
    public IStatus dispose(IContext context) {
        return Status.OK_STATUS;
    }

    @Override
    public EObject getEObjectFromId(String id, IContext context) {
        EObject element = null;
        if (id != null) {
            Iterator<Resource> resources = this.getRelatedResources(context).iterator();
            while (resources.hasNext() && element == null) {
                Resource resource = resources.next();
                element = resource.getEObject(id);
            }
        }
        return element;
    }

    protected Collection<Resource> getRelatedResources(IContext context) {
        EObject root = (EObject)context.get((Object)"_TSRo");
        if (root != null) {
            HashSet<Resource> resources = new HashSet<Resource>();
            Session session = SessionManager.INSTANCE.getSession(root);
            if (session != null) {
                HashSet sessionResources = new HashSet();
                if (session.getSemanticResources() != null) {
                    sessionResources.addAll(session.getSemanticResources());
                }
                if (session.getReferencedSessionResources() != null) {
                    sessionResources.addAll(session.getReferencedSessionResources());
                }
                for (Resource resource : sessionResources) {
                    if (!(resource instanceof AirdResource)) {
                        resources.add(resource);
                        continue;
                    }
                    for (EObject rootAird : ((AirdResource)resource).getContents()) {
                        DAnalysis analysis;
                        if (!(rootAird instanceof DAnalysis) || (analysis = (DAnalysis)rootAird).getModels() == null) continue;
                        for (EObject model : analysis.getModels()) {
                            if (model == null || model.eIsProxy() || model.eResource() == null) continue;
                            resources.add(model.eResource());
                        }
                    }
                }
                return resources;
            }
        }
        if (root != null) {
            return Collections.singletonList(root.eResource());
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public String getId(EObject element, IContext context) {
        String id;
        if (element == null) {
            return null;
        }
        EAttribute attribute = element.eClass().getEIDAttribute();
        if (attribute != null && (id = (String)element.eGet((EStructuralFeature)attribute)) != null) {
            return id;
        }
        if (element.eResource() != null) {
            return element.eResource().getURIFragment(element);
        }
        return EcoreUtil.getID((EObject)element);
    }
}

