/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.transition.common.handlers.traceability;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.core.transition.common.handlers.traceability.ITraceabilityHandler;
import org.polarsys.capella.core.transition.common.handlers.traceability.ITraceabilityTraceHandler;
import org.polarsys.capella.core.transition.common.handlers.traceability.config.ITraceabilityConfiguration;
import org.polarsys.kitalpha.transposer.rules.handler.rules.api.IContext;

public class CompoundTraceabilityHandler
implements ITraceabilityHandler,
ITraceabilityTraceHandler {
    private ITraceabilityConfiguration configuration;

    public ITraceabilityConfiguration getConfiguration() {
        return this.configuration;
    }

    public CompoundTraceabilityHandler(ITraceabilityConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public IStatus init(IContext context) {
        this.configuration.init(context);
        return Status.OK_STATUS;
    }

    @Override
    public IStatus dispose(IContext context) {
        if (this.configuration != null) {
            this.configuration.dispose(context);
        }
        return Status.OK_STATUS;
    }

    @Override
    public void attachTraceability(EObject sourceElement, EObject targetElement, IContext context) {
        if (this.configuration != null) {
            for (ITraceabilityHandler handler : this.configuration.getDefinedHandlers(context)) {
                if (!this.configuration.useHandlerForAttachment(sourceElement, targetElement, handler, context)) continue;
                handler.attachTraceability(sourceElement, targetElement, context);
            }
        }
    }

    @Override
    public Collection<EObject> retrieveTracedElements(EObject source, IContext context) {
        context.put((Object)"TH", (Object)this);
        ArrayList<EObject> result = new ArrayList<EObject>();
        if (this.configuration != null) {
            for (ITraceabilityHandler handler : this.configuration.getDefinedHandlers(context)) {
                Collection<EObject> elements;
                if (!this.configuration.useHandlerForTracedElements(source, handler, context) || (elements = handler.retrieveTracedElements(source, context)) == null || elements.isEmpty()) continue;
                for (EObject object : elements) {
                    if (result.contains(object)) continue;
                    result.add(object);
                }
            }
        }
        return result;
    }

    @Override
    public Collection<EObject> retrieveSourceElements(EObject source, IContext context) {
        context.put((Object)"TH", (Object)this);
        ArrayList<EObject> result = new ArrayList<EObject>();
        if (this.configuration != null) {
            for (ITraceabilityHandler handler : this.configuration.getDefinedHandlers(context)) {
                Collection<EObject> elements;
                if (!this.configuration.useHandlerForSourceElements(source, handler, context) || (elements = handler.retrieveSourceElements(source, context)) == null || elements.isEmpty()) continue;
                for (EObject object : elements) {
                    if (result.contains(object)) continue;
                    result.add(object);
                }
            }
        }
        return result;
    }

    @Override
    @Deprecated
    public Collection<EObject> retrieveTracedElements(EObject source, IContext context, EClass clazz) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        for (EObject obj : this.retrieveTracedElements(source, context)) {
            if (!clazz.isInstance((Object)obj)) continue;
            result.add(obj);
        }
        return result;
    }

    @Override
    @Deprecated
    public boolean isTraced(EObject element, IContext context) {
        return !this.retrieveTracedElements(element, context).isEmpty();
    }

    @Override
    @Deprecated
    public String getId(EObject element, IContext context) {
        if (this.configuration != null) {
            for (ITraceabilityHandler handler : this.configuration.getDefinedHandlers(context)) {
                String id = handler.getId(element, context);
                if (id == null) continue;
                return id;
            }
        }
        return "";
    }

    @Override
    public boolean isTrace(EObject element, IContext context) {
        if (this.configuration != null) {
            for (ITraceabilityHandler handler : this.configuration.getDefinedHandlers(context)) {
                ITraceabilityTraceHandler tHandler;
                if (!(handler instanceof ITraceabilityTraceHandler) || !(tHandler = (ITraceabilityTraceHandler)handler).isTrace(element, context)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public EObject getSourceElement(EObject trace, IContext context) {
        if (this.configuration != null) {
            for (ITraceabilityHandler handler : this.configuration.getDefinedHandlers(context)) {
                ITraceabilityTraceHandler tHandler;
                EObject result;
                if (!(handler instanceof ITraceabilityTraceHandler) || (result = (tHandler = (ITraceabilityTraceHandler)handler).getSourceElement(trace, context)) == null) continue;
                return result;
            }
        }
        return null;
    }

    @Override
    public EObject getTargetElement(EObject trace, IContext context) {
        if (this.configuration != null) {
            for (ITraceabilityHandler handler : this.configuration.getDefinedHandlers(context)) {
                ITraceabilityTraceHandler tHandler;
                EObject result;
                if (!(handler instanceof ITraceabilityTraceHandler) || (result = (tHandler = (ITraceabilityTraceHandler)handler).getTargetElement(trace, context)) == null) continue;
                return result;
            }
        }
        return null;
    }
}

