/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.transition.common.handlers.traceability;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.core.transition.common.handlers.traceability.ITraceabilityHandler;
import org.polarsys.capella.core.transition.common.handlers.traceability.MappingTraceability;
import org.polarsys.capella.core.transition.common.handlers.traceability.TraceabilityHandlerHelper;
import org.polarsys.capella.core.transition.common.handlers.traceability.TwoSideTraceabilityHandler;
import org.polarsys.kitalpha.transposer.rules.handler.rules.api.IContext;

public class LevelBasedTraceabilityHandler
extends TwoSideTraceabilityHandler {
    public LevelBasedTraceabilityHandler(String identifier) {
        super(identifier);
    }

    @Override
    protected Collection<EObject> retrieveRelatedElements(EObject source, IContext context, MappingTraceability maps) {
        Collection<Object> mapped = null;
        if (maps.contains(source)) {
            mapped = maps.get(source);
        } else if (maps instanceof LevelMappingTraceability) {
            this.initializeMappings(source, context, (LevelMappingTraceability)maps);
            mapped = maps.get(source);
        }
        if (mapped != null) {
            return mapped;
        }
        return Collections.emptyList();
    }

    protected boolean isLevelElement(EObject object, IContext context) {
        return true;
    }

    protected EObject getLevelElement(EObject source, IContext context) {
        EObject parent = null;
        if (source != null) {
            parent = source.eContainer();
            while (parent != null) {
                if (this.isLevelElement(parent, context)) break;
                parent = parent.eContainer();
            }
        }
        return parent;
    }

    protected void initializeMappings(EObject source, IContext context, LevelMappingTraceability map) {
        block6: {
            EObject sourceRoot = this.getLevelElement(source, context);
            if (map.initialized.contains(sourceRoot)) break block6;
            map.initialized.add(sourceRoot);
            if (sourceRoot == null) {
                this.initializeRootMappings(context);
            } else {
                ITraceabilityHandler handler = TraceabilityHandlerHelper.getInstance(context);
                if (!this.isBackward(map.key)) {
                    for (EObject targetRoot : handler.retrieveTracedElements(sourceRoot, context)) {
                        if (targetRoot == null) continue;
                        this.initializeMapping(sourceRoot, targetRoot, context, map);
                    }
                } else {
                    for (EObject targetRoot : handler.retrieveSourceElements(sourceRoot, context)) {
                        if (targetRoot == null) continue;
                        this.initializeMapping(targetRoot, sourceRoot, context, map);
                    }
                }
            }
        }
    }

    protected boolean isBackward(String key) {
        return this.getBackwardMappingKey().equals(key);
    }

    @Override
    protected MappingTraceability createMappingTraceability(EObject source, IContext context, String key) {
        if (this.isBackward(key)) {
            return new BackwardTraceability(context, key);
        }
        return new ForwardTraceability(context, key);
    }

    protected void initializeRootMappings(IContext context) {
    }

    protected void initializeMapping(EObject sourceRoot, EObject targetRoot, IContext context, LevelMappingTraceability map) {
    }

    protected class BackwardTraceability
    extends LevelMappingTraceability {
        public BackwardTraceability(IContext context, String key) {
            super(context, key);
        }
    }

    protected class ForwardTraceability
    extends LevelMappingTraceability {
        public ForwardTraceability(IContext context, String key) {
            super(context, key);
        }
    }

    public class LevelMappingTraceability
    extends MappingTraceability {
        private static final long serialVersionUID = 1605638569527611797L;
        public Collection<EObject> initialized = new HashSet<EObject>();
        public IContext context;
        public String key;

        public LevelMappingTraceability(IContext context, String key) {
            this.context = context;
            this.key = key;
        }
    }
}

