/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.transition.common.transposer;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.polarsys.kitalpha.transposer.analyzer.api.IAnalyzer;
import org.polarsys.kitalpha.transposer.analyzer.exceptions.AnalysisException;
import org.polarsys.kitalpha.transposer.analyzer.graph.Edge;
import org.polarsys.kitalpha.transposer.analyzer.graph.Graph;
import org.polarsys.kitalpha.transposer.analyzer.graph.GraphFactory;
import org.polarsys.kitalpha.transposer.analyzer.graph.Vertex;
import org.polarsys.kitalpha.transposer.rules.handler.api.IRulesHandler;
import org.polarsys.kitalpha.transposer.rules.handler.business.premises.PrecedencePremise;
import org.polarsys.kitalpha.transposer.rules.handler.exceptions.possibilities.MappingPossibilityResolutionException;
import org.polarsys.kitalpha.transposer.rules.handler.exceptions.rules.ComputePremisesException;
import org.polarsys.kitalpha.transposer.rules.handler.rules.api.IPremise;

public class ExtendedAnalyzer
implements IAnalyzer {
    protected Graph modelGraph = GraphFactory.eINSTANCE.createGraph();
    protected IRulesHandler rulesHandler;
    private Map graphHashMap;

    public ExtendedAnalyzer(IRulesHandler rulesHandler) {
        this.rulesHandler = rulesHandler;
        this.graphHashMap = new HashMap();
    }

    public Graph getModelGraph() {
        return this.modelGraph;
    }

    public Graph analyze(Collection analysisSource, Collection selection, IProgressMonitor monitor) throws AnalysisException {
        if (monitor != null) {
            monitor.beginTask("Transposer Analysis", analysisSource.size());
        }
        for (Object source : analysisSource) {
            try {
                if (this.rulesHandler.getApplicablePossibility(source) == null) continue;
                this.createVertexForType(source, monitor);
                this.createSubGraphForType(source, monitor);
                if (monitor == null) continue;
                monitor.worked(1);
            }
            catch (ComputePremisesException e) {
                throw new AnalysisException(e);
            }
            catch (MappingPossibilityResolutionException e) {
                throw new AnalysisException(e);
            }
        }
        if (monitor != null) {
            monitor.subTask("");
        }
        return this.modelGraph;
    }

    private void createVertexForType(Object currentType, IProgressMonitor monitor) {
        String name;
        if (this.graphHasAlreadyVertex(currentType)) {
            return;
        }
        if (monitor != null) {
            monitor.subTask("Creating vertex for " + currentType.getClass().getSimpleName());
            monitor.worked(1);
        }
        if ((name = this.rulesHandler.getDomainHelper().getName(currentType)) == null || "".equals(name)) {
            name = currentType.getClass().getName();
        }
        boolean isHotSpot = this.rulesHandler.getDomainHelper().isHotSpot(currentType);
        Vertex newVertex = GraphFactory.eINSTANCE.createVertex();
        newVertex.setContent(currentType);
        newVertex.setName(name);
        newVertex.setHotSpot(isHotSpot);
        this.graphHashMap.put(currentType, newVertex);
        this.modelGraph.addVertex(newVertex);
    }

    private boolean graphHasAlreadyVertex(Object currentType) {
        return this.graphHashMap.containsKey(currentType);
    }

    private void createSubGraphForType(Object object1, IProgressMonitor iProgressMonitor1) throws ComputePremisesException {
        Vertex currentVertex = (Vertex)this.graphHashMap.get(object1);
        LinkedList<Object> toVisit = new LinkedList<Object>();
        toVisit.add(object1);
        while (!toVisit.isEmpty()) {
            Object currentType = toVisit.removeFirst();
            currentVertex = (Vertex)this.graphHashMap.get(currentType);
            List needed = null;
            needed = this.rulesHandler.getPremises(currentType);
            if (needed == null) {
                return;
            }
            if (iProgressMonitor1 != null) {
                iProgressMonitor1.subTask("Creating subgraph for " + currentType.getClass().getSimpleName());
            }
            for (IPremise premise : needed) {
                if (!(premise instanceof PrecedencePremise)) continue;
                PrecedencePremise precedentePremise = (PrecedencePremise)premise;
                boolean isCriticalDependency = false;
                boolean createdVertex = false;
                Object dependingObject = precedentePremise.getFirstElement();
                String dependingObjectDescription = precedentePremise.getSecondElement();
                Vertex dependingVertex = (Vertex)this.graphHashMap.get(dependingObject);
                if (dependingVertex == null) {
                    this.createVertexForType(dependingObject, iProgressMonitor1);
                    dependingVertex = (Vertex)this.graphHashMap.get(dependingObject);
                    createdVertex = true;
                }
                isCriticalDependency = precedentePremise.isCritical();
                Edge edge = currentVertex.getOutgoingEdgeTo(dependingVertex);
                if (edge != null && !edge.isCritical() && isCriticalDependency) {
                    edge.setCritical(true);
                } else if (edge == null) {
                    this.modelGraph.addAdjacent(currentVertex, dependingVertex, (Object)dependingObjectDescription, isCriticalDependency);
                }
                if (!createdVertex) continue;
                toVisit.addLast(dependingObject);
            }
        }
    }

    public void dispose() {
        this.graphHashMap.clear();
        this.graphHashMap = null;
        this.modelGraph = null;
        this.rulesHandler = null;
    }
}

