/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.ui.toolkit.fields;

import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.polarsys.capella.common.ui.toolkit.fields.MdeFieldEditor;

public class CStringFieldEditor
extends MdeFieldEditor {
    public static int UNLIMITED = -1;
    public static final int VALIDATE_ON_FOCUS_LOST = 1;
    public static final int VALIDATE_ON_KEY_STROKE = 0;
    public static final int VALIDATE_ON_MODIFICATION = 2;
    private boolean _emptyStringAllowed = true;
    private boolean _isValid = false;
    private String _oldValue = null;
    protected Text _textField;
    private int _textLimit = UNLIMITED;
    private int _validateStrategy = 0;
    private int _widthInChars = UNLIMITED;

    public CStringFieldEditor(String name, String label, Composite parent) {
        this(name, label, UNLIMITED, parent, 2052);
    }

    public CStringFieldEditor(String name, String label, Composite parent, int valueStyle) {
        this(name, label, UNLIMITED, parent, valueStyle);
    }

    public CStringFieldEditor(String name, String label, int width, Composite parent, int valueStyle) {
        this(name, label, width, 0, parent, valueStyle);
    }

    public CStringFieldEditor(String name, String label, int width, int strategy, Composite parent, int valueStyle) {
        this.init(name, label, 16384, valueStyle);
        this._widthInChars = width;
        this.setValidateStrategy(strategy);
        this._isValid = false;
        this.setErrorMessage(JFaceResources.getString((String)"StringFieldEditor.errorMessage"));
        this.createControl(parent);
    }

    @Override
    protected void adjustForNumColumns(int numColumns) {
        GridData gd = (GridData)this._textField.getLayoutData();
        gd.horizontalSpan = numColumns - 1;
        gd.grabExcessHorizontalSpace = gd.horizontalSpan == 1;
    }

    protected boolean checkState() {
        boolean result = false;
        boolean wasValid = this._isValid;
        if (this._emptyStringAllowed) {
            result = true;
        }
        if (this._textField == null) {
            result = false;
        }
        String txt = this._textField != null ? this._textField.getText() : "";
        result = txt.trim().length() > 0 || this._emptyStringAllowed;
        boolean bl = result = result && this.doCheckState();
        if (!wasValid && result) {
            if (this.getPage() != null && this.getPage().getErrorMessage() == this.getErrorMessage()) {
                this.clearErrorMessage();
            }
        } else if (!result) {
            this.showErrorMessage(this.getErrorMessage());
        }
        return result;
    }

    @Override
    protected int checkValueStyle(int valueStyle) {
        int newStyle = valueStyle;
        if ((0x800 & valueStyle) == 0) {
            newStyle |= 0x800;
        }
        if (2048 == this._valueStyle) {
            newStyle |= 4;
        }
        return newStyle;
    }

    @Override
    protected void doFillIntoGrid(Composite parent, int numColumns) {
        this.getLabelControl(parent);
        this._textField = this.getTextControl(parent);
        GridData gd = new GridData();
        gd.horizontalSpan = numColumns - 1;
        if (this._widthInChars != UNLIMITED) {
            GC gc = new GC((Drawable)this._textField);
            try {
                Point extent = gc.textExtent("X");
                gd.widthHint = this._widthInChars * extent.x;
            }
            finally {
                gc.dispose();
            }
        } else {
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
        }
        if ((this._textField.getStyle() & 2) != 0) {
            gd.verticalAlignment = 4;
            gd.verticalSpan = 2;
            gd.grabExcessVerticalSpace = true;
            GridData newGd = new GridData();
            newGd.verticalAlignment = 4;
            newGd.verticalSpan = 2;
            newGd.grabExcessVerticalSpace = true;
            this.getLabelControl().setLayoutData((Object)newGd);
        }
        this._textField.setLayoutData((Object)gd);
    }

    @Override
    protected void doLoad() {
        if (this._textField != null) {
            String value = this.getPreferenceStore().getString(this.getPreferenceName());
            this._textField.setText(value == null ? "" : value);
            this._oldValue = value;
        }
    }

    @Override
    protected void doLoadDefault() {
        if (this._textField != null) {
            String value = this.getPreferenceStore().getDefaultString(this.getPreferenceName());
            this._textField.setText(value);
        }
        this.valueChanged();
    }

    @Override
    protected void doStore() {
        this.getPreferenceStore().setValue(this.getPreferenceName(), this._textField.getText());
    }

    protected Text doTextControl(Composite parent, int style) {
        return new Text(parent, style | 0x200);
    }

    @Override
    public Control getHelperControl() {
        return null;
    }

    @Override
    public int getNumberOfControls() {
        return 2;
    }

    public String getStringValue() {
        if (this._textField != null) {
            return this._textField.getText();
        }
        return this.getPreferenceStore().getString(this.getPreferenceName());
    }

    public Text getTextControl() {
        return this._textField;
    }

    protected Text getTextControl(Composite parent) {
        if (this._textField == null) {
            this._textField = this.doTextControl(parent, this._valueStyle);
            this._textField.setFont(parent.getFont());
            switch (this._validateStrategy) {
                case 0: {
                    this._textField.addKeyListener((KeyListener)new KeyAdapter(){

                        public void keyReleased(KeyEvent event) {
                            CStringFieldEditor.this.valueChanged();
                        }
                    });
                    break;
                }
                case 2: {
                    this._textField.addModifyListener(new ModifyListener(){

                        public void modifyText(ModifyEvent event) {
                            CStringFieldEditor.this.valueChanged();
                        }
                    });
                    break;
                }
                case 1: {
                    this._textField.addKeyListener((KeyListener)new KeyAdapter(){

                        public void keyPressed(KeyEvent event) {
                            CStringFieldEditor.this.clearErrorMessage();
                        }
                    });
                    this._textField.addFocusListener((FocusListener)new FocusAdapter(){

                        public void focusGained(FocusEvent event) {
                            CStringFieldEditor.this.refreshValidState();
                        }

                        public void focusLost(FocusEvent event) {
                            CStringFieldEditor.this.valueChanged();
                            CStringFieldEditor.this.clearErrorMessage();
                        }
                    });
                }
            }
            this._textField.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    CStringFieldEditor.this._textField = null;
                }
            });
            if (this._textLimit > 0) {
                this._textField.setTextLimit(this._textLimit);
            }
        } else {
            this.checkParent((Control)this._textField, parent);
        }
        return this._textField;
    }

    @Override
    protected Object getValue(Control control) {
        return this._textField.getText();
    }

    @Override
    public Control getValueControl() {
        return this._textField;
    }

    public boolean isEmptyStringAllowed() {
        return this._emptyStringAllowed;
    }

    protected void refreshValidState() {
        this._isValid = this.checkState();
    }

    public void setEmptyStringAllowed(boolean allowed) {
        this._emptyStringAllowed = allowed;
    }

    public void setEnabled(boolean enabled, Composite parent) {
        super.setEnabled(enabled, parent);
        this.getTextControl(parent).setEditable(enabled);
    }

    @Override
    public void setFocus() {
        if (this._textField != null) {
            this._textField.setFocus();
        }
    }

    public void setStringValue(String value) {
        String val = value;
        if (this._textField != null) {
            if (val == null) {
                val = "";
            }
            this._oldValue = this._textField.getText();
            if (!this._oldValue.equals(val)) {
                this._textField.setText(val);
                this.valueChanged();
            }
        }
    }

    public void setTextLimit(int limit) {
        this._textLimit = limit;
        if (this._textField != null) {
            this._textField.setTextLimit(limit);
        }
    }

    public void setValidateStrategy(int value) {
        if (value == 1 || value == 0 || value == 2) {
            this._validateStrategy = value;
        }
    }

    public void showErrorMessage() {
        this.showErrorMessage(this.getErrorMessage());
    }

    protected void valueChanged() {
        String newValue;
        this.setPresentsDefaultValue(false);
        boolean oldState = this._isValid;
        this.refreshValidState();
        if (this._isValid != oldState) {
            this.fireStateChanged("field_editor_is_valid", oldState, this._isValid);
        }
        if (!(newValue = this._textField.getText()).equals(this._oldValue)) {
            this.fireValueChanged("field_editor_value", this._oldValue, newValue);
            this._oldValue = newValue;
        }
    }
}

