/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.helpers.export;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.polarsys.capella.common.MdeCommonActivator;
import org.polarsys.capella.common.helpers.export.AbstractExporter;
import org.polarsys.capella.common.helpers.export.IExporterProvider;
import org.polarsys.capella.common.helpers.export.utils.CSVWriterMessages;

public class DataExporter {
    protected IExporterProvider exporterProvider;

    public DataExporter(IExporterProvider exporterProvider) {
        if (exporterProvider == null || exporterProvider.getAvailableExporter() == null || exporterProvider.getAvailableExporter().isEmpty()) {
            throw new IllegalArgumentException(CSVWriterMessages.errNullFileName);
        }
        this.exporterProvider = exporterProvider;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean exportToFile(String fileName, Object data) {
        if (fileName == null) return false;
        if (fileName.length() == 0) {
            return false;
        }
        boolean result = true;
        String ext = "";
        int dotLoc = fileName.lastIndexOf(46);
        ext = dotLoc != -1 ? fileName.substring(dotLoc + 1) : "";
        AbstractExporter exporter = this.getExporter(ext);
        if (exporter == null) return false;
        File file = new File(fileName);
        FileOutputStream stream = null;
        try {
            try {
                stream = new FileOutputStream(file);
                exporter.export(stream, data);
                return result;
            }
            catch (FileNotFoundException exception) {
                MdeCommonActivator.getDefault().getLog().log((IStatus)new Status(4, MdeCommonActivator.getDefault().getPluginId(), "Error", (Throwable)exception));
                result = false;
                try {
                    if (stream == null) return result;
                    ((OutputStream)stream).close();
                    return result;
                }
                catch (IOException exception2) {
                    MdeCommonActivator.getDefault().getLog().log((IStatus)new Status(4, MdeCommonActivator.getDefault().getPluginId(), "Error", (Throwable)exception2));
                }
                return result;
            }
            catch (IOException exception) {
                MdeCommonActivator.getDefault().getLog().log((IStatus)new Status(4, MdeCommonActivator.getDefault().getPluginId(), "Error", (Throwable)exception));
                result = false;
                try {
                    if (stream == null) return result;
                    ((OutputStream)stream).close();
                    return result;
                }
                catch (IOException exception3) {
                    MdeCommonActivator.getDefault().getLog().log((IStatus)new Status(4, MdeCommonActivator.getDefault().getPluginId(), "Error", (Throwable)exception3));
                }
                return result;
            }
        }
        finally {
            try {
                if (stream != null) {
                    ((OutputStream)stream).close();
                }
            }
            catch (IOException exception) {
                MdeCommonActivator.getDefault().getLog().log((IStatus)new Status(4, MdeCommonActivator.getDefault().getPluginId(), "Error", (Throwable)exception));
            }
        }
    }

    public AbstractExporter getExporter(String ext) {
        AbstractExporter result = null;
        for (AbstractExporter exporter : this.exporterProvider.getAvailableExporter()) {
            if (!exporter.getExtension().equals(ext)) continue;
            result = exporter;
            break;
        }
        return result;
    }

    public String[] getSupportedExtension() {
        ArrayList<CallSite> extensions = new ArrayList<CallSite>();
        String suffix = this.getSuffixForFileDialog();
        for (AbstractExporter exporter : this.exporterProvider.getAvailableExporter()) {
            extensions.add((CallSite)((Object)(suffix + exporter.getExtension())));
        }
        return extensions.toArray(new String[extensions.size()]);
    }

    public String[] getSupportedDescription() {
        ArrayList<CallSite> descriptions = new ArrayList<CallSite>();
        String suffix = this.getSuffixForFileDialog();
        for (AbstractExporter exporter : this.exporterProvider.getAvailableExporter()) {
            descriptions.add((CallSite)((Object)(suffix + exporter.getDescription())));
        }
        return descriptions.toArray(new String[descriptions.size()]);
    }

    protected String getSuffixForFileDialog() {
        return String.valueOf('*') + ".";
    }
}

