/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.helpers.transaction;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListenerImpl;
import org.eclipse.emf.transaction.RollbackException;

public abstract class ContainmentTreeListener
extends ResourceSetListenerImpl {
    protected static final NotificationFilter DEFAULT_FILTER = NotificationFilter.NOT_TOUCH.and(NotificationFilter.READ.negated().and((NotificationFilter)new ContainmentChangeFilter()).and(NotificationFilter.createEventTypeFilter((int)4).or(NotificationFilter.createEventTypeFilter((int)6)).or(NotificationFilter.createEventTypeFilter((int)1))));

    public ContainmentTreeListener() {
        this(DEFAULT_FILTER);
    }

    public ContainmentTreeListener(NotificationFilter filter) {
        super(filter);
    }

    public final Command transactionAboutToCommit(ResourceSetChangeEvent event) throws RollbackException {
        LinkedHashMap<EObject, Notification> deleted = new LinkedHashMap<EObject, Notification>();
        LinkedHashMap<EObject, Notification> moved = new LinkedHashMap<EObject, Notification>();
        for (Notification notif : event.getNotifications()) {
            Object old = notif.getOldValue();
            if (old instanceof List) {
                for (EObject o : (List)old) {
                    if (o.eResource() == null) {
                        deleted.put(o, notif);
                        continue;
                    }
                    moved.putIfAbsent(o, notif);
                }
                continue;
            }
            if (old == null) continue;
            if (((EObject)old).eResource() == null) {
                deleted.put((EObject)old, notif);
                continue;
            }
            moved.putIfAbsent((EObject)old, notif);
        }
        if (deleted.size() > 0 || moved.size() > 0) {
            return this.handleContainmentTreeChange(deleted, moved);
        }
        return null;
    }

    public final void resourceSetChanged(ResourceSetChangeEvent event) {
        try {
            this.transactionAboutToCommit(event);
        }
        catch (RollbackException rollbackException) {
            // empty catch block
        }
    }

    protected abstract Command handleContainmentTreeChange(Map<EObject, Notification> var1, Map<EObject, Notification> var2);

    private static class ContainmentChangeFilter
    extends NotificationFilter.Custom {
        private ContainmentChangeFilter() {
        }

        public boolean matches(Notification notification) {
            if (notification.getFeature() instanceof EReference && ((EReference)notification.getFeature()).isContainment()) {
                return true;
            }
            return notification.getNotifier() instanceof Resource && notification.getFeatureID(Resource.class) == 2;
        }
    }
}

