/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.utils.graph;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.polarsys.capella.common.utils.graph.IDirectedGraph;
import org.polarsys.capella.common.utils.graph.SCCSearch;

public class CycleDetectionUtils {
    public static <T> boolean containsCycles(IDirectedGraph<T> graph) {
        List<List<T>> list = CycleDetectionUtils.getCycles(graph);
        return list != null && !list.isEmpty();
    }

    public static <T> List<List<T>> getCycles(IDirectedGraph<T> graph) {
        ArrayList<List<T>> list = new ArrayList<List<T>>();
        Iterator<T> nodes = graph.getNodes();
        while (nodes.hasNext()) {
            T node = nodes.next();
            Iterator<T> succesors = graph.getSucessors(node);
            while (succesors.hasNext()) {
                if (!node.equals(succesors.next())) continue;
                ArrayList<T> directReferenceCycle = new ArrayList<T>();
                directReferenceCycle.add(node);
                list.add(directReferenceCycle);
            }
        }
        SCCSearch<T> sccSearch = new SCCSearch<T>();
        List sccSearchResult = sccSearch.findSCC(graph, false);
        list.addAll(sccSearchResult);
        return list;
    }
}

