/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.detachment.propertyvalues.ui.page;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.regex.PatternSyntaxException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.polarsys.capella.detachment.propertyvalue.messages.Messages;
import org.polarsys.capella.detachment.propertyvalues.ui.page.Constants;
import org.polarsys.capella.detachment.propertyvalues.ui.page.ErrorRegExpMessageToolTip;
import org.polarsys.capella.detachment.propertyvalues.ui.page.PropertyValueContentProvider;
import org.polarsys.capella.detachment.propertyvalues.ui.page.PropertyValueHelper;
import org.polarsys.capella.detachment.propertyvalues.ui.page.PropertyValueLabelProvider;
import org.polarsys.capella.detachment.propertyvalues.ui.page.PropertyValueTextFilterViewer;
import org.polarsys.capella.detachment.propertyvalues.ui.page.PropertyValueTypeFilterViewer;
import org.polarsys.kitalpha.model.common.scrutiny.interfaces.IScrutinize;
import org.polarsys.kitalpha.model.detachment.ui.page.AbstractDetachmentFormPage;

public class PropertyValuesFormPage
extends AbstractDetachmentFormPage {
    private TreeViewer treeViewer;
    private int maskTypeFilter = 0;
    private final PropertyValueTextFilterViewer textFilter = new PropertyValueTextFilterViewer();
    private final PropertyValueTypeFilterViewer typeFilter = new PropertyValueTypeFilterViewer();

    public PropertyValuesFormPage(FormEditor editor, String id, String title) {
        super(editor, id, title);
    }

    protected void createFormContent(IManagedForm managedForm) {
        FormToolkit tk = managedForm.getToolkit();
        ScrolledForm scrolledForm = managedForm.getForm();
        scrolledForm.setText(Messages.Title_DetachmentPropertyValues);
        scrolledForm.setExpandHorizontal(true);
        Composite pageComposite = scrolledForm.getBody();
        GridLayout gridLayout = new GridLayout(1, true);
        pageComposite.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(4, 4, true, true);
        pageComposite.setLayoutData((Object)gridData);
        Composite subPageComposite = tk.createComposite(pageComposite);
        GridLayoutFactory.fillDefaults().margins(10, 5).numColumns(1).applyTo(subPageComposite);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)subPageComposite);
        this.createTreeTableViewer(tk, gridData, subPageComposite);
        this.setTreeTableViewerInput();
    }

    private void setTreeTableViewerInput() {
        HashSet<EObject> input = new HashSet<EObject>();
        Collection<IScrutinize> scrutinizers = PropertyValueHelper.getScrutinizers(this.getScrutinyAnalysis(), this.getFinderID());
        for (IScrutinize iScrutinize : scrutinizers) {
            Map result = (Map)iScrutinize.getAnalysisResult();
            for (Map.Entry e : result.entrySet()) {
                EObject key = (EObject)e.getKey();
                if (PropertyValueHelper.isChildOfPropertyValue(key)) continue;
                input.add(key);
            }
        }
        this.treeViewer.setInput(input);
    }

    private void createTreeTableViewer(FormToolkit tk, GridData gridData, Composite subPageComposite) {
        Composite toolbarsComposite = this.prepareComposite(tk, subPageComposite);
        ToolBar treeManagementBar = this.initializeToolBar(toolbarsComposite);
        this.initializeCollapseButton(treeManagementBar);
        this.initializeSelectAllButton(treeManagementBar);
        this.initializeDeselectAllButton(treeManagementBar);
        this.initializePkgFilteringButton(treeManagementBar);
        this.initializePgFilteringButton(treeManagementBar);
        this.initializePEnumFilteringButton(treeManagementBar);
        this.initializePvFilteringButton(treeManagementBar);
        this.initializeTextFilteringField(tk, toolbarsComposite, treeManagementBar);
        Composite treeTableComposite = tk.createComposite(subPageComposite);
        TreeColumnLayout treeColLayout = new TreeColumnLayout();
        treeTableComposite.setLayout((Layout)treeColLayout);
        treeTableComposite.setLayoutData((Object)gridData);
        Tree tree = this.createTreeViewer(tk, gridData, treeTableComposite);
        this.createViewerColumns(treeColLayout, tree);
        this.setComparator();
        this.setFilters();
        this.setTreeProviders();
        this.addListeners();
        this.treeViewer.setUseHashlookup(true);
    }

    private void addListeners() {
        this.treeViewer.getTree().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Widget item;
                int detail = e.detail;
                if (detail == 32 && (item = e.item) != null) {
                    TreeItem treeItem = (TreeItem)item;
                    PropertyValuesFormPage.this.updateChildren(treeItem, treeItem.getChecked());
                    PropertyValuesFormPage.this.updateParent(treeItem, treeItem.getChecked());
                }
            }
        });
        this.treeViewer.getTree().addListener(17, new Listener(){

            public void handleEvent(Event event) {
                TreeItem i;
                Widget item = event.item;
                if (item != null && (i = (TreeItem)item).getChecked()) {
                    PropertyValuesFormPage.this.updateChildren(i, i.getChecked());
                    PropertyValuesFormPage.this.updateParent(i, i.getChecked());
                }
                PropertyValuesFormPage.this.treeViewer.refresh();
            }
        });
        ((CheckboxTreeViewer)this.treeViewer).setCheckStateProvider(new ICheckStateProvider(){

            public boolean isGrayed(Object element) {
                return false;
            }

            public boolean isChecked(Object element) {
                return PropertyValuesFormPage.this.getStateOf(element);
            }
        });
    }

    private void setTreeProviders() {
        this.treeViewer.setContentProvider((IContentProvider)new PropertyValueContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new PropertyValueLabelProvider());
    }

    private void setFilters() {
        this.treeViewer.addFilter((ViewerFilter)this.textFilter);
        this.treeViewer.addFilter((ViewerFilter)this.typeFilter);
    }

    private void setComparator() {
    }

    private void createViewerColumns(TreeColumnLayout treeColLayout, Tree tree) {
        TreeColumn propertiesColumn = new TreeColumn(tree, 16384);
        propertiesColumn.setAlignment(16384);
        propertiesColumn.setText(Messages.Pv);
        treeColLayout.setColumnData((Widget)propertiesColumn, (ColumnLayoutData)new ColumnWeightData(40, true));
        TreeColumn propertyPath = new TreeColumn(tree, 131072);
        propertyPath.setAlignment(16384);
        propertyPath.setText(Messages.PvPath);
        treeColLayout.setColumnData((Widget)propertyPath, (ColumnLayoutData)new ColumnWeightData(90, true));
        tree.setLinesVisible(true);
    }

    private Tree createTreeViewer(FormToolkit tk, GridData gridData, Composite treeTableComposite) {
        Tree tree = tk.createTree(treeTableComposite, 2850);
        this.treeViewer = new CheckboxTreeViewer(tree);
        this.treeViewer.getTree().setHeaderVisible(true);
        this.treeViewer.getTree().setLayoutData((Object)gridData);
        return tree;
    }

    private ToolBar initializeToolBar(Composite toolbarsComposite) {
        ToolBar treeManagementBar = new ToolBar(toolbarsComposite, 0x800000);
        treeManagementBar.setBackground(Display.getDefault().getSystemColor(1));
        return treeManagementBar;
    }

    private Composite prepareComposite(FormToolkit tk, Composite subPageComposite) {
        Composite toolbarsComposite = tk.createComposite(subPageComposite);
        GridLayoutFactory.fillDefaults().margins(0, 0).numColumns(2).equalWidth(false).applyTo(toolbarsComposite);
        GridDataFactory.fillDefaults().grab(false, false).applyTo((Control)toolbarsComposite);
        return toolbarsComposite;
    }

    private void initializeTextFilteringField(FormToolkit tk, Composite toolbarsComposite, ToolBar treeManagementBar) {
        new ToolItem(treeManagementBar, 514);
        final Text inputFilter = tk.createText(toolbarsComposite, "", 16516);
        inputFilter.setToolTipText(Messages.Filter_PropertyValue);
        inputFilter.setMessage(". = any character, .* = any string");
        inputFilter.setLayoutData((Object)new GridData(768));
        inputFilter.addKeyListener((KeyListener)new KeyAdapter(){
            ErrorRegExpMessageToolTip errorToolTip;

            public void keyReleased(KeyEvent e) {
                try {
                    if (this.errorToolTip != null) {
                        this.errorToolTip.hide();
                        this.errorToolTip.deactivate();
                    }
                    inputFilter.setForeground(Display.getCurrent().getSystemColor(2));
                    PropertyValuesFormPage.this.textFilter.setPattern(inputFilter.getText());
                    PropertyValuesFormPage.this.treeViewer.refresh();
                }
                catch (PatternSyntaxException ex) {
                    inputFilter.setForeground(Display.getCurrent().getSystemColor(3));
                    if (this.errorToolTip == null) {
                        this.errorToolTip = new ErrorRegExpMessageToolTip((Control)inputFilter, "");
                    }
                    Point location = inputFilter.getLocation();
                    this.errorToolTip.setRegExp(inputFilter.getText());
                    this.errorToolTip.activate();
                    this.errorToolTip.show(new Point(location.x * 2, location.y + 15));
                }
            }
        });
    }

    private void initializePvFilteringButton(ToolBar treeManagementBar) {
        ToolItem pvItem = new ToolItem(treeManagementBar, 32);
        pvItem.setImage(Constants.getPropertyValueIcon());
        pvItem.setToolTipText("Property Values");
        pvItem.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                PropertyValuesFormPage.this.doViewerFilter(event, PropertyValuesFormPage.this.typeFilter, 1);
            }
        });
    }

    private void initializePEnumFilteringButton(ToolBar treeManagementBar) {
        ToolItem enumTypeItem = new ToolItem(treeManagementBar, 32);
        enumTypeItem.setImage(Constants.getEnumTypeIcon());
        enumTypeItem.setToolTipText("Property Enumeration Type");
        enumTypeItem.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                PropertyValuesFormPage.this.doViewerFilter(event, PropertyValuesFormPage.this.typeFilter, 8);
            }
        });
    }

    private void initializePgFilteringButton(ToolBar treeManagementBar) {
        ToolItem pgItem = new ToolItem(treeManagementBar, 32);
        pgItem.setImage(Constants.getPropertyGroupIcon());
        pgItem.setToolTipText("Property Group");
        pgItem.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                PropertyValuesFormPage.this.doViewerFilter(event, PropertyValuesFormPage.this.typeFilter, 2);
            }
        });
    }

    private void initializePkgFilteringButton(ToolBar treeManagementBar) {
        new ToolItem(treeManagementBar, 514);
        ToolItem pkgItem = new ToolItem(treeManagementBar, 32);
        pkgItem.setImage(Constants.getPropertyPackageIcon());
        pkgItem.setToolTipText("Property Package");
        pkgItem.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                PropertyValuesFormPage.this.doViewerFilter(event, PropertyValuesFormPage.this.typeFilter, 4);
            }
        });
    }

    private void initializeDeselectAllButton(ToolBar treeManagementBar) {
        ToolItem deselctAll = new ToolItem(treeManagementBar, 8);
        deselctAll.setImage(Constants.getUncheckAllIcon());
        deselctAll.setToolTipText(Messages.Checkbox_UncheckAll);
        deselctAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TreeItem[] items = PropertyValuesFormPage.this.treeViewer.getTree().getItems();
                PropertyValuesFormPage.this.updateResult(false);
                TreeItem[] treeItemArray = items;
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeItem treeItem = treeItemArray[n2];
                    treeItem.setChecked(false);
                    PropertyValuesFormPage.this.updateChildren(treeItem, false);
                    ++n2;
                }
            }
        });
    }

    private void initializeSelectAllButton(ToolBar treeManagementBar) {
        new ToolItem(treeManagementBar, 514);
        ToolItem selctAll = new ToolItem(treeManagementBar, 8);
        selctAll.setImage(Constants.getCheckAllIcon());
        selctAll.setToolTipText(Messages.Checkbox_CheckAll);
        selctAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TreeItem[] items = PropertyValuesFormPage.this.treeViewer.getTree().getItems();
                PropertyValuesFormPage.this.updateResult(true);
                TreeItem[] treeItemArray = items;
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeItem treeItem = treeItemArray[n2];
                    treeItem.setChecked(true);
                    PropertyValuesFormPage.this.updateChildren(treeItem, true);
                    ++n2;
                }
            }
        });
    }

    private void initializeCollapseButton(ToolBar treeManagementBar) {
        final ToolItem expandCollapse = new ToolItem(treeManagementBar, 8);
        expandCollapse.setImage(Constants.getExpandAllIcon());
        expandCollapse.setToolTipText(Messages.Collapse_expandAll);
        expandCollapse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (expandCollapse.getToolTipText().equalsIgnoreCase(Messages.Collapse_expandAll)) {
                    expandCollapse.setImage(Constants.getCollapsAllIcon());
                    expandCollapse.setToolTipText(Messages.Collapse_CollapsedAll);
                    PropertyValuesFormPage.this.treeViewer.expandAll();
                } else {
                    expandCollapse.setImage(Constants.getExpandAllIcon());
                    expandCollapse.setToolTipText(Messages.Collapse_expandAll);
                    PropertyValuesFormPage.this.treeViewer.collapseAll();
                }
                PropertyValuesFormPage.this.treeViewer.refresh();
            }
        });
    }

    private void doViewerFilter(Event e, PropertyValueTypeFilterViewer filter, int propertyValueType) {
        boolean isChecked = ((ToolItem)e.widget).getSelection();
        this.maskTypeFilter = isChecked ? (this.maskTypeFilter |= propertyValueType) : (this.maskTypeFilter &= ~propertyValueType);
        filter.setFilterType(this.maskTypeFilter);
        this.treeViewer.refresh();
    }

    private void updateResult(Object data, boolean checked) {
        if (data != null) {
            Collection<IScrutinize> scrutinizers = PropertyValueHelper.getScrutinizers(this.getScrutinyAnalysis(), this.getFinderID());
            ITreeContentProvider contentProvider = (ITreeContentProvider)this.treeViewer.getContentProvider();
            for (IScrutinize iScrutinize : scrutinizers) {
                Map analysisResult = (Map)iScrutinize.getAnalysisResult();
                if (!analysisResult.containsKey(data)) continue;
                analysisResult.put(data, checked);
                Object parent = contentProvider.getParent(data);
                if (parent == null || !analysisResult.containsKey(parent) || checked) continue;
                analysisResult.put(parent, checked);
            }
        }
    }

    private void updateResult(boolean checked) {
        Collection<IScrutinize> scrutinizers = PropertyValueHelper.getScrutinizers(this.getScrutinyAnalysis(), this.getFinderID());
        for (IScrutinize iScrutinize : scrutinizers) {
            Map analysisResult = (Map)iScrutinize.getAnalysisResult();
            for (Map.Entry entry : analysisResult.entrySet()) {
                entry.setValue(checked);
            }
        }
    }

    private void updateParent(TreeItem treeItem, boolean state) {
        TreeItem parent;
        if (treeItem != null && (parent = treeItem.getParentItem()) != null) {
            boolean parentState = parent.getChecked();
            Object data = parent.getData();
            if (data != null && parentState && parentState != state) {
                this.updateResult(data, state);
                parent.setChecked(state);
                this.updateParent(parent, state);
            }
        }
    }

    private void updateChildren(TreeItem treeItem, boolean state) {
        if (treeItem != null) {
            TreeItem[] items = treeItem.getItems();
            Object data = treeItem.getData();
            if (data != null) {
                this.updateResult(data, treeItem.getChecked());
            }
            if (items != null && items.length != 0) {
                TreeItem[] treeItemArray = items;
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeItem item = treeItemArray[n2];
                    item.setChecked(state);
                    this.updateChildren(item, state);
                    ++n2;
                }
            }
        }
    }

    private boolean getStateOf(Object elt) {
        Collection<IScrutinize> scrutinizers = PropertyValueHelper.getScrutinizers(this.getScrutinyAnalysis(), this.getFinderID());
        for (IScrutinize iScrutinize : scrutinizers) {
            Map analysisResult = (Map)iScrutinize.getAnalysisResult();
            if (!analysisResult.containsKey(elt)) continue;
            return (Boolean)analysisResult.get(elt);
        }
        return false;
    }
}

