/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.commandline.ju.testcases;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.sirius.common.tools.api.resource.ImageFileFormat;
import org.polarsys.capella.core.sirius.ui.commandline.ExportRepresentationsCommandLine;
import org.polarsys.capella.test.commandline.ju.utils.MockApplicationContext;
import org.polarsys.capella.test.framework.api.BasicTestCase;
import org.polarsys.capella.test.framework.api.ModelProviderHelper;
import org.polarsys.capella.test.framework.helpers.GuiActions;
import org.polarsys.capella.test.framework.helpers.IResourceHelpers;

public class CommandLineExportRepresentationsTest
extends BasicTestCase {
    public void test() {
        String projectName = "RefreshRemoveExport";
        File sourceFolder = this.getFolderInTestModelRepository(projectName);
        IFolder outputFolder = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName).getFolder("ImagesExported").getFolder(projectName).getFolder(projectName + ".aird");
        ModelProviderHelper.getInstance().importCapellaProject(projectName, sourceFolder);
        try {
            this.exportImages(projectName);
            CommandLineExportRepresentationsTest.assertTrue((this.getFiles(outputFolder, ImageFileFormat.JPG).size() == 3 ? 1 : 0) != 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            CommandLineExportRepresentationsTest.assertFalse((String)e.getMessage(), (boolean)true);
        }
        try {
            this.exportImages(projectName, ImageFileFormat.SVG);
            Collection<IFile> files = this.getFiles(outputFolder, ImageFileFormat.SVG);
            CommandLineExportRepresentationsTest.assertTrue((files.size() == 3 ? 1 : 0) != 0);
            String svgContent = IResourceHelpers.readFileAsString((IFile)files.iterator().next());
            CommandLineExportRepresentationsTest.assertTrue((!this.notNoneMatches(this.matches(svgContent, Pattern.compile("diagram:semanticTargetId=\"([^\"]+)\""))).isEmpty() ? 1 : 0) != 0);
            CommandLineExportRepresentationsTest.assertTrue((!this.notNoneMatches(this.matches(svgContent, Pattern.compile("diagram:semanticRoot=\"([^\"]+)\""))).isEmpty() ? 1 : 0) != 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            CommandLineExportRepresentationsTest.assertFalse((String)e.getMessage(), (boolean)true);
        }
    }

    private Collection<String> matches(String content, Pattern pattern) {
        Matcher m = pattern.matcher(content);
        ArrayList<String> matches = new ArrayList<String>();
        while (m.find()) {
            matches.add(m.group(1));
        }
        return matches;
    }

    private Collection<String> notNoneMatches(Collection<String> semanticElementIds) {
        return semanticElementIds.stream().filter(x -> !"none".equals(x)).collect(Collectors.toList());
    }

    private Collection<IFile> getFiles(IFolder outputFolder, ImageFileFormat defaultImageFormat) {
        return IResourceHelpers.getIFilesIn((IContainer)outputFolder, (String)defaultImageFormat.getName().toLowerCase());
    }

    private void exportImages(String projectName) throws Exception {
        this.exportImages(projectName, null);
    }

    private void exportImages(String projectName, ImageFileFormat format) throws Exception {
        ArrayList<String> arguments = new ArrayList<String>(Arrays.asList("-appid", "org.polarsys.capella.exportRepresentations", "-input", projectName + "/" + projectName + ".aird", "-outputfolder", projectName + "/ImagesExported", "-forceoutputfoldercreation"));
        if (format != null) {
            arguments.add("-imageFormat");
            arguments.add(format.getName());
        }
        MockApplicationContext mockApplicationContext = new MockApplicationContext(arguments.toArray(new String[0]));
        ExportRepresentationsCommandLine commandLine = new ExportRepresentationsCommandLine();
        commandLine.parseContext((IApplicationContext)mockApplicationContext);
        commandLine.checkArgs((IApplicationContext)mockApplicationContext);
        commandLine.prepare((IApplicationContext)mockApplicationContext);
        commandLine.execute((IApplicationContext)mockApplicationContext);
        GuiActions.flushASyncGuiJobs();
    }
}

