/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.commandline.ju.testcases;

import java.io.File;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.app.IApplicationContext;
import org.polarsys.capella.core.sirius.ui.commandline.RefreshAirdCommandLine;
import org.polarsys.capella.test.commandline.ju.utils.MockApplicationContext;
import org.polarsys.capella.test.framework.api.BasicTestCase;
import org.polarsys.capella.test.framework.api.ModelProviderHelper;
import org.polarsys.capella.test.framework.helpers.GuiActions;
import org.polarsys.capella.test.framework.helpers.log.StatusValidator;

public class CommandLineRefreshAirdTest
extends BasicTestCase {
    public void test() {
        String projectName = "RefreshRemoveExport";
        File sourceFolder = this.getFolderInTestModelRepository(projectName);
        ModelProviderHelper.getInstance().importCapellaProject(projectName, sourceFolder);
        try {
            StatusValidator removeSomething = new StatusValidator(s -> s.getMessage().contains("representations refreshed"));
            Platform.addLogListener((ILogListener)removeSomething);
            this.refreshElements(projectName);
            Platform.removeLogListener((ILogListener)removeSomething);
            CommandLineRefreshAirdTest.assertTrue((String)"Refresh representations", (boolean)removeSomething.isValid());
        }
        catch (Exception e) {
            e.printStackTrace();
            CommandLineRefreshAirdTest.assertFalse((String)e.getMessage(), (boolean)true);
        }
    }

    private void refreshElements(String project) throws Exception {
        String[] arguments = new String[]{"-appid", "org.polarsys.capella.refreshRepresentations", "-input", project + "/" + project + ".aird", "-outputfolder", project + "/output", "-forceoutputfoldercreation"};
        MockApplicationContext mockApplicationContext = new MockApplicationContext(arguments);
        RefreshAirdCommandLine commandLine = new RefreshAirdCommandLine();
        commandLine.parseContext((IApplicationContext)mockApplicationContext);
        commandLine.checkArgs((IApplicationContext)mockApplicationContext);
        commandLine.prepare((IApplicationContext)mockApplicationContext);
        commandLine.execute((IApplicationContext)mockApplicationContext);
        GuiActions.flushASyncGuiJobs();
    }
}

