/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.common.ju.context;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.diagram.DDiagram;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.sirius.analysis.helpers.ToolProviderHelper;
import org.polarsys.capella.test.diagram.common.ju.context.CommonDiagram;
import org.polarsys.capella.test.diagram.common.ju.context.DiagramContext;
import org.polarsys.capella.test.diagram.common.ju.context.MissionDiagram;
import org.polarsys.capella.test.diagram.common.ju.step.crud.CreateDiagramStep;
import org.polarsys.capella.test.diagram.common.ju.step.tools.CreateAbstractDNodeTool;
import org.polarsys.capella.test.diagram.common.ju.step.tools.CreateDEdgeTool;
import org.polarsys.capella.test.diagram.common.ju.step.tools.InsertRemoveTool;
import org.polarsys.capella.test.diagram.common.ju.step.tools.ReconnectTool;
import org.polarsys.capella.test.framework.context.SessionContext;

public class CapabilityDiagram
extends CommonDiagram {
    BlockArchitectureExt.Type type = null;

    public CapabilityDiagram(BlockArchitectureExt.Type type, SessionContext context, DDiagram diagram) {
        super(context, diagram);
        this.type = type;
    }

    public static CapabilityDiagram createDiagram(SessionContext executionContext, String targetIdentifier, String name) {
        BlockArchitecture architecture = BlockArchitectureExt.getRootBlockArchitecture((EObject)executionContext.getSemanticElement(targetIdentifier));
        final BlockArchitectureExt.Type type = BlockArchitectureExt.getBlockArchitectureType((BlockArchitecture)architecture);
        if ("Missions Capabilities Blank".equals(name) || "Missions Blank".equals(name) || "Contextual Capability".equals(name) || "Contextual Mission".equals(name)) {
            return MissionDiagram.createDiagram(executionContext, targetIdentifier, name);
        }
        return (CapabilityDiagram)((DiagramContext)new CreateDiagramStep(executionContext, targetIdentifier, name){

            @Override
            public DiagramContext getResult() {
                return new CapabilityDiagram(type, this.getExecutionContext(), this.diagram);
            }
        }.run()).open();
    }

    public String createActor() {
        return this.createActorInContainer(this.getDiagramId());
    }

    public String createActorInContainer(String containerId) {
        if (this.isA("Capability Realization Blank") || this.isA("Operational Capabilities Blank") || this.isA("Contextual Operational Capability")) {
            return this.createContainerElement(containerId, this.getActorToolName());
        }
        return this.createNodeElement(containerId, this.getActorToolName());
    }

    @Deprecated
    public void createActor(String id) {
        this.createActor(id, this.getDiagramId());
    }

    @Deprecated
    public void createActor(String id, String containerId) {
        new CreateAbstractDNodeTool((DiagramContext)this, this.getActorToolName(), containerId, id).run();
    }

    public String createComponent() {
        return this.createContainerElement(this.getDiagramId(), this.getComponentToolName());
    }

    public String createChildComponent(String containerId) {
        return this.createContainerElement(containerId, this.getComponentToolName());
    }

    @Deprecated
    public void createComponent(String id) {
        this.createComponent(id, this.getDiagramId());
    }

    @Deprecated
    public void createComponent(String id, String containerId) {
        new CreateAbstractDNodeTool((DiagramContext)this, this.getComponentToolName(), containerId, id).run();
    }

    public String createCapability() {
        return this.createNodeElement(this.getDiagramId(), this.getCapabilityToolName());
    }

    @Deprecated
    public void createCapability(String id) {
        new CreateAbstractDNodeTool((DiagramContext)this, this.getCapabilityToolName(), this.getDiagramId(), id).run();
    }

    public String createActorGeneralization(String sourceId, String targetId) {
        return this.createEdgeElement(sourceId, targetId, ToolProviderHelper.getToolCreateActorGeneralization((DDiagram)this.getDiagram()));
    }

    @Deprecated
    public void createActorGeneralization(String sourceId, String targetId, String id) {
        new CreateDEdgeTool(this, ToolProviderHelper.getToolCreateActorGeneralization((DDiagram)this.getDiagram()), sourceId, targetId, id).run();
    }

    public void cannotCreateActorCapabilityGeneralization(String sourceId, String targetId) {
        new CreateDEdgeTool(this, ToolProviderHelper.getToolCreateActorGeneralization((DDiagram)this.getDiagram()), sourceId, targetId).cannotRun();
    }

    public void cannotCreateActorGeneralization(String sourceId, String targetId) {
        new CreateDEdgeTool(this, ToolProviderHelper.getToolCreateActorGeneralization((DDiagram)this.getDiagram()), sourceId, targetId).shouldFail();
    }

    public String createCapabilityGeneralization(String sourceId, String targetId) {
        return this.createEdgeElement(sourceId, targetId, this.getCapabilityGeneralizationToolName());
    }

    @Deprecated
    public void createCapabilityGeneralization(String sourceId, String targetId, String id) {
        new CreateDEdgeTool(this, this.getCapabilityGeneralizationToolName(), sourceId, targetId, id).run();
    }

    public void cannotCreateCapabilityGeneralization(String sourceId, String targetId) {
        new CreateDEdgeTool(this, this.getCapabilityGeneralizationToolName(), sourceId, targetId).shouldFail();
    }

    public String createCapabilityInvolvement(String sourceId, String targetId) {
        return this.createEdgeElement(sourceId, targetId, this.getCapabilityInvolvementToolName());
    }

    @Deprecated
    public void createCapabilityInvolvement(String sourceId, String targetId, String id) {
        new CreateDEdgeTool(this, this.getCapabilityInvolvementToolName(), sourceId, targetId, id).run();
    }

    public String createCapabilityExtends(String sourceId, String targetId) {
        return this.createEdgeElement(sourceId, targetId, this.getCapabilityExtendsToolName());
    }

    @Deprecated
    public void createCapabilityExtends(String sourceId, String targetId, String id) {
        new CreateDEdgeTool(this, this.getCapabilityExtendsToolName(), sourceId, targetId, id).run();
    }

    public void cannotCreateCapabilityExtends(String sourceId, String targetId) {
        new CreateDEdgeTool(this, this.getCapabilityExtendsToolName(), sourceId, targetId).shouldFail();
    }

    public String createCapabilityIncludes(String sourceId, String targetId) {
        return this.createEdgeElement(sourceId, targetId, this.getCapabilityIncudesToolName());
    }

    @Deprecated
    public void createCapabilityIncludes(String sourceId, String targetId, String id) {
        new CreateDEdgeTool(this, this.getCapabilityIncudesToolName(), sourceId, targetId, id).run();
    }

    public void cannotCreateCapabilityIncludes(String sourceId, String targetId) {
        new CreateDEdgeTool(this, this.getCapabilityIncudesToolName(), sourceId, targetId).shouldFail();
    }

    public String createComponentExchange(String sourceId, String targetId) {
        return this.createEdgeElement(sourceId, targetId, this.getComponentExchangesToolName());
    }

    @Deprecated
    public void createComponentExchange(String sourceId, String targetId, String id) {
        new CreateDEdgeTool(this, this.getComponentExchangesToolName(), sourceId, targetId, id).run();
    }

    public void insertActor(String id) {
        this.insertActor(id, this.getDiagramId());
    }

    public void insertActor(String id, String containerId) {
        new InsertRemoveTool((DiagramContext)this, this.getActorsToolName(), containerId).insert(id);
    }

    public void removeActor(String id) {
        this.removeActor(id, this.getDiagramId());
    }

    public void removeActor(String id, String containerId) {
        new InsertRemoveTool((DiagramContext)this, this.getActorsToolName(), containerId).remove(id);
    }

    public void insertComponent(String id) {
        this.insertComponent(id, this.getDiagramId());
    }

    public void insertComponent(String id, String containerId) {
        new InsertRemoveTool((DiagramContext)this, this.getComponentsToolName(), containerId).insert(id);
    }

    public void removeComponent(String id) {
        this.removeComponent(id, this.getDiagramId());
    }

    public void removeComponent(String id, String containerId) {
        new InsertRemoveTool((DiagramContext)this, this.getComponentsToolName(), containerId).remove(id);
    }

    public void insertCapability(String ... id) {
        new InsertRemoveTool((DiagramContext)this, this.getCapabilitiesToolName(), this.getDiagramId()).insert(id);
    }

    public void removeCapability(String ... id) {
        new InsertRemoveTool((DiagramContext)this, this.getCapabilitiesToolName(), this.getDiagramId()).remove(id);
    }

    public void insertRelationship(String containerId, String ... id) {
        new InsertRemoveTool((DiagramContext)this, this.getRelationshipsToolName(), containerId).insert(id);
    }

    public void removeRelationship(String containerId, String ... id) {
        new InsertRemoveTool((DiagramContext)this, this.getRelationshipsToolName(), containerId).remove(id);
    }

    public void insertAllRelationships(String containerId) {
        new InsertRemoveTool((DiagramContext)this, this.getRelationshipsToolName(), containerId).insertAll();
    }

    public void reconnectActorGeneralizationSource(String edgeId, String oldSourceId, String newSourceId) {
        new ReconnectTool(this, this.getReconnectGeneralizationSourceToolName(), edgeId, oldSourceId, newSourceId).run();
    }

    public void reconnectActorGeneralizationTarget(String edgeId, String oldTargetId, String newTargetId) {
        new ReconnectTool(this, this.getReconnectGeneralizationTargetToolName(), edgeId, oldTargetId, newTargetId).run();
    }

    public void dragAndDropComponentFromExplorer(String idDraggedElement, String containerId) {
        this.dragAndDropFromExplorer(idDraggedElement, containerId, this.getDNDComponentFromExplorerToolName());
    }

    public void dragAndDropComponentFromDiagram(String idDraggedElement, String containerId) {
        this.dragAndDrop(idDraggedElement, containerId, "Component from Diagram");
    }

    public void dragAndDropCapabilityFromExplorer(String idDraggedElement, String containerId) {
        this.dragAndDropFromExplorer(idDraggedElement, containerId, this.getDNDCapabilityFromExplorerToolName());
    }

    @Override
    public void dragAndDropConstraintFromExplorer(String idDraggedElement, String containerId) {
        this.dragAndDropFromExplorer(idDraggedElement, containerId, this.getDNDConstraintToolName());
    }

    public void dragAndDropMissionFromExplorer(String idDraggedElement, String containerId) {
        this.dragAndDropFromExplorer(idDraggedElement, containerId, "D&D Missions From Project Explorer");
    }

    public void dragAndDropActorFromExplorer(String idDraggedElement, String containerId) {
        this.dragAndDropFromExplorer(idDraggedElement, containerId, "D&D Actors From Project Explorer");
    }

    private String getCapabilityToolName() {
        String name = null;
        if (this.isA("Contextual Operational Capability")) {
            name = "operational.capability";
        } else if (this.isA("Operational Capabilities Blank")) {
            name = "operational.capability";
        } else if (this.isA("Missions Capabilities Blank")) {
            name = "capability";
        } else if (this.isA("Missions Blank")) {
            name = "capability";
        } else if (this.isA("Contextual Capability")) {
            name = "capability";
        } else if (this.isA("Contextual Mission")) {
            name = "capability";
        } else if (this.isA("Capability Realization Blank")) {
            name = "capability.realization";
        }
        return name;
    }

    private String getComponentToolName() {
        String name = null;
        if (this.isA("Contextual Operational Capability")) {
            name = "operational.entity";
        } else if (this.isA("Operational Capabilities Blank")) {
            name = "operational.entity";
        } else if (!(this.isA("Missions Capabilities Blank") || this.isA("Missions Blank") || this.isA("Contextual Capability") || this.isA("Contextual Mission") || !this.isA("Capability Realization Blank"))) {
            name = "component";
            if (this.type == BlockArchitectureExt.Type.EPBS) {
                name = "cots";
            }
        }
        return name;
    }

    protected String getActorToolName() {
        String name = null;
        if (this.isA("Contextual Operational Capability")) {
            name = "operational.actor";
        } else if (this.isA("Operational Capabilities Blank")) {
            name = "operational.actor";
        } else if (this.isA("Missions Capabilities Blank")) {
            name = "actor";
        } else if (this.isA("Missions Blank")) {
            name = "actor";
        } else if (this.isA("Contextual Capability")) {
            name = "actor";
        } else if (this.isA("Contextual Mission")) {
            name = "actor";
        } else if (this.isA("Capability Realization Blank")) {
            name = "actor";
        }
        return name;
    }

    private String getCapabilityExtendsToolName() {
        String name = null;
        if (this.isA("Contextual Operational Capability")) {
            name = "extends";
        } else if (this.isA("Operational Capabilities Blank")) {
            name = "extends";
        } else if (this.isA("Missions Capabilities Blank")) {
            name = "extends";
        } else if (!this.isA("Missions Blank")) {
            if (this.isA("Contextual Capability")) {
                name = "extends";
            } else if (!this.isA("Contextual Mission") && this.isA("Capability Realization Blank")) {
                name = "extends";
            }
        }
        return name;
    }

    private String getCapabilityIncudesToolName() {
        String name = null;
        if (this.isA("Contextual Operational Capability")) {
            name = "includes";
        } else if (this.isA("Operational Capabilities Blank")) {
            name = "includes";
        } else if (this.isA("Missions Capabilities Blank")) {
            name = "includes";
        } else if (!this.isA("Missions Blank")) {
            if (this.isA("Contextual Capability")) {
                name = "includes";
            } else if (!this.isA("Contextual Mission") && this.isA("Capability Realization Blank")) {
                name = "includes";
            }
        }
        return name;
    }

    private String getCapabilityGeneralizationToolName() {
        String name = null;
        if (this.isA("Contextual Operational Capability")) {
            name = "operational.capability.generalization";
        } else if (this.isA("Operational Capabilities Blank")) {
            name = "operational.capability.generalization";
        } else if (this.isA("Missions Capabilities Blank")) {
            name = "actor.generalization";
        } else if (!this.isA("Missions Blank")) {
            if (this.isA("Contextual Capability")) {
                name = "actor.generalization";
            } else if (!this.isA("Contextual Mission") && this.isA("Capability Realization Blank")) {
                name = "actor.generalization";
            }
        }
        return name;
    }

    private String getCapabilityInvolvementToolName() {
        String name = null;
        if (this.isA("Contextual Operational Capability")) {
            name = "involvement";
        } else if (this.isA("Operational Capabilities Blank")) {
            name = "involvement";
        } else if (this.isA("Missions Capabilities Blank")) {
            name = "involved.actor";
        } else if (this.isA("Missions Blank")) {
            name = "actor.involvement";
        } else if (this.isA("Contextual Capability")) {
            name = "involved.actor";
        } else if (this.isA("Contextual Mission")) {
            name = "actor.involvement";
        } else if (this.isA("Capability Realization Blank")) {
            name = "involvement";
        }
        return name;
    }

    private String getComponentExchangesToolName() {
        String name = null;
        if (!this.isA("Contextual Operational Capability")) {
            if (this.isA("Operational Capabilities Blank")) {
                name = "communication.mean";
            } else if (!(this.isA("Missions Capabilities Blank") || this.isA("Missions Blank") || this.isA("Contextual Capability") || this.isA("Contextual Mission"))) {
                this.isA("Capability Realization Blank");
            }
        }
        return name;
    }

    private String getRelationshipsToolName() {
        String name = null;
        if (this.isA("Contextual Operational Capability")) {
            name = "relationships";
        } else if (this.isA("Operational Capabilities Blank")) {
            name = "relationships";
        } else if (this.isA("Missions Capabilities Blank")) {
            name = "relationships";
        } else if (this.isA("Missions Blank")) {
            name = "relationships";
        } else if (this.isA("Contextual Capability")) {
            name = "relationships";
        } else if (this.isA("Contextual Mission")) {
            name = "relationships";
        } else if (this.isA("Capability Realization Blank")) {
            name = "relationships";
        }
        return name;
    }

    private String getCapabilitiesToolName() {
        String name = null;
        if (this.isA("Contextual Operational Capability")) {
            name = "operational.capabilities";
        } else if (this.isA("Operational Capabilities Blank")) {
            name = "operational.capabilities";
        } else if (this.isA("Missions Capabilities Blank")) {
            name = "capabilities";
        } else if (this.isA("Missions Blank")) {
            name = "capabilities";
        } else if (this.isA("Contextual Capability")) {
            name = "capabilities";
        } else if (this.isA("Contextual Mission")) {
            name = "capabilities";
        } else if (this.isA("Capability Realization Blank")) {
            name = "capability.realizations";
        }
        return name;
    }

    private String getComponentsToolName() {
        String name = null;
        if (this.isA("Contextual Operational Capability")) {
            name = "operational.entities";
        } else if (this.isA("Operational Capabilities Blank")) {
            name = "operational.entities";
        } else if (!(this.isA("Missions Capabilities Blank") || this.isA("Missions Blank") || this.isA("Contextual Capability") || this.isA("Contextual Mission") || !this.isA("Capability Realization Blank"))) {
            name = "components";
        }
        return name;
    }

    private String getActorsToolName() {
        String name = null;
        if (this.isA("Contextual Operational Capability")) {
            name = "operational.actors";
        } else if (this.isA("Operational Capabilities Blank")) {
            name = "operational.actors";
        } else if (this.isA("Missions Capabilities Blank")) {
            name = "actors";
        } else if (this.isA("Missions Blank")) {
            name = "actors";
        } else if (this.isA("Contextual Capability")) {
            name = "actors";
        } else if (this.isA("Contextual Mission")) {
            name = "actors";
        } else if (this.isA("Capability Realization Blank")) {
            name = "actors";
        }
        return name;
    }

    private String getReconnectGeneralizationSourceToolName() {
        return "CB Reconnect Generalization Source";
    }

    private String getReconnectGeneralizationTargetToolName() {
        return "CB Reconnect Generalization Target";
    }

    private String getDNDConstraintToolName() {
        if (this.isA("Capability Realization Blank")) {
            return "D&D Constraint From Project Explorer";
        }
        return "D&D Constraints From Project Explorer";
    }

    private String getDNDComponentFromExplorerToolName() {
        if (this.isA("Operational Capabilities Blank") || this.isA("Contextual Operational Capability")) {
            return "D&D Entities From Project Explorer";
        }
        return "Component from Model";
    }

    private String getDNDCapabilityFromExplorerToolName() {
        if (this.isA("Operational Capabilities Blank") || this.isA("Contextual Operational Capability")) {
            return "D&D Operational Capabilities From Project Explorer";
        }
        return "D&D Capabilities From Project Explorer";
    }
}

