/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.common.ju.context;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DDiagramElementContainer;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.DNodeListElement;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.description.DAnnotation;
import org.eclipse.ui.PlatformUI;
import org.junit.Assert;
import org.polarsys.capella.common.re.CatalogElement;
import org.polarsys.capella.common.re.ui.menu.RecDynamicMenu;
import org.polarsys.capella.common.re.ui.menu.RplDynamicMenu;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.platform.sirius.ui.navigator.actions.ShowInDiagramAction;
import org.polarsys.capella.core.sirius.analysis.DiagramServices;
import org.polarsys.capella.core.sirius.ui.handlers.AbstractSelectInEditorCommandHandler;
import org.polarsys.capella.core.sirius.ui.handlers.SelectElementsOfSameTypeCommandHandler;
import org.polarsys.capella.core.sirius.ui.handlers.SelectOwnedElementsCommandHandler;
import org.polarsys.capella.core.sirius.ui.handlers.SelectOwnedPortsCommandHandler;
import org.polarsys.capella.core.sirius.ui.handlers.SelectRelatedConnectionsCommandHandler;
import org.polarsys.capella.core.sirius.ui.handlers.SelectRelatedFCElementsCommandHandler;
import org.polarsys.capella.core.sirius.ui.handlers.SelectRelatedPPElementsCommandHandler;
import org.polarsys.capella.core.sirius.ui.handlers.SelectResemblingElementsCommandHandler;
import org.polarsys.capella.test.diagram.common.ju.context.DiagramContext;
import org.polarsys.capella.test.diagram.common.ju.step.tools.CreateAbstractDNodeTool;
import org.polarsys.capella.test.diagram.common.ju.step.tools.CreateContainerTool;
import org.polarsys.capella.test.diagram.common.ju.step.tools.CreateDEdgeTool;
import org.polarsys.capella.test.diagram.common.ju.step.tools.DeleteElementTool;
import org.polarsys.capella.test.diagram.common.ju.step.tools.DragAndDropFromProjectExplorerTool;
import org.polarsys.capella.test.diagram.common.ju.step.tools.DragAndDropTool;
import org.polarsys.capella.test.diagram.common.ju.step.tools.InsertRemoveTool;
import org.polarsys.capella.test.diagram.common.ju.step.tools.titleblocks.CreateDiagramTitleBlockTool;
import org.polarsys.capella.test.diagram.common.ju.step.tools.titleblocks.CreateElementTitleBlockTool;
import org.polarsys.capella.test.diagram.common.ju.step.tools.titleblocks.InsertColumnInTitleBlockTool;
import org.polarsys.capella.test.diagram.common.ju.step.tools.titleblocks.InsertLineInTitleBlockTool;
import org.polarsys.capella.test.diagram.common.ju.step.tools.titleblocks.InsertRemoveTitleBlockTool;
import org.polarsys.capella.test.diagram.common.ju.step.tools.titleblocks.RemoveColumnFromTitleBlockTool;
import org.polarsys.capella.test.diagram.common.ju.step.tools.titleblocks.RemoveLineFromTitleBlockTool;
import org.polarsys.capella.test.diagram.common.ju.wrapper.utils.DiagramHelper;
import org.polarsys.capella.test.framework.context.SessionContext;

public class CommonDiagram
extends DiagramContext {
    public CommonDiagram(SessionContext context, DDiagram diagram) {
        super(context, diagram);
    }

    public String createConstraint(String id) {
        return this.createConstraint(id, this.getDiagramId());
    }

    public String createConstraint(String id, String containerId) {
        String name = "constraint";
        DNode createdConstraint = (DNode)new CreateAbstractDNodeTool((DiagramContext)this, name, containerId, id).run();
        return this.getSemanticIdFromView((DDiagramElement)createdConstraint);
    }

    public DDiagramElement createDiagramTitleBlock() {
        DDiagramElementContainer createdTB = (DDiagramElementContainer)new CreateDiagramTitleBlockTool((DiagramContext)this, "title.block", this.getDiagramId()).run();
        return createdTB;
    }

    public DDiagramElement createElementTitleBlock(String containerId) {
        DDiagramElementContainer createdTB = (DDiagramElementContainer)new CreateElementTitleBlockTool((DiagramContext)this, "title.block", containerId, this.getDiagramId()).run();
        return createdTB;
    }

    public void checkCreateElementTitleBlock(String containerId) {
        new CreateElementTitleBlockTool((DiagramContext)this, "title.block", containerId, this.getDiagramId()).contextOk();
    }

    public void checkCreateDiagramTitleBlock() {
        new CreateDiagramTitleBlockTool((DiagramContext)this, "title.block", this.getDiagramId()).contextOk();
    }

    public void checkAutocreateDiagramTitleBlock() {
        new CreateDiagramTitleBlockTool((DiagramContext)this, "title.block", this.getDiagramId()).checkAutocreate();
    }

    public void removeElementTitleBlock(String id) {
        new InsertRemoveTitleBlockTool((DiagramContext)this, "title.blocks").remove(id);
    }

    public void insertElementTitleBlock(String id) {
        new InsertRemoveTitleBlockTool((DiagramContext)this, "title.blocks").insert(id);
    }

    public void removeDiagramTitleBlock(String id) {
        new InsertRemoveTitleBlockTool((DiagramContext)this, "title.blocks").remove(id);
    }

    public void insertDiagramTitleBlock(String id) {
        new InsertRemoveTitleBlockTool((DiagramContext)this, "title.blocks").insert(id);
    }

    public DAnnotation insertLineInTitleBlock(DAnnotation titleBlock, int lineNo) {
        DDiagramElementContainer createdTB = (DDiagramElementContainer)new InsertLineInTitleBlockTool((DiagramContext)this, "title.block.line", this.getDiagramId(), titleBlock, lineNo).run();
        return (DAnnotation)createdTB.getTarget();
    }

    public DAnnotation insertColumnInTitleBlock(DAnnotation titleBlock, int colNo) {
        DDiagramElementContainer createdTB = (DDiagramElementContainer)new InsertColumnInTitleBlockTool((DiagramContext)this, "title.block.column", this.getDiagramId(), titleBlock, colNo).run();
        return (DAnnotation)createdTB.getTarget();
    }

    public DAnnotation removeLineFromTitleBlock(DAnnotation titleBlock, int lineNo) {
        DDiagramElementContainer createdTB = (DDiagramElementContainer)new RemoveLineFromTitleBlockTool((DiagramContext)this, "remove.title.block.line", this.getDiagramId(), titleBlock, lineNo).run();
        return (DAnnotation)createdTB.getTarget();
    }

    public DAnnotation removeColumnFromTitleBlock(DAnnotation titleBlock, int colNo) {
        DDiagramElementContainer createdTB = (DDiagramElementContainer)new RemoveColumnFromTitleBlockTool((DiagramContext)this, "remove.title.block.column", this.getDiagramId(), titleBlock, colNo).run();
        return (DAnnotation)createdTB.getTarget();
    }

    public void deleteSemantic(DDiagramElement view) {
        new DeleteElementTool(this).delete(view);
    }

    public void deleteAllSemantic() {
        new DeleteElementTool(this).deleteAll();
    }

    public String createConstrainedElement(String sourceId, String targetId) {
        String name = "constraint.element";
        DEdge edge = (DEdge)new CreateDEdgeTool(this, name, sourceId, targetId).run();
        return this.getSemanticIdFromView((DDiagramElement)edge);
    }

    public void removeConstraint(String id, String containerId) {
        new InsertRemoveTool((DiagramContext)this, "constraints", containerId).remove(id);
    }

    public void insertConstraint(String id, String containerId) {
        new InsertRemoveTool((DiagramContext)this, "constraints", containerId).insert(id);
    }

    public void insertPV(String id, String containerId) {
        new InsertRemoveTool((DiagramContext)this, "applied.property.values", containerId).insert(id);
    }

    public void removePV(String id, String containerId) {
        new InsertRemoveTool((DiagramContext)this, "applied.property.values", containerId).remove(id);
    }

    public void insertPVG(String id, String containerId) {
        new InsertRemoveTool((DiagramContext)this, "applied.property.value.groups", containerId).insert(id);
    }

    public void removePVG(String id, String containerId) {
        new InsertRemoveTool((DiagramContext)this, "applied.property.value.groups", containerId).remove(id);
    }

    public void selectSameType(String initialElement) {
        DSemanticDecorator decorator = this.getView(initialElement);
        final EditPart correspondingEditPart = DiagramServices.getDiagramServices().getEditPart((DDiagramElement)decorator);
        ExecutionEvent event = this.createExecutionEvent(correspondingEditPart);
        SelectElementsOfSameTypeCommandHandler handler = new SelectElementsOfSameTypeCommandHandler(){

            protected IStructuredSelection getSelection() {
                StructuredSelection selection = new StructuredSelection((Object)correspondingEditPart);
                return selection;
            }
        };
        this.assertSelectionWorked(event, (AbstractSelectInEditorCommandHandler)handler);
    }

    public void selectSameMapping(String initialElement) {
        DSemanticDecorator decorator = this.getView(initialElement);
        final EditPart correspondingEditPart = DiagramServices.getDiagramServices().getEditPart((DDiagramElement)decorator);
        ExecutionEvent event = this.createExecutionEvent(correspondingEditPart);
        SelectResemblingElementsCommandHandler handler = new SelectResemblingElementsCommandHandler(){

            protected IStructuredSelection getSelection() {
                StructuredSelection selection = new StructuredSelection((Object)correspondingEditPart);
                return selection;
            }
        };
        this.assertSelectionWorked(event, (AbstractSelectInEditorCommandHandler)handler);
    }

    public void selectRelatedRecs(String initialElement, String ... expectedSelection) {
        DSemanticDecorator decorator = this.getView(initialElement);
        EditPart editPart = DiagramServices.getDiagramServices().getEditPart((DDiagramElement)decorator);
        Collection commonRecs = RecDynamicMenu.getCommonRecs((IStructuredSelection)new StructuredSelection((Object)editPart));
        Assert.assertNotNull((Object)commonRecs);
        if (expectedSelection != null && expectedSelection.length != 0) {
            CatalogElement commonRec = (CatalogElement)commonRecs.iterator().next();
            EList refs = commonRec.getReferencedElements();
            ShowInDiagramAction action = new ShowInDiagramAction();
            action.selectionChanged((IStructuredSelection)new StructuredSelection((List)refs));
            action.run();
            IStructuredSelection selec = (IStructuredSelection)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getSelection();
            List selectedElements = selec.toList().stream().map(EditPart.class::cast).map(elem -> elem.getModel()).map(View.class::cast).map(view -> view.getElement()).map(DDiagramElement.class::cast).map(diagramElement -> diagramElement.getTarget()).collect(Collectors.toList());
            List expectedElements = Arrays.stream(expectedSelection).map(sel -> this.getView((String)sel)).map(view -> view.getTarget()).collect(Collectors.toList());
            if (selectedElements.size() != expectedElements.size() || !selectedElements.containsAll(expectedElements)) {
                Assert.fail((String)"Selection didn't correspond to expected selection");
            }
        }
    }

    public void selectRelatedRpls(String initialElement, String ... expectedSelection) {
        DSemanticDecorator decorator = this.getView(initialElement);
        EditPart editPart = DiagramServices.getDiagramServices().getEditPart((DDiagramElement)decorator);
        Collection commonRpls = RplDynamicMenu.getCommonRpls((IStructuredSelection)new StructuredSelection((Object)editPart));
        Assert.assertNotNull((Object)commonRpls);
        if (expectedSelection != null && expectedSelection.length != 0) {
            CatalogElement commonRpl = (CatalogElement)commonRpls.iterator().next();
            EList refs = commonRpl.getReferencedElements();
            ShowInDiagramAction action = new ShowInDiagramAction();
            action.selectionChanged((IStructuredSelection)new StructuredSelection((List)refs));
            action.run();
            IStructuredSelection selec = (IStructuredSelection)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getSelection();
            List selectedElements = selec.toList().stream().map(EditPart.class::cast).map(elem -> elem.getModel()).map(View.class::cast).map(view -> view.getElement()).map(DDiagramElement.class::cast).map(diagramElement -> diagramElement.getTarget()).collect(Collectors.toList());
            List expectedElements = Arrays.stream(expectedSelection).map(sel -> this.getView((String)sel)).map(view -> view.getTarget()).collect(Collectors.toList());
            if (selectedElements.size() != expectedElements.size() || !selectedElements.containsAll(expectedElements)) {
                Assert.fail((String)"Selection didn't correspond to expected selection");
            }
        }
    }

    public void selectRelatedFCElements(String initialElement, String ... expectedSelection) {
        DSemanticDecorator decorator = this.getView(initialElement);
        final EditPart correspondingEditPart = DiagramServices.getDiagramServices().getEditPart((DDiagramElement)decorator);
        ExecutionEvent event = this.createExecutionEvent(correspondingEditPart);
        SelectRelatedFCElementsCommandHandler handler = new SelectRelatedFCElementsCommandHandler(){

            protected IStructuredSelection getSelection() {
                StructuredSelection selection = new StructuredSelection((Object)correspondingEditPart);
                return selection;
            }
        };
        this.assertSelectionWorked(event, (AbstractSelectInEditorCommandHandler)handler);
        IStructuredSelection selec = (IStructuredSelection)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getSelection();
        List selectedElements = selec.toList().stream().map(EditPart.class::cast).map(elem -> elem.getModel()).map(View.class::cast).map(view -> view.getElement()).map(DDiagramElement.class::cast).collect(Collectors.toList());
        List expectedElements = Arrays.stream(expectedSelection).map(sel -> DiagramHelper.getOnDiagramByUID(this.getDiagram(), sel)).collect(Collectors.toList());
        if (selectedElements.size() != expectedElements.size() || !selectedElements.containsAll(expectedElements)) {
            Assert.fail((String)"Selection didn't correspond to expected selection");
        }
    }

    public void selectRelatedPPElements(String initialElement, String ... expectedSelection) {
        DSemanticDecorator decorator = this.getView(initialElement);
        final EditPart correspondingEditPart = DiagramServices.getDiagramServices().getEditPart((DDiagramElement)decorator);
        ExecutionEvent event = this.createExecutionEvent(correspondingEditPart);
        SelectRelatedPPElementsCommandHandler handler = new SelectRelatedPPElementsCommandHandler(){

            protected IStructuredSelection getSelection() {
                StructuredSelection selection = new StructuredSelection((Object)correspondingEditPart);
                return selection;
            }
        };
        this.assertSelectionWorked(event, (AbstractSelectInEditorCommandHandler)handler);
        IStructuredSelection selec = (IStructuredSelection)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getSelection();
        List selectedElements = selec.toList().stream().map(EditPart.class::cast).map(elem -> elem.getModel()).map(View.class::cast).map(view -> view.getElement()).map(DDiagramElement.class::cast).collect(Collectors.toList());
        List expectedElements = Arrays.stream(expectedSelection).map(sel -> DiagramHelper.getOnDiagramByUID(this.getDiagram(), sel)).collect(Collectors.toList());
        if (selectedElements.size() != expectedElements.size() || !selectedElements.containsAll(expectedElements)) {
            Assert.fail((String)"Selection didn't correspond to expected selection");
        }
    }

    public void selectOwnedPorts(String initialElement) {
        DSemanticDecorator decorator = this.getView(initialElement);
        final EditPart correspondingEditPart = DiagramServices.getDiagramServices().getEditPart((DDiagramElement)decorator);
        ExecutionEvent event = this.createExecutionEvent(correspondingEditPart);
        SelectOwnedPortsCommandHandler handler = new SelectOwnedPortsCommandHandler(){

            protected IStructuredSelection getSelection() {
                StructuredSelection selection = new StructuredSelection((Object)correspondingEditPart);
                return selection;
            }
        };
        this.assertSelectionWorked(event, (AbstractSelectInEditorCommandHandler)handler);
    }

    public void selectOwnedElements(String initialElement) {
        DSemanticDecorator decorator = this.getView(initialElement);
        final EditPart correspondingEditPart = DiagramServices.getDiagramServices().getEditPart((DDiagramElement)decorator);
        ExecutionEvent event = this.createExecutionEvent(correspondingEditPart);
        SelectOwnedElementsCommandHandler handler = new SelectOwnedElementsCommandHandler(){

            protected IStructuredSelection getSelection() {
                StructuredSelection selection = new StructuredSelection((Object)correspondingEditPart);
                return selection;
            }
        };
        this.assertSelectionWorked(event, (AbstractSelectInEditorCommandHandler)handler);
    }

    public void selectRelatedEdges(String initialElement) {
        DSemanticDecorator decorator = this.getView(initialElement);
        final EditPart correspondingEditPart = DiagramServices.getDiagramServices().getEditPart((DDiagramElement)decorator);
        ExecutionEvent event = this.createExecutionEvent(correspondingEditPart);
        SelectRelatedConnectionsCommandHandler handler = new SelectRelatedConnectionsCommandHandler(){

            protected IStructuredSelection getSelection() {
                StructuredSelection selection = new StructuredSelection((Object)correspondingEditPart);
                return selection;
            }
        };
        this.assertSelectionWorked(event, (AbstractSelectInEditorCommandHandler)handler);
    }

    private void assertSelectionWorked(ExecutionEvent event, AbstractSelectInEditorCommandHandler handler) {
        Object result = null;
        try {
            result = handler.execute(event);
        }
        catch (ExecutionException e) {
            Assert.fail((String)("Could not execute handler " + handler.getClass().getSimpleName()));
        }
        if (result == null) {
            Assert.fail((String)"Result shouldn't be null");
        }
    }

    public void dragAndDropConstraintFromExplorer(String idDraggedElement, String containerId) {
        this.dragAndDropFromExplorer(idDraggedElement, containerId, "D&D Constraint From Project Explorer");
    }

    public void dragAndDropConstraintsFromExplorer(String idDraggedElement, String containerId) {
        this.dragAndDropFromExplorer(idDraggedElement, containerId, "D&D Constraints From Project Explorer");
    }

    public void dragAndDropCComponentFromExplorer(String idDraggedElement, String containerId) {
        this.dragAndDropFromExplorer(idDraggedElement, containerId, "D&D Constraint From Project Explorer");
    }

    protected String createNodeElement(String containerId, String toolName) {
        DNode graphicalElement = (DNode)new CreateAbstractDNodeTool((DiagramContext)this, toolName, containerId).run();
        this.customVerificationOnCreatedNodeElement(toolName, graphicalElement, containerId);
        return this.getSemanticIdFromView((DDiagramElement)graphicalElement);
    }

    protected String createNodeListElement(String containerId, String toolName) {
        DNodeListElement graphicalElement = (DNodeListElement)new CreateAbstractDNodeTool((DiagramContext)this, toolName, containerId).run();
        return this.getSemanticIdFromView((DDiagramElement)graphicalElement);
    }

    protected String createNodeElement(String targetId, String containerId, String toolName) {
        DNode graphicalElement = (DNode)new CreateAbstractDNodeTool<DNode>((DiagramContext)this, toolName, targetId, containerId, null, DNode.class).run();
        this.customVerificationOnCreatedNodeElement(toolName, graphicalElement, containerId);
        return this.getSemanticIdFromView((DDiagramElement)graphicalElement);
    }

    protected String createContainerElement(String containerId, String toolName) {
        DDiagramElementContainer graphicalElement = (DDiagramElementContainer)new CreateContainerTool((DiagramContext)this, toolName, containerId).run();
        this.customVerificationOnCreatedContainerElement(toolName, graphicalElement, containerId);
        return this.getSemanticIdFromView((DDiagramElement)graphicalElement);
    }

    protected String createEdgeElement(String sourceViewId, String targetViewId, String toolName) {
        DEdge graphicalElement = (DEdge)new CreateDEdgeTool(this, toolName, sourceViewId, targetViewId).run();
        this.customVerificationOnCreatedEdgeElement(toolName, (DDiagramElement)graphicalElement, sourceViewId, targetViewId);
        return this.getSemanticIdFromView((DDiagramElement)graphicalElement);
    }

    protected String createEdgeElement(String sourceViewId, String targetViewId, String toolName, int newEdgesNumber) {
        DEdge graphicalElement = (DEdge)new CreateDEdgeTool((DiagramContext)this, toolName, sourceViewId, targetViewId, newEdgesNumber, 0, 0).run();
        this.customVerificationOnCreatedEdgeElement(toolName, (DDiagramElement)graphicalElement, sourceViewId, targetViewId);
        return this.getSemanticIdFromView((DDiagramElement)graphicalElement);
    }

    protected void insertElements(String containerId, String toolName, String ... elementsToBeInsertedIds) {
        new InsertRemoveTool((DiagramContext)this, toolName, containerId).insert(elementsToBeInsertedIds);
    }

    protected void removeElements(String containerId, String toolName, String ... elementsToBeRemovedIds) {
        new InsertRemoveTool((DiagramContext)this, toolName, containerId).remove(elementsToBeRemovedIds);
    }

    protected void dragAndDrop(String idDraggedElement, String containerId, String toolName) {
        new DragAndDropTool(this, toolName, idDraggedElement, containerId).run();
    }

    protected String dragAndDropFromExplorer(String idDraggedElement, String containerId, String toolName) {
        EObject droppedElementSemantic = this.getSessionContext().getSemanticElement(idDraggedElement);
        DDiagramElement elem = (DDiagramElement)new DragAndDropFromProjectExplorerTool((DiagramContext)this, toolName, droppedElementSemantic, containerId).run();
        return this.getSemanticIdFromView(elem);
    }

    protected void customVerificationOnCreatedNodeElement(String toolName, DNode graphicalElement, String containerId) {
    }

    protected void customVerificationOnCreatedEdgeElement(String toolName, DDiagramElement view, String sourceId, String targetId) {
    }

    protected void customVerificationOnCreatedContainerElement(String toolName, DDiagramElementContainer graphicalElement, String containerId) {
    }

    @Override
    public String getSemanticIdFromView(DDiagramElement view) {
        EObject semanticElement = view.getTarget();
        return ((CapellaElement)semanticElement).getId();
    }

    protected ExecutionEvent createExecutionEvent(Object ... elements) {
        EvaluationContext context = new EvaluationContext(null, new Object());
        HashMap parameters = new HashMap();
        ExecutionEvent event = new ExecutionEvent(null, parameters, null, (Object)context);
        context.addVariable("selection", (Object)new StructuredSelection(Arrays.asList(elements)));
        return event;
    }
}

