/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.common.ju.context;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.EdgeTarget;
import org.eclipse.sirius.diagram.description.AbstractNodeMapping;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.junit.Assert;
import org.polarsys.capella.common.helpers.EObjectExt;
import org.polarsys.capella.common.helpers.EObjectLabelProviderHelper;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.diagram.helpers.DiagramHelper;
import org.polarsys.capella.core.model.handler.helpers.RepresentationHelper;
import org.polarsys.capella.core.sirius.analysis.DiagramServices;
import org.polarsys.capella.test.diagram.common.ju.step.crud.ClearDiagramStep;
import org.polarsys.capella.test.diagram.common.ju.step.crud.OpenDiagramStep;
import org.polarsys.capella.test.diagram.common.ju.step.crud.RefreshDiagramStep;
import org.polarsys.capella.test.diagram.common.ju.step.crud.SetContextualElementsStep;
import org.polarsys.capella.test.diagram.common.ju.step.tools.AbstractToolStep;
import org.polarsys.capella.test.framework.api.CommonTestMessages;
import org.polarsys.capella.test.framework.context.SessionContext;

public class DiagramContext {
    private SessionContext sessionContext;
    private DDiagram diagram;
    private String diagramIdentifier;
    private String diagramType;
    private Map<String, DDiagramElement> objectViewMap;

    public DiagramContext(SessionContext context, DDiagram diagram) {
        this.diagram = diagram;
        this.diagramIdentifier = EObjectExt.getText((EObject)diagram);
        this.diagramType = diagram.getDescription().getName();
        this.sessionContext = context;
    }

    public static DiagramContext getDiagram(SessionContext sessionContext, String diagramIdentifier) {
        Session session = sessionContext.getSession();
        ResourceSet resource = session.getTransactionalEditingDomain().getResourceSet();
        DRepresentationDescriptor desc = RepresentationHelper.getRepresentationDescriptor((ResourceSet)resource, (String)diagramIdentifier);
        return new DiagramContext(sessionContext, (DDiagram)desc.getRepresentation());
    }

    public Map<String, DDiagramElement> getViewObjectMap() {
        if (this.objectViewMap == null) {
            this.objectViewMap = new HashMap<String, DDiagramElement>();
        }
        return this.objectViewMap;
    }

    public String getType() {
        return this.diagramType;
    }

    public Map<String, EObject> getSemanticObjectMap() {
        return this.sessionContext.getSemanticObjectMap();
    }

    public DDiagram getDiagram() {
        return this.diagram;
    }

    public DRepresentationDescriptor getDiagramDescriptor() {
        return RepresentationHelper.getRepresentationDescriptor((DRepresentation)this.diagram);
    }

    public String getDiagramId() {
        return this.diagramIdentifier;
    }

    public SessionContext getSessionContext() {
        return this.sessionContext;
    }

    protected boolean isA(String diagramDescription) {
        return DiagramHelper.getService().isA((DRepresentation)this.diagram, diagramDescription);
    }

    public DSemanticDecorator getView(String semanticIdentifier) {
        EObject o;
        if (this.getDiagramId().equals(semanticIdentifier)) {
            return (DSemanticDiagram)this.diagram;
        }
        DSemanticDecorator view = null;
        if (this.getViewObjectMap().containsKey(semanticIdentifier)) {
            view = (DSemanticDecorator)this.getViewObjectMap().get(semanticIdentifier);
            if (DiagramHelper.getService().getDiagramContainer((EObject)view) == null) {
                this.getViewObjectMap().remove(semanticIdentifier);
                view = null;
            }
        }
        if (view == null && (view = this.getView(this.sessionContext.getSemanticElement(semanticIdentifier))) instanceof DDiagramElement) {
            this.putView(semanticIdentifier, (DDiagramElement)view);
        }
        if (view == null && (o = this.diagram.eResource().getEObject(semanticIdentifier)) instanceof DDiagramElement) {
            this.putView(semanticIdentifier, (DDiagramElement)o);
            view = (DDiagramElement)o;
        }
        return view;
    }

    public DDiagramElement getView(EObject semantic) {
        return org.polarsys.capella.test.diagram.common.ju.wrapper.utils.DiagramHelper.getOnDiagram(this.diagram, semantic);
    }

    public DDiagramElement getView(String semanticIdentifier, DSemanticDecorator view) {
        EObject semantic = this.sessionContext.getSemanticElement(semanticIdentifier);
        return org.polarsys.capella.test.diagram.common.ju.wrapper.utils.DiagramHelper.getOnDiagram(this.diagram, semantic, (EObject)view);
    }

    protected EObject adaptToView(EObject semantic) {
        return semantic;
    }

    public void putView(String newIdentifier, DDiagramElement view) {
        this.getViewObjectMap().put(newIdentifier, view);
    }

    public boolean hasEdge(String sourceId, String targetId, String edgeId) {
        EObject semanticSource = this.sessionContext.getSemanticElement(sourceId);
        DDiagramElement viewSource = this.getView(semanticSource);
        Assert.assertTrue((String)NLS.bind((String)CommonTestMessages.objectRepresentationNotAvailableOnDiagram, (Object)EObjectLabelProviderHelper.getText((Object)viewSource)), (viewSource != null ? 1 : 0) != 0);
        EObject semanticTarget = this.sessionContext.getSemanticElement(targetId);
        DDiagramElement viewTarget = this.getView(semanticTarget);
        Assert.assertTrue((String)NLS.bind((String)CommonTestMessages.objectRepresentationNotAvailableOnDiagram, (Object)EObjectLabelProviderHelper.getText((Object)viewTarget)), (viewTarget != null ? 1 : 0) != 0);
        Assert.assertTrue((String)"The source should be of type EdgeTarget", (boolean)(viewSource instanceof EdgeTarget));
        Assert.assertTrue((String)"The target should be of type EdgeTarget", (boolean)(viewTarget instanceof EdgeTarget));
        EdgeTarget portSource = (EdgeTarget)viewSource;
        EdgeTarget portTarget = (EdgeTarget)viewTarget;
        ArrayList relatedEdgesToSource = new ArrayList();
        relatedEdgesToSource.addAll(portSource.getIncomingEdges());
        relatedEdgesToSource.addAll(portSource.getOutgoingEdges());
        ArrayList relatedEdgesToTarget = new ArrayList();
        relatedEdgesToTarget.addAll(portTarget.getIncomingEdges());
        relatedEdgesToTarget.addAll(portTarget.getOutgoingEdges());
        boolean hasEdge = false;
        block0: for (DEdge edgeToTarget : relatedEdgesToTarget) {
            for (DEdge edgeToSource : relatedEdgesToSource) {
                if (!edgeToTarget.equals(edgeToSource) || !edgeToSource.getTarget().equals(this.sessionContext.getSemanticElement(edgeId))) continue;
                hasEdge = true;
                continue block0;
            }
        }
        return hasEdge;
    }

    public void hasView(String identifier) {
        this.hasView(identifier, null);
    }

    public void hasViews(String ... identifiers) {
        if (identifiers != null) {
            String[] stringArray = identifiers;
            int n = identifiers.length;
            int n2 = 0;
            while (n2 < n) {
                String identifier = stringArray[n2];
                this.hasView(identifier, null);
                ++n2;
            }
        }
    }

    public void hasView(String identifier, String mappingName) {
        EObject eObject = this.sessionContext.getSemanticElement(identifier);
        DSemanticDecorator view = this.getView(identifier);
        boolean result = view != null;
        Assert.assertTrue((String)NLS.bind((String)CommonTestMessages.objectRepresentationNotAvailableOnDiagram, (Object)EObjectLabelProviderHelper.getText((Object)eObject)), (boolean)result);
        if (mappingName != null) {
            AbstractNodeMapping mapping = DiagramServices.getDiagramServices().getAbstractNodeMapping(this.getDiagram().getDescription(), mappingName);
            Assert.assertTrue((String)NLS.bind((String)CommonTestMessages.wrongMapping, (Object)mappingName), (boolean)DiagramServices.getDiagramServices().isMapping((DDiagramElement)view, (DiagramElementMapping)mapping));
        }
    }

    public void hasntView(String identifier) {
        EObject eObject = this.sessionContext.getSemanticElement(identifier);
        boolean result = this.getView(identifier) == null;
        Assert.assertTrue((String)NLS.bind((String)CommonTestMessages.objectRepresentationStillAvailableOnDiagram, (Object)EObjectLabelProviderHelper.getText((Object)eObject)), (boolean)result);
    }

    public void hasntViews(String ... identifiers) {
        if (identifiers != null) {
            String[] stringArray = identifiers;
            int n = identifiers.length;
            int n2 = 0;
            while (n2 < n) {
                String identifier = stringArray[n2];
                this.hasntView(identifier);
                ++n2;
            }
        }
    }

    public void hasHiddenViews(String ... identifiers) {
        if (identifiers != null) {
            String[] stringArray = identifiers;
            int n = identifiers.length;
            int n2 = 0;
            while (n2 < n) {
                String identifier = stringArray[n2];
                this.hasHiddenView(identifier);
                ++n2;
            }
        }
    }

    public void hasHiddenView(String identifier) {
        EObject eObject = this.sessionContext.getSemanticElement(identifier);
        DSemanticDecorator view = this.getView(identifier);
        if (view == null) {
            Assert.assertTrue((String)"view is null", (boolean)false);
        } else if (view instanceof DDiagramElement) {
            boolean result = DiagramServices.getDiagramServices().isHidden((DDiagramElement)view);
            Assert.assertTrue((String)NLS.bind((String)CommonTestMessages.objectRepresentationStillAvailableOnDiagram, (Object)EObjectLabelProviderHelper.getText((Object)eObject)), (boolean)result);
        } else {
            Assert.assertTrue((String)"view is diagram", (boolean)false);
        }
    }

    public void hasFilteredView(String identifier) {
        EObject eObject = this.sessionContext.getSemanticElement(identifier);
        DSemanticDecorator view = this.getView(identifier);
        if (view == null) {
            Assert.assertTrue((String)"view is null", (boolean)false);
        } else if (view instanceof DDiagramElement) {
            boolean result = DiagramServices.getDiagramServices().isFiltered((DDiagramElement)view);
            Assert.assertTrue((String)NLS.bind((String)CommonTestMessages.objectRepresentationStillAvailableOnDiagram, (Object)EObjectLabelProviderHelper.getText((Object)eObject)), (boolean)result);
        } else {
            Assert.assertTrue((String)"view is diagram", (boolean)false);
        }
    }

    public DiagramContext open() {
        new OpenDiagramStep(this, false).run();
        return this;
    }

    public DiagramContext close() {
        org.polarsys.capella.test.diagram.common.ju.wrapper.utils.DiagramHelper.closeEditor(this.sessionContext.getSession(), this.getDiagram());
        return this;
    }

    public void refreshDiagram() {
        new RefreshDiagramStep(this).run();
    }

    public void clearDiagram() {
        new ClearDiagramStep(this).run();
    }

    public void mustBeInstanceOf(String objectId, EClass clazz) {
        Assert.assertTrue((boolean)clazz.isInstance((Object)this.sessionContext.getSemanticElement(objectId)));
    }

    public void mustBeLinkedTo(String objectId, String valueId, EStructuralFeature feature) {
        EObject object = this.sessionContext.getSemanticElement(objectId);
        EObject value = this.sessionContext.getSemanticElement(valueId);
        if (feature.isMany()) {
            Assert.assertTrue((boolean)((EList)object.eGet(feature)).contains((Object)value));
        } else {
            Assert.assertTrue((boolean)object.eGet(feature).equals(value));
        }
    }

    public void hasCountViews(int i) {
        Assert.assertTrue((this.getDiagram().getDiagramElements().size() == i ? 1 : 0) != 0);
    }

    public void mustBeOwnedBy(String objectId, String containerId) {
        EObject object = this.sessionContext.getSemanticElement(objectId);
        EObject container = this.sessionContext.getSemanticElement(containerId);
        Assert.assertTrue((boolean)object.eContainer().equals(container));
    }

    public void mustGraphicalOwnedBy(String objectId, String containerId) {
        Assert.assertTrue((boolean)this.getView(objectId).eContainer().equals(this.getView(containerId)));
    }

    public void setContextualElements(String ... ids) {
        new SetContextualElementsStep(this, ids).run();
    }

    public Collection<EObject> adaptTool(AbstractToolStep<?> tool, Map<String, Object> parameters, Collection<EObject> semanticElements) {
        return semanticElements;
    }

    protected String getSemanticIdFromView(DDiagramElement view) {
        EObject semanticElement = view.getTarget();
        return ((CapellaElement)semanticElement).getId();
    }
}

