/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.common.ju.context;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.diagram.DDiagram;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.test.diagram.common.ju.context.DiagramContext;
import org.polarsys.capella.test.diagram.common.ju.context.OA_ESDiagram;
import org.polarsys.capella.test.diagram.common.ju.context.PA_ESDiagram;
import org.polarsys.capella.test.diagram.common.ju.context.SA_ESDiagram;
import org.polarsys.capella.test.diagram.common.ju.context.SequenceDiagram;
import org.polarsys.capella.test.diagram.common.ju.step.crud.CreateDiagramStep;
import org.polarsys.capella.test.diagram.common.ju.step.crud.OpenDiagramStep;
import org.polarsys.capella.test.diagram.common.ju.step.tools.sequence.LostFoundMessageCreationTool;
import org.polarsys.capella.test.diagram.common.ju.step.tools.sequence.MessageCreationTool;
import org.polarsys.capella.test.framework.context.SessionContext;

public class ESDiagram
extends SequenceDiagram {
    public ESDiagram(BlockArchitectureExt.Type type, SessionContext context, DDiagram diagram) {
        super(type, context, diagram);
    }

    public static ESDiagram createDiagram(SessionContext executionContext, String targetIdentifier) {
        BlockArchitecture architecture = BlockArchitectureExt.getRootBlockArchitecture((EObject)executionContext.getSemanticElement(targetIdentifier));
        final BlockArchitectureExt.Type type = BlockArchitectureExt.getBlockArchitectureType((BlockArchitecture)architecture);
        String name = null;
        name = type == BlockArchitectureExt.Type.OA ? "Operational Interaction Scenario" : "Component Exchanges Scenario";
        if (type == BlockArchitectureExt.Type.OA) {
            return (OA_ESDiagram)((DiagramContext)new CreateDiagramStep(executionContext, targetIdentifier, name){

                @Override
                public DiagramContext getResult() {
                    return new OA_ESDiagram(type, this.getExecutionContext(), this.diagram);
                }
            }.run()).open();
        }
        if (type == BlockArchitectureExt.Type.SA) {
            return (SA_ESDiagram)((DiagramContext)new CreateDiagramStep(executionContext, targetIdentifier, name){

                @Override
                public DiagramContext getResult() {
                    return new SA_ESDiagram(type, this.getExecutionContext(), this.diagram);
                }
            }.run()).open();
        }
        if (type == BlockArchitectureExt.Type.PA) {
            return (PA_ESDiagram)((DiagramContext)new CreateDiagramStep(executionContext, targetIdentifier, name){

                @Override
                public DiagramContext getResult() {
                    return new PA_ESDiagram(type, this.getExecutionContext(), this.diagram);
                }
            }.run()).open();
        }
        return (ESDiagram)((DiagramContext)new CreateDiagramStep(executionContext, targetIdentifier, name){

            @Override
            public DiagramContext getResult() {
                return new ESDiagram(type, this.getExecutionContext(), this.diagram);
            }
        }.run()).open();
    }

    public static ESDiagram openDiagram(SessionContext executionContext, String name, final BlockArchitectureExt.Type type) {
        return (ESDiagram)((DiagramContext)new OpenDiagramStep(executionContext, name){

            @Override
            public DiagramContext getResult() {
                return new ESDiagram(type, this.getExecutionContext(), this.diagram);
            }
        }.run()).open();
    }

    public String createComponent() {
        return this.createComponent(this.getDiagramId());
    }

    public String insertComponent(String id) {
        SequenceDiagram.InsertRemoveInstanceRoleTool tool = new SequenceDiagram.InsertRemoveInstanceRoleTool((DiagramContext)this, "components");
        tool.insert(id);
        return id;
    }

    public String removeComponent(String id) {
        SequenceDiagram.InsertRemoveInstanceRoleTool tool = new SequenceDiagram.InsertRemoveInstanceRoleTool((DiagramContext)this, "components");
        tool.remove(id);
        return id;
    }

    public String createComponent(String containerId) {
        return this.createNodeElement(containerId, "component");
    }

    public void createComponentExchange(String componentExchange, String source, String target) {
        new MessageCreationTool((DiagramContext)this, "component.exchange", componentExchange, source, target).run();
    }

    public void createComponentExchangeWithReturnBranch(String componentExchange, String source, String target) {
        new MessageCreationTool((DiagramContext)this, "component.exchange.with.return.branch", componentExchange, source, target, true).run();
    }

    public void createFoundFunctionalExchange(String functionalExchange, String target) {
        String name = "found.functional.exchange";
        new LostFoundMessageCreationTool(this, name, target, functionalExchange, null, target).run();
    }

    public void createLostFunctionalExchange(String functionalExchange, String source) {
        String name = "lost.functional.exchange";
        new LostFoundMessageCreationTool(this, name, source, functionalExchange, source, null).run();
    }
}

