/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.common.ju.context;

import java.util.Arrays;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElementContainer;
import org.eclipse.sirius.diagram.DNode;
import org.junit.Assert;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.information.ExchangeMechanism;
import org.polarsys.capella.test.diagram.common.ju.context.CommonDiagram;
import org.polarsys.capella.test.diagram.common.ju.context.DiagramContext;
import org.polarsys.capella.test.diagram.common.ju.step.crud.CreateDiagramStep;
import org.polarsys.capella.test.diagram.common.ju.step.crud.OpenDiagramStep;
import org.polarsys.capella.test.diagram.common.ju.step.tools.CreateContainerTool;
import org.polarsys.capella.test.diagram.common.ju.step.tools.CreateDEdgeTool;
import org.polarsys.capella.test.diagram.common.ju.step.tools.CreateNodeTool;
import org.polarsys.capella.test.diagram.common.ju.step.tools.InsertRemoveTool;
import org.polarsys.capella.test.diagram.common.ju.step.tools.ReconnectTool;
import org.polarsys.capella.test.framework.context.SessionContext;

public class IDBDiagram
extends CommonDiagram {
    String type = null;

    public IDBDiagram(SessionContext context, DDiagram diagram) {
        super(context, diagram);
    }

    public static IDBDiagram createDiagram(SessionContext executionContext, String diagramKind, String targetIdentifier) {
        if (!Arrays.asList("Interfaces Diagram Blank", "Contextual Component Detailed Interfaces", "Contextual Component External Interfaces", "Contextual Component Internal Interfaces").contains(diagramKind)) {
            throw new RuntimeException("this diagram is not compatible with IDBDiagram API");
        }
        return (IDBDiagram)((DiagramContext)new CreateDiagramStep(executionContext, targetIdentifier, diagramKind){

            @Override
            public DiagramContext getResult() {
                return new IDBDiagram(this.getExecutionContext(), this.diagram);
            }
        }.run()).open();
    }

    public static IDBDiagram openDiagram(SessionContext executionContext, String name) {
        return (IDBDiagram)((DiagramContext)new OpenDiagramStep(executionContext, name){

            @Override
            public DiagramContext getResult() {
                return new IDBDiagram(this.getExecutionContext(), this.diagram);
            }
        }.run()).open();
    }

    public static IDBDiagram createDiagram(SessionContext executionContext, String targetIdentifier) {
        return IDBDiagram.createDiagram(executionContext, "Interfaces Diagram Blank", targetIdentifier);
    }

    public String createActor() {
        return this.createContainerElement(this.getDiagramId(), this.getCreateActorToolName());
    }

    public String createSubActor(String containerId) {
        return this.createContainerElement(containerId, this.getCreateActorToolName());
    }

    @Deprecated
    public void createActor(String id) {
        new CreateContainerTool((DiagramContext)this, this.getCreateActorToolName(), this.getDiagramId(), id).run();
    }

    public String createComponent() {
        return this.createContainerElement(this.getDiagramId(), this.getCreateComponentToolName());
    }

    public String createSubComponent(String containerId) {
        return this.createContainerElement(containerId, this.getCreateComponentToolName());
    }

    @Deprecated
    public String createComponent(String containerId, String id) {
        DDiagramElementContainer element = (DDiagramElementContainer)new CreateContainerTool((DiagramContext)this, this.getCreateComponentToolName(), containerId, id).run();
        return ((CapellaElement)element.getTarget()).getId();
    }

    @Deprecated
    public void createComponent(String id) {
        this.createComponent(this.getDiagramId(), id);
    }

    @Deprecated
    public void createEvent(String containerId, String id) {
        new CreateContainerTool((DiagramContext)this, this.getCreateEventToolName(), containerId, id).run();
    }

    @Deprecated
    public void createEvent(String id) {
        this.createEvent(this.getDiagramId(), id);
    }

    public String createEvent() {
        if ("Contextual Component External Interfaces".equals(this.getType()) || "Contextual Component Internal Interfaces".equals(this.getType())) {
            return this.createNodeElement(this.getDiagramId(), this.getCreateEventToolName());
        }
        return this.createContainerElement(this.getDiagramId(), this.getCreateEventToolName());
    }

    public String createOperation() {
        return this.createExchangeItem(ExchangeMechanism.OPERATION);
    }

    public String createFlow() {
        return this.createExchangeItem(ExchangeMechanism.FLOW);
    }

    public String createData() {
        return this.createExchangeItem(ExchangeMechanism.SHARED_DATA);
    }

    public String createExchangeItem(ExchangeMechanism type) {
        if ("Contextual Component External Interfaces".equals(this.getType()) || "Contextual Component Internal Interfaces".equals(this.getType())) {
            return this.createNodeElement(this.getDiagramId(), this.getCreateExchangeItemName(type));
        }
        return this.createContainerElement(this.getDiagramId(), this.getCreateExchangeItemName(type));
    }

    public String createExchangeItemNode(ExchangeMechanism type) {
        return this.createNodeElement(this.getDiagramId(), this.getCreateExchangeItemName(type));
    }

    public String createExchangeItemAllocation(String containerId, ExchangeMechanism type) {
        return this.createNodeListElement(containerId, this.getCreateExchangeItemName(type));
    }

    public String getToolInsertActors() {
        String toolName = null;
        if ("Interfaces Diagram Blank".equals(this.getType())) {
            toolName = "actors";
        } else {
            if ("Contextual Component Detailed Interfaces".equals(this.getType())) {
                throw new UnsupportedOperationException();
            }
            if ("Contextual Component External Interfaces".equals(this.getType())) {
                toolName = "actors";
            } else if ("Contextual Component Internal Interfaces".equals(this.getType())) {
                toolName = "actors";
            }
        }
        return toolName;
    }

    public String getToolInsertComponents() {
        String toolName = null;
        if ("Interfaces Diagram Blank".equals(this.getType())) {
            toolName = "components";
        } else {
            if ("Contextual Component Detailed Interfaces".equals(this.getType())) {
                throw new UnsupportedOperationException();
            }
            if ("Contextual Component External Interfaces".equals(this.getType())) {
                toolName = "components";
            } else if ("Contextual Component Internal Interfaces".equals(this.getType())) {
                toolName = "components";
            }
        }
        return toolName;
    }

    public String getToolInsertRelationship() {
        String toolName = null;
        if (!"Interfaces Diagram Blank".equals(this.getType())) {
            throw new UnsupportedOperationException();
        }
        toolName = "relationships";
        return toolName;
    }

    public void insertActors(String ... id) {
        new InsertRemoveTool((DiagramContext)this, this.getToolInsertActors()).insert(id);
    }

    public void insertSubActors(String containerId, String ... id) {
        new InsertRemoveTool((DiagramContext)this, this.getToolInsertActors(), containerId).insert(id);
    }

    public void insertInterfaces(String ... id) {
        new InsertRemoveTool((DiagramContext)this, "interfaces").insert(id);
    }

    public void removeInterfaces(String ... id) {
        new InsertRemoveTool((DiagramContext)this, "interfaces").remove(id);
    }

    public void insertExchangeItems(String ... id) {
        new InsertRemoveTool((DiagramContext)this, "exchange.items").insert(id);
    }

    public void removeExchangeItems(String ... id) {
        new InsertRemoveTool((DiagramContext)this, "exchange.items").remove(id);
    }

    public void insertRelationships(String containerId, String ... id) {
        new InsertRemoveTool((DiagramContext)this, "relationships", containerId).insert(id);
    }

    public void removeRelationships(String containerId, String ... id) {
        new InsertRemoveTool((DiagramContext)this, "relationships", containerId).remove(id);
    }

    public void insertComponents(String ... id) {
        new InsertRemoveTool((DiagramContext)this, this.getToolInsertComponents()).insert(id);
    }

    public void insertSubComponents(String containerId, String ... id) {
        new InsertRemoveTool((DiagramContext)this, this.getToolInsertComponents(), containerId).insert(id);
    }

    public void removeActors(String ... id) {
        new InsertRemoveTool((DiagramContext)this, this.getToolInsertActors()).remove(id);
    }

    public void removeComponents(String ... id) {
        new InsertRemoveTool((DiagramContext)this, this.getToolInsertComponents()).remove(id);
    }

    public void insertRelationship(String containerId, String ... id) {
        new InsertRemoveTool((DiagramContext)this, this.getToolInsertRelationship(), containerId).insert(id);
    }

    public void removeRelationship(String containerId, String ... id) {
        new InsertRemoveTool((DiagramContext)this, this.getToolInsertRelationship(), containerId).remove(id);
    }

    @Deprecated
    public void createCommunicationLinkAcquire(String idSource, String idTarget, String id) {
        new CreateDEdgeTool(this, this.getCommunicationLinkAcquireToolName(), idSource, idTarget, id).run();
    }

    public String createCommunicationLinkAcquire(String idSource, String idTarget) {
        return this.createEdgeElement(idSource, idTarget, this.getCommunicationLinkAcquireToolName());
    }

    @Deprecated
    public void createCommunicationLinkTransmit(String idSource, String idTarget, String id) {
        new CreateDEdgeTool(this, this.getCommunicationLinkTransmitToolName(), idSource, idTarget, id).run();
    }

    public String createCommunicationLinkTransmit(String idSource, String idTarget) {
        return this.createEdgeElement(idSource, idTarget, this.getCommunicationLinkTransmitToolName());
    }

    public String createInFlowPort(String idContainer, String id) {
        String toolName = null;
        if ("Interfaces Diagram Blank".equals(this.getType())) {
            toolName = "in.flow.port";
        } else if ("Contextual Component Detailed Interfaces".equals(this.getType())) {
            toolName = "in.flow.port";
        } else if ("Contextual Component External Interfaces".equals(this.getType())) {
            toolName = "in.flow.port";
        } else if ("Contextual Component Internal Interfaces".equals(this.getType())) {
            toolName = "in.flow.port";
        }
        DNode element = (DNode)new CreateNodeTool((DiagramContext)this, toolName, idContainer, id).run();
        return ((CapellaElement)element.getTarget()).getId();
    }

    public String createOutFlowPort(String idContainer, String id) {
        String toolName = null;
        if ("Interfaces Diagram Blank".equals(this.getType())) {
            toolName = "out.flow.port";
        } else if ("Contextual Component Detailed Interfaces".equals(this.getType())) {
            toolName = "out.flow.port";
        } else if ("Contextual Component External Interfaces".equals(this.getType())) {
            toolName = "out.flow.port";
        } else if ("Contextual Component Internal Interfaces".equals(this.getType())) {
            toolName = "out.flow.port";
        }
        DNode element = (DNode)new CreateNodeTool((DiagramContext)this, toolName, idContainer, id).run();
        return ((CapellaElement)element.getTarget()).getId();
    }

    public String createInOutFlowPort(String idContainer, String id) {
        String toolName = null;
        if ("Interfaces Diagram Blank".equals(this.getType())) {
            toolName = "in.out.flow.port";
        } else if ("Contextual Component Detailed Interfaces".equals(this.getType())) {
            toolName = "in.out.flow.port";
        } else if ("Contextual Component External Interfaces".equals(this.getType())) {
            toolName = "in.out.flow.port";
        } else if ("Contextual Component Internal Interfaces".equals(this.getType())) {
            toolName = "in.out.flow.port";
        }
        DNode element = (DNode)new CreateNodeTool((DiagramContext)this, toolName, idContainer, id).run();
        return ((CapellaElement)element.getTarget()).getId();
    }

    public String createStandardPort(String containerId, String id) {
        String toolName = null;
        if ("Interfaces Diagram Blank".equals(this.getType())) {
            toolName = "standard.port";
        } else if ("Contextual Component Detailed Interfaces".equals(this.getType())) {
            toolName = "standard.port";
        } else if ("Contextual Component External Interfaces".equals(this.getType())) {
            toolName = "standard.port";
        } else if ("Contextual Component Internal Interfaces".equals(this.getType())) {
            toolName = "standard.port";
        }
        DNode element = (DNode)new CreateNodeTool((DiagramContext)this, toolName, containerId, id).run();
        return ((CapellaElement)element.getTarget()).getId();
    }

    public String createInterface() {
        if ("Contextual Component External Interfaces".equals(this.getType()) || "Contextual Component Internal Interfaces".equals(this.getType())) {
            return this.createNodeElement(this.getDiagramId(), this.getCreateInterfaceToolName());
        }
        return this.createContainerElement(this.getDiagramId(), this.getCreateInterfaceToolName());
    }

    public String createInterfaceInContainer(String containerId) {
        return this.createContainerElement(containerId, this.getCreateInterfaceToolName());
    }

    @Deprecated
    public void createInterface(String id) {
        this.createInterface(this.getDiagramId(), id);
    }

    @Deprecated
    public void createInterface(String containerId, String id) {
        new CreateContainerTool((DiagramContext)this, this.getCreateInterfaceToolName(), containerId, id).run();
    }

    public String createGeneralization(String idSource, String idTarget) {
        return this.createEdgeElement(idSource, idTarget, this.getCreateGeneralizationToolName());
    }

    public void createGeneralization(String idSource, String idTarget, String id) {
        new CreateDEdgeTool(this, this.getCreateGeneralizationToolName(), idSource, idTarget, id).run();
    }

    public void createGeneralizationNotEnabled(String idSource, String idTarget) {
        new CreateDEdgeTool(this, this.getCreateGeneralizationToolName(), idSource, idTarget).cannotRun();
    }

    @Deprecated
    public void createImplements(String idSource, String idTarget, String id) {
        new CreateDEdgeTool(this, this.getCreateImplementsToolName(), idSource, idTarget, id).run();
    }

    public String createImplements(String idSource, String idTarget) {
        return this.createEdgeElement(idSource, idTarget, this.getCreateImplementsToolName());
    }

    public void createImplementsNotEnabled(String idSource, String idTarget) {
        new CreateDEdgeTool(this, this.getCreateImplementsToolName(), idSource, idTarget).cannotRun();
    }

    @Deprecated
    public void createProvides(String idSource, String idTarget, String id, String idNewSource) {
        new CreateDEdgeTool((DiagramContext)this, this.getCreateProvidesToolName(), idSource, idTarget, id, idNewSource, null).run();
    }

    public String createProvides(String idSource, String idTarget) {
        return this.createEdgeElement(idSource, idTarget, this.getCreateProvidesToolName());
    }

    public void createProvidesNotEnabled(String idSource, String idTarget) {
        new CreateDEdgeTool(this, this.getCreateProvidesToolName(), idSource, idTarget).cannotRun();
    }

    public void createRequiresNotEnabled(String idSource, String idTarget) {
        new CreateDEdgeTool(this, this.getCreateRequiresToolName(), idSource, idTarget).cannotRun();
    }

    @Deprecated
    public void createRequires(String idSource, String idTarget, String id, String idNewSource) {
        new CreateDEdgeTool((DiagramContext)this, this.getCreateRequiresToolName(), idSource, idTarget, id, idNewSource, null).run();
    }

    public String createRequires(String idSource, String idTarget) {
        return this.createEdgeElement(idSource, idTarget, this.getCreateRequiresToolName());
    }

    public String createDelegation(String idSource, String idTarget) {
        return this.createEdgeElement(idSource, idTarget, this.getCreateDelegationToolName());
    }

    @Deprecated
    public void createUses(String idSource, String idTarget, String id) {
        new CreateDEdgeTool(this, this.getCreateUsesToolName(), idSource, idTarget, id).run();
    }

    public String createUses(String idSource, String idTarget) {
        return this.createEdgeElement(idSource, idTarget, this.getCreateUsesToolName());
    }

    public void createUsesNotEnabled(String idSource, String idTarget, String id) {
        new CreateDEdgeTool(this, this.getCreateUsesToolName(), idSource, idTarget, id).cannotRun();
    }

    public void dragAndDropComponentFromExplorer(String idDraggedElement, String containerId) {
        this.dragAndDropFromExplorer(idDraggedElement, containerId, "Component from Model");
    }

    public void dragAndDropComponentFromDiagram(String idDraggedElement, String containerId) {
        this.dragAndDrop(idDraggedElement, containerId, "Component from Diagram");
    }

    public void dragAndDropShouldFail(String sourceId, String targetId) {
        try {
            this.dragAndDropComponentFromDiagram(sourceId, targetId);
            Assert.fail((String)("Drag and drop should have failed for diagram: " + String.valueOf(this) + " source " + sourceId + " target " + targetId));
        }
        catch (AssertionError error) {
            Assert.assertTrue((boolean)((Throwable)((Object)error)).getMessage().startsWith("Precondition"));
        }
    }

    public void dragAndDropShouldSucceed(String sourceId, String targetId) {
        this.dragAndDropComponentFromDiagram(sourceId, targetId);
    }

    public void dragAndDropComponentPortFromExplorer(String idDraggedElement, String containerId) {
        this.dragAndDropFromExplorer(idDraggedElement, containerId, "ComponentPort from Model");
    }

    public void dragAndDropComponentPortFromDiagram(String idDraggedElement, String containerId) {
        this.dragAndDrop(idDraggedElement, containerId, "ComponentPort from Diagram");
    }

    public void dragAndDropInterfaceFromExplorer(String idDraggedElement, String containerId) {
        this.dragAndDropFromExplorer(idDraggedElement, containerId, "InterfaceDrop from Model");
    }

    public void dragAndDropInterfaceFromDiagram(String idDraggedElement, String containerId) {
        this.dragAndDrop(idDraggedElement, containerId, "InterfaceDrop from Diagram");
    }

    public void dragAndDropExchangeItemAllocationFromExplorer(String idDraggedElement, String containerId) {
        this.dragAndDropFromExplorer(idDraggedElement, containerId, "Allocation ExchangeItem from Model");
    }

    public void dragAndDropExchangeItemAllocationFromDiagram(String idDraggedElement, String containerId) {
        this.dragAndDrop(idDraggedElement, containerId, "Allocation ExchangeItem from Diagram");
    }

    public void reconnectGeneralizationSource(String edgeId, String oldSourceId, String newSourceId) {
        new ReconnectTool(this, this.getReconnectGeneralizationSourceToolName(), edgeId, oldSourceId, newSourceId).run();
    }

    public void reconnectGeneralizationTarget(String edgeId, String oldTargetId, String newTargetId) {
        new ReconnectTool(this, this.getReconnectGeneralizationTargetToolName(), edgeId, oldTargetId, newTargetId).run();
    }

    public void cannotReconnectGeneralizationSource(String edgeId, String oldSourceId, String newSourceId) {
        new ReconnectTool(this, this.getReconnectGeneralizationSourceToolName(), edgeId, oldSourceId, newSourceId).shouldFail();
    }

    public void cannotReconnectGeneralizationTarget(String edgeId, String oldTargetId, String newTargetId) {
        new ReconnectTool(this, this.getReconnectGeneralizationTargetToolName(), edgeId, oldTargetId, newTargetId).shouldFail();
    }

    public void reconnectCommunicationLinkSource(String edgeId, String oldSourceId, String newSourceId) {
        new ReconnectTool(this, this.getReconnectCommunicationLinkSourceToolName(), edgeId, oldSourceId, newSourceId).run();
    }

    public void reconnectCommunicationLinkTarget(String edgeId, String oldTargetId, String newTargetId) {
        new ReconnectTool(this, this.getReconnectCommunicationLinkTargetToolName(), edgeId, oldTargetId, newTargetId).run();
    }

    public void cannotReconnectCommunicationLinkSource(String edgeId, String oldSourceId, String newSourceId) {
        new ReconnectTool(this, this.getReconnectCommunicationLinkSourceToolName(), edgeId, oldSourceId, newSourceId).shouldFail();
    }

    public void cannotReconnectCommunicationLinkTarget(String edgeId, String oldTargetId, String newTargetId) {
        new ReconnectTool(this, this.getReconnectCommunicationLinkTargetToolName(), edgeId, oldTargetId, newTargetId).shouldFail();
    }

    public void reconnectImplementsTarget(String edgeId, String oldTargetId, String newTargetId) {
        new ReconnectTool(this, this.getReconnectImplementsTargetToolName(), edgeId, oldTargetId, newTargetId).run();
    }

    public void cannotReconnectImplementsTarget(String edgeId, String oldTargetId, String newTargetId) {
        new ReconnectTool(this, this.getReconnectImplementsTargetToolName(), edgeId, oldTargetId, newTargetId).shouldFail();
    }

    public void reconnectUsesTarget(String edgeId, String oldTargetId, String newTargetId) {
        new ReconnectTool(this, this.getReconnectUsesTargetToolName(), edgeId, oldTargetId, newTargetId).run();
    }

    public void cannotReconnectUsesTarget(String edgeId, String oldTargetId, String newTargetId) {
        new ReconnectTool(this, this.getReconnectUsesTargetToolName(), edgeId, oldTargetId, newTargetId).shouldFail();
    }

    public void reconnectProvidesSource(String edgeId, String oldSourceId, String newSourceId) {
        new ReconnectTool(this, this.getReconnectProvidesSourceToolName(), edgeId, oldSourceId, newSourceId).run();
    }

    public void reconnectProvidesTarget(String edgeId, String oldTargetId, String newTargetId) {
        new ReconnectTool(this, this.getReconnectProvidesTargetToolName(), edgeId, oldTargetId, newTargetId).run();
    }

    public void reconnectRequiresSource(String edgeId, String oldSourceId, String newSourceId) {
        new ReconnectTool(this, this.getReconnectRequiresSourceToolName(), edgeId, oldSourceId, newSourceId).run();
    }

    public void reconnectRequiresTarget(String edgeId, String oldTargetId, String newTargetId) {
        new ReconnectTool(this, this.getReconnectRequiresTargetToolName(), edgeId, oldTargetId, newTargetId).run();
    }

    protected String getCreateActorToolName() {
        String toolName = null;
        if ("Interfaces Diagram Blank".equals(this.getType())) {
            toolName = "actor";
        } else {
            if ("Contextual Component Detailed Interfaces".equals(this.getType())) {
                throw new UnsupportedOperationException();
            }
            if ("Contextual Component External Interfaces".equals(this.getType())) {
                toolName = "actor";
            } else if ("Contextual Component Internal Interfaces".equals(this.getType())) {
                throw new UnsupportedOperationException();
            }
        }
        return toolName;
    }

    protected String getCreateComponentToolName() {
        String toolName = null;
        if ("Interfaces Diagram Blank".equals(this.getType())) {
            toolName = "component";
        } else {
            if ("Contextual Component Detailed Interfaces".equals(this.getType())) {
                throw new UnsupportedOperationException();
            }
            if ("Contextual Component External Interfaces".equals(this.getType())) {
                toolName = "component";
            } else if ("Contextual Component Internal Interfaces".equals(this.getType())) {
                toolName = "component";
            }
        }
        return toolName;
    }

    protected String getCreateInterfaceToolName() {
        String toolName = null;
        if ("Interfaces Diagram Blank".equals(this.getType())) {
            toolName = "interface";
        } else if ("Contextual Component Detailed Interfaces".equals(this.getType())) {
            toolName = "interface";
        } else if ("Contextual Component External Interfaces".equals(this.getType())) {
            toolName = "interface";
        } else if ("Contextual Component Internal Interfaces".equals(this.getType())) {
            toolName = "interface";
        }
        return toolName;
    }

    protected String getCreateEventToolName() {
        String toolName = null;
        if ("Interfaces Diagram Blank".equals(this.getType())) {
            toolName = "event";
        } else if ("Contextual Component Detailed Interfaces".equals(this.getType())) {
            toolName = "event";
        } else if ("Contextual Component External Interfaces".equals(this.getType())) {
            toolName = "event";
        } else if ("Contextual Component Internal Interfaces".equals(this.getType())) {
            toolName = "event";
        }
        return toolName;
    }

    protected String getCreateExchangeItemName(ExchangeMechanism eiType) {
        switch (eiType) {
            case EVENT: {
                return "event";
            }
            case OPERATION: {
                return "operation";
            }
            case FLOW: {
                return "flow";
            }
            case SHARED_DATA: {
                return "data";
            }
            case UNSET: {
                return "undefined.exchange.item";
            }
        }
        return null;
    }

    protected String getCommunicationLinkAcquireToolName() {
        String toolName = null;
        if ("Interfaces Diagram Blank".equals(this.getType())) {
            toolName = "acquire";
        } else if ("Contextual Component Detailed Interfaces".equals(this.getType())) {
            toolName = "acquire";
        } else if ("Contextual Component External Interfaces".equals(this.getType())) {
            toolName = "acquire";
        } else if ("Contextual Component Internal Interfaces".equals(this.getType())) {
            toolName = "acquire";
        }
        return toolName;
    }

    protected String getCommunicationLinkTransmitToolName() {
        String toolName = null;
        if ("Interfaces Diagram Blank".equals(this.getType())) {
            toolName = "transmit";
        } else if ("Contextual Component Detailed Interfaces".equals(this.getType())) {
            toolName = "transmit";
        } else if ("Contextual Component External Interfaces".equals(this.getType())) {
            toolName = "transmit";
        } else if ("Contextual Component Internal Interfaces".equals(this.getType())) {
            toolName = "transmit";
        }
        return toolName;
    }

    protected String getCreateImplementsToolName() {
        String toolName = null;
        if ("Interfaces Diagram Blank".equals(this.getType())) {
            toolName = "implements";
        } else if ("Contextual Component Detailed Interfaces".equals(this.getType())) {
            toolName = "implements";
        } else if ("Contextual Component External Interfaces".equals(this.getType())) {
            toolName = "implements";
        } else if ("Contextual Component Internal Interfaces".equals(this.getType())) {
            toolName = "implements";
        }
        return toolName;
    }

    protected String getCreateUsesToolName() {
        String toolName = null;
        if ("Interfaces Diagram Blank".equals(this.getType())) {
            toolName = "uses";
        } else if ("Contextual Component Detailed Interfaces".equals(this.getType())) {
            toolName = "uses";
        } else if ("Contextual Component External Interfaces".equals(this.getType())) {
            toolName = "uses";
        } else if ("Contextual Component Internal Interfaces".equals(this.getType())) {
            toolName = "uses";
        }
        return toolName;
    }

    protected String getCreateProvidesToolName() {
        String toolName = null;
        if ("Interfaces Diagram Blank".equals(this.getType())) {
            toolName = "provides";
        } else if ("Contextual Component Detailed Interfaces".equals(this.getType())) {
            toolName = "provides";
        } else if ("Contextual Component External Interfaces".equals(this.getType())) {
            toolName = "provides";
        } else if ("Contextual Component Internal Interfaces".equals(this.getType())) {
            toolName = "provides";
        }
        return toolName;
    }

    protected String getCreateRequiresToolName() {
        String toolName = null;
        if ("Interfaces Diagram Blank".equals(this.getType())) {
            toolName = "requires";
        } else if ("Contextual Component Detailed Interfaces".equals(this.getType())) {
            toolName = "requires";
        } else if ("Contextual Component External Interfaces".equals(this.getType())) {
            toolName = "requires";
        } else if ("Contextual Component Internal Interfaces".equals(this.getType())) {
            toolName = "requires";
        }
        return toolName;
    }

    protected String getCreateDelegationToolName() {
        String toolName = null;
        if ("Interfaces Diagram Blank".equals(this.getType())) {
            toolName = "delegation";
        } else {
            if ("Contextual Component Detailed Interfaces".equals(this.getType())) {
                throw new UnsupportedOperationException();
            }
            if ("Contextual Component External Interfaces".equals(this.getType())) {
                throw new UnsupportedOperationException();
            }
            if ("Contextual Component Internal Interfaces".equals(this.getType())) {
                toolName = "delegation";
            }
        }
        return toolName;
    }

    protected String getCreateGeneralizationToolName() {
        String toolName = null;
        if ("Interfaces Diagram Blank".equals(this.getType())) {
            toolName = "generalization";
        } else if ("Contextual Component Detailed Interfaces".equals(this.getType())) {
            toolName = "generalization";
        } else if ("Contextual Component External Interfaces".equals(this.getType())) {
            toolName = "generalization";
        } else if ("Contextual Component Internal Interfaces".equals(this.getType())) {
            toolName = "generalization";
        }
        return toolName;
    }

    protected String getReconnectGeneralizationSourceToolName() {
        String toolName = null;
        if ("Interfaces Diagram Blank".equals(this.getType())) {
            toolName = "CB Reconnect Generalization Source";
        } else {
            if ("Contextual Component Detailed Interfaces".equals(this.getType())) {
                throw new UnsupportedOperationException();
            }
            if ("Contextual Component External Interfaces".equals(this.getType())) {
                toolName = "actor";
            } else if ("Contextual Component Internal Interfaces".equals(this.getType())) {
                throw new UnsupportedOperationException();
            }
        }
        return toolName;
    }

    protected String getReconnectGeneralizationTargetToolName() {
        String toolName = null;
        if ("Interfaces Diagram Blank".equals(this.getType())) {
            toolName = "CB Reconnect Generalization Target";
        } else {
            if ("Contextual Component Detailed Interfaces".equals(this.getType())) {
                throw new UnsupportedOperationException();
            }
            if ("Contextual Component External Interfaces".equals(this.getType())) {
                toolName = "actor";
            } else if ("Contextual Component Internal Interfaces".equals(this.getType())) {
                throw new UnsupportedOperationException();
            }
        }
        return toolName;
    }

    protected String getReconnectCommunicationLinkSourceToolName() {
        String toolName = null;
        if ("Interfaces Diagram Blank".equals(this.getType())) {
            toolName = "CommunicationLink source";
        } else {
            if ("Contextual Component Detailed Interfaces".equals(this.getType())) {
                throw new UnsupportedOperationException();
            }
            if ("Contextual Component External Interfaces".equals(this.getType())) {
                toolName = "actor";
            } else if ("Contextual Component Internal Interfaces".equals(this.getType())) {
                throw new UnsupportedOperationException();
            }
        }
        return toolName;
    }

    protected String getReconnectCommunicationLinkTargetToolName() {
        String toolName = null;
        if ("Interfaces Diagram Blank".equals(this.getType())) {
            toolName = "CommunicationLink target";
        } else {
            if ("Contextual Component Detailed Interfaces".equals(this.getType())) {
                throw new UnsupportedOperationException();
            }
            if ("Contextual Component External Interfaces".equals(this.getType())) {
                toolName = "actor";
            } else if ("Contextual Component Internal Interfaces".equals(this.getType())) {
                throw new UnsupportedOperationException();
            }
        }
        return toolName;
    }

    protected String getReconnectImplementsTargetToolName() {
        String toolName = null;
        if ("Interfaces Diagram Blank".equals(this.getType())) {
            toolName = "implements target";
        } else {
            if ("Contextual Component Detailed Interfaces".equals(this.getType())) {
                throw new UnsupportedOperationException();
            }
            if ("Contextual Component External Interfaces".equals(this.getType())) {
                toolName = "actor";
            } else if ("Contextual Component Internal Interfaces".equals(this.getType())) {
                throw new UnsupportedOperationException();
            }
        }
        return toolName;
    }

    protected String getReconnectUsesTargetToolName() {
        String toolName = null;
        if ("Interfaces Diagram Blank".equals(this.getType())) {
            toolName = "uses target";
        } else {
            if ("Contextual Component Detailed Interfaces".equals(this.getType())) {
                throw new UnsupportedOperationException();
            }
            if ("Contextual Component External Interfaces".equals(this.getType())) {
                toolName = "actor";
            } else if ("Contextual Component Internal Interfaces".equals(this.getType())) {
                throw new UnsupportedOperationException();
            }
        }
        return toolName;
    }

    protected String getReconnectProvidesSourceToolName() {
        String toolName = null;
        if ("Interfaces Diagram Blank".equals(this.getType())) {
            toolName = "implements-pinprovided source";
        } else {
            if ("Contextual Component Detailed Interfaces".equals(this.getType())) {
                throw new UnsupportedOperationException();
            }
            if ("Contextual Component External Interfaces".equals(this.getType())) {
                toolName = "actor";
            } else if ("Contextual Component Internal Interfaces".equals(this.getType())) {
                throw new UnsupportedOperationException();
            }
        }
        return toolName;
    }

    protected String getReconnectProvidesTargetToolName() {
        String toolName = null;
        if ("Interfaces Diagram Blank".equals(this.getType())) {
            toolName = "PinProvidedInterface target";
        } else {
            if ("Contextual Component Detailed Interfaces".equals(this.getType())) {
                throw new UnsupportedOperationException();
            }
            if ("Contextual Component External Interfaces".equals(this.getType())) {
                toolName = "actor";
            } else if ("Contextual Component Internal Interfaces".equals(this.getType())) {
                throw new UnsupportedOperationException();
            }
        }
        return toolName;
    }

    protected String getReconnectRequiresSourceToolName() {
        String toolName = null;
        if ("Interfaces Diagram Blank".equals(this.getType())) {
            toolName = "used-pinrequired source";
        } else {
            if ("Contextual Component Detailed Interfaces".equals(this.getType())) {
                throw new UnsupportedOperationException();
            }
            if ("Contextual Component External Interfaces".equals(this.getType())) {
                toolName = "actor";
            } else if ("Contextual Component Internal Interfaces".equals(this.getType())) {
                throw new UnsupportedOperationException();
            }
        }
        return toolName;
    }

    protected String getReconnectRequiresTargetToolName() {
        String toolName = null;
        if ("Interfaces Diagram Blank".equals(this.getType())) {
            toolName = "PinRequiredInterface target";
        } else {
            if ("Contextual Component Detailed Interfaces".equals(this.getType())) {
                throw new UnsupportedOperationException();
            }
            if ("Contextual Component External Interfaces".equals(this.getType())) {
                toolName = "actor";
            } else if ("Contextual Component Internal Interfaces".equals(this.getType())) {
                throw new UnsupportedOperationException();
            }
        }
        return toolName;
    }
}

