/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.common.ju.context;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DNodeListElement;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.junit.Assert;
import org.polarsys.capella.core.data.cs.ExchangeItemAllocation;
import org.polarsys.capella.core.data.cs.Interface;
import org.polarsys.capella.core.data.information.ExchangeItem;
import org.polarsys.capella.core.data.information.ExchangeMechanism;
import org.polarsys.capella.test.diagram.common.ju.context.CommonDiagram;
import org.polarsys.capella.test.diagram.common.ju.context.DiagramContext;
import org.polarsys.capella.test.diagram.common.ju.step.crud.CreateDiagramStep;
import org.polarsys.capella.test.diagram.common.ju.step.crud.OpenDiagramStep;
import org.polarsys.capella.test.diagram.common.ju.step.tools.CreateAbstractDNodeWithSelectionTool;
import org.polarsys.capella.test.diagram.common.ju.step.tools.DragAndDropTool;
import org.polarsys.capella.test.diagram.common.ju.wrapper.utils.ArgumentType;
import org.polarsys.capella.test.framework.context.SessionContext;

public class IDDiagram
extends CommonDiagram {
    public IDDiagram(SessionContext context, DDiagram diagram) {
        super(context, diagram);
    }

    public static IDDiagram createDiagram(SessionContext executionContext, String diagramKind, String targetIdentifier) {
        if (!"Interface Diagram".equals(diagramKind)) {
            throw new RuntimeException("this diagram is not compatible with IDDiagram API");
        }
        return (IDDiagram)((DiagramContext)new CreateDiagramStep(executionContext, targetIdentifier, diagramKind){

            @Override
            public DiagramContext getResult() {
                return new IDDiagram(this.getExecutionContext(), this.diagram);
            }
        }.run()).open();
    }

    public static IDDiagram createDiagram(SessionContext executionContext, String targetIdentifier) {
        return IDDiagram.createDiagram(executionContext, "Interface Diagram", targetIdentifier);
    }

    public static IDDiagram openDiagram(SessionContext executionContext, String name) {
        return (IDDiagram)((DiagramContext)new OpenDiagramStep(executionContext, name){

            @Override
            public DiagramContext getResult() {
                return new IDDiagram(this.getExecutionContext(), this.diagram);
            }
        }.run()).open();
    }

    public String createExchangeItem(String containerId, ExchangeMechanism eiType) {
        return this.createNodeListElement(containerId, this.getExchangeItemName(eiType));
    }

    public void createExchangeItemElement(String exchangeItemId, String dataTypeId) {
        new CreateExchangeItemElementTool(this, "exchange.item.element", exchangeItemId, exchangeItemId, dataTypeId, 0).run();
    }

    public void createExchangeItemElement(String exchangeItemId, String dataTypeId, Integer numExistingAllocations) {
        new CreateExchangeItemElementTool(this, "exchange.item.element", exchangeItemId, exchangeItemId, dataTypeId, numExistingAllocations).run();
    }

    public void dragAndDropExchangeItem(String interfaceId, String exchangeItemId) {
        new DragAndDropExchangeItemTool(this, "Allocation ExchangeItem from Model", exchangeItemId, interfaceId).run();
    }

    private String getExchangeItemName(ExchangeMechanism eiType) {
        switch (eiType) {
            case EVENT: {
                return "event";
            }
            case OPERATION: {
                return "operation";
            }
            case FLOW: {
                return "flow";
            }
            case SHARED_DATA: {
                return "data";
            }
            case UNSET: {
                return "undefined.exchange.item";
            }
        }
        return null;
    }

    protected class CreateExchangeItemElementTool
    extends CreateAbstractDNodeWithSelectionTool<DNodeListElement> {
        protected List<ExchangeItemAllocation> ownedExchngeItemAllocations;
        protected ExchangeItemAllocation allocation;
        protected ExchangeItem exchangeItem;
        protected Integer numExistingAllocations;

        public CreateExchangeItemElementTool(DiagramContext context, String toolName, String targetContainerId, String containerId, String selectedId, Integer numExistingAllocations) {
            super(context, toolName, targetContainerId, containerId, selectedId, null, null);
            this.numExistingAllocations = numExistingAllocations;
        }

        @Override
        protected void preRunTest() {
            super.preRunTest();
            DSemanticDecorator element = this.getContainerView();
            Assert.assertTrue((boolean)(element.getTarget() instanceof ExchangeItemAllocation));
            this.allocation = (ExchangeItemAllocation)element.getTarget();
            this.exchangeItem = this.allocation.getAllocatedItem();
            this.ownedExchngeItemAllocations = new ArrayList<ExchangeItemAllocation>();
            this.ownedExchngeItemAllocations.addAll((Collection<ExchangeItemAllocation>)this.exchangeItem.getOwnedElements());
            Assert.assertTrue((this.ownedExchngeItemAllocations.size() == this.numExistingAllocations.intValue() ? 1 : 0) != 0);
        }

        @Override
        protected void postRunTest() {
            ArrayList newOwnedParameters = new ArrayList();
            newOwnedParameters.addAll(this.exchangeItem.getOwnedElements());
            Assert.assertTrue((newOwnedParameters.size() == this.numExistingAllocations + 1 ? 1 : 0) != 0);
            newOwnedParameters.removeAll(this.ownedExchngeItemAllocations);
            Assert.assertTrue((newOwnedParameters.size() == 1 ? 1 : 0) != 0);
        }

        @Override
        public DNodeListElement getResult() {
            return null;
        }
    }

    protected class DragAndDropExchangeItemTool
    extends DragAndDropTool {
        Interface interf;
        ArrayList<ExchangeItemAllocation> ownedEIAllocations;

        public DragAndDropExchangeItemTool(DiagramContext context, String toolName, String elementView, String containerView) {
            super(context, toolName, elementView, containerView);
        }

        @Override
        protected void initToolArguments() {
            EObject droppedElement = this.getDiagramContext().getSessionContext().getSemanticElement(this.elementView);
            DSemanticDecorator element = this.getDiagramContext().getView(this.containerView);
            this._toolWrapper.setArgumentValue(ArgumentType.CONTAINER_VIEW, element);
            this._toolWrapper.setArgumentValue(ArgumentType.DROPPEDELEMENT, droppedElement);
        }

        @Override
        protected void preRunTest() {
            super.preRunTest();
            DSemanticDecorator element = this.getDiagramContext().getView(this.containerView);
            Assert.assertTrue((boolean)(element.getTarget() instanceof Interface));
            this.interf = (Interface)element.getTarget();
            this.ownedEIAllocations = new ArrayList();
            this.ownedEIAllocations.addAll((Collection<ExchangeItemAllocation>)this.interf.getOwnedExchangeItemAllocations());
        }

        @Override
        protected void postRunTest() {
            ArrayList insertedEIAllocations = new ArrayList();
            insertedEIAllocations.addAll(this.interf.getOwnedExchangeItemAllocations());
            insertedEIAllocations.removeAll(this.ownedEIAllocations);
            Assert.assertTrue((insertedEIAllocations.size() == 1 ? 1 : 0) != 0);
        }

        @Override
        public DDiagramElement getResult() {
            return null;
        }
    }
}

