/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.common.ju.context;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.diagram.DDiagram;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.interaction.MessageKind;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.test.diagram.common.ju.context.DiagramContext;
import org.polarsys.capella.test.diagram.common.ju.context.SequenceDiagram;
import org.polarsys.capella.test.diagram.common.ju.step.crud.CreateDiagramStep;
import org.polarsys.capella.test.diagram.common.ju.step.crud.OpenDiagramStep;
import org.polarsys.capella.test.diagram.common.ju.step.tools.sequence.MessageCreationTool;
import org.polarsys.capella.test.framework.context.SessionContext;

public class ISDiagram
extends SequenceDiagram {
    public ISDiagram(BlockArchitectureExt.Type type, SessionContext context, DDiagram diagram) {
        super(type, context, diagram);
    }

    public static ISDiagram createDiagram(SessionContext executionContext, String targetIdentifier) {
        BlockArchitecture architecture = BlockArchitectureExt.getRootBlockArchitecture((EObject)executionContext.getSemanticElement(targetIdentifier));
        final BlockArchitectureExt.Type type = BlockArchitectureExt.getBlockArchitectureType((BlockArchitecture)architecture);
        if (type == BlockArchitectureExt.Type.OA) {
            throw new UnsupportedOperationException();
        }
        String name = "Component Interfaces Scenario";
        return (ISDiagram)((DiagramContext)new CreateDiagramStep(executionContext, targetIdentifier, name){

            @Override
            public DiagramContext getResult() {
                return new ISDiagram(type, this.getExecutionContext(), this.diagram);
            }
        }.run()).open();
    }

    public static ISDiagram openDiagram(SessionContext executionContext, String name, final BlockArchitectureExt.Type type) {
        return (ISDiagram)((DiagramContext)new OpenDiagramStep(executionContext, name){

            @Override
            public DiagramContext getResult() {
                return new ISDiagram(type, this.getExecutionContext(), this.diagram);
            }
        }.run()).open();
    }

    public void createMessage(String id, String source, String target) {
        new MessageCreationTool((DiagramContext)this, "create.message", id, source, target, MessageKind.CREATE).run();
    }

    public void deleteMessage(String id, String source, String target) {
        new MessageCreationTool((DiagramContext)this, "delete.message", id, source, target, MessageKind.DELETE).run();
    }

    public void createSequenceMessage(String id, String source, String target) {
        new MessageCreationTool((DiagramContext)this, "sequence.message", id, source, target).run();
    }

    public void createSequenceMessageWithReturnBranch(String id, String source, String target) {
        new MessageCreationTool((DiagramContext)this, "sequence.message.with.return.branch", id, source, target, true).run();
    }

    @Override
    public void createFunctionalExchange(String functionalExchange, String source, String target) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void createFunctionalExchangeWithReturnBranch(String functionalExchange, String source, String target) {
        throw new UnsupportedOperationException();
    }
}

