/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.common.ju.context;

import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.sirius.diagram.DDiagram;
import org.junit.Assert;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.core.data.oa.OperationalActivity;
import org.polarsys.capella.core.data.oa.Role;
import org.polarsys.capella.test.diagram.common.ju.context.CommonDiagram;
import org.polarsys.capella.test.diagram.common.ju.context.DiagramContext;
import org.polarsys.capella.test.diagram.common.ju.step.crud.CreateDiagramStep;
import org.polarsys.capella.test.diagram.common.ju.step.crud.OpenDiagramStep;
import org.polarsys.capella.test.framework.context.SessionContext;

public class ORBDiagram
extends CommonDiagram {
    public ORBDiagram(SessionContext context, DDiagram diagram) {
        super(context, diagram);
    }

    public static ORBDiagram createDiagram(SessionContext executionContext, String targetIdentifier) {
        String name = "Operational Role Blank";
        return (ORBDiagram)((DiagramContext)new CreateDiagramStep(executionContext, targetIdentifier, name){

            @Override
            public DiagramContext getResult() {
                return new ORBDiagram(this.getExecutionContext(), this.diagram);
            }
        }.run()).open();
    }

    public static ORBDiagram openDiagram(SessionContext executionContext, String name) {
        return (ORBDiagram)((DiagramContext)new OpenDiagramStep(executionContext, name){

            @Override
            public DiagramContext getResult() {
                return new ORBDiagram(this.getExecutionContext(), this.diagram);
            }
        }.run()).open();
    }

    public String createOperationalRole(String containerId) {
        return this.createContainerElement(containerId, "operational.role");
    }

    public String createOperationalActivity(String containerId) {
        String createdOpActivityId = this.createNodeElement(containerId, "operational.activity");
        Role parentOpRole = (Role)this.getSessionContext().getSemanticElement(containerId);
        OperationalActivity semanticOperationalActivity = (OperationalActivity)this.getSessionContext().getSemanticElement(createdOpActivityId);
        if (!parentOpRole.getAllocatedOperationalActivities().contains((Object)semanticOperationalActivity)) {
            Assert.fail((String)("Activity with ID: " + createdOpActivityId + " should be allocated to Role with ID: " + containerId));
        }
        return createdOpActivityId;
    }

    public String createInteraction(String sourceId, String targetId) {
        return this.createEdgeElement(sourceId, targetId, "interaction", 1);
    }

    public void insertOperationalRoles(String containerId, String ... elementsToInsertIds) {
        this.insertElements(containerId, "operational.roles", elementsToInsertIds);
    }

    public void removeOperationalRoles(String containerId, String ... elementsToRemoveIds) {
        this.removeElements(containerId, "operational.roles", elementsToRemoveIds);
    }

    public void insertInteractions(String targetOperationalActivityId, String ... elementsToInsertIds) {
        this.insertElements(targetOperationalActivityId, "interactions", elementsToInsertIds);
    }

    public void removeInteractions(String targetOperationalActivityId, String ... elementsToRemoveIds) {
        this.removeElements(targetOperationalActivityId, "interactions", elementsToRemoveIds);
    }

    public void insertAllocatedActivities(String targetOperationalRoleId, String ... elementsToInsertIds) {
        this.insertElements(targetOperationalRoleId, "allocated.activities", elementsToInsertIds);
    }

    public void removeAllocatedActivities(String targetOperationalRoleId, String ... elementsToRemoveIds) {
        this.removeElements(targetOperationalRoleId, "allocated.activities", elementsToRemoveIds);
    }

    public void insertAllAllocatedActivities(String targetOperationalRoleId) {
        Role opRole = (Role)this.getSessionContext().getSemanticElement(targetOperationalRoleId);
        List<String> allocatedActivitiesIDs = opRole.getAllocatedOperationalActivities().stream().map(ModelElement::getId).collect(Collectors.toList());
        this.insertElements(targetOperationalRoleId, "all.allocated.activities", allocatedActivitiesIDs.toArray(new String[0]));
    }

    public void manageActivityAllocation(String targetOperationalRoleId, String[] activitiesToAllocate, String[] activitiesToDeallocate) {
        int n;
        int n2;
        String[] stringArray;
        List allocatedActivitiesIds;
        Role opRole;
        if (activitiesToAllocate != null && activitiesToAllocate.length != 0) {
            this.insertElements(targetOperationalRoleId, "manage.activity.allocation", activitiesToAllocate);
            opRole = (Role)this.getSessionContext().getSemanticElement(targetOperationalRoleId);
            allocatedActivitiesIds = opRole.getAllocatedOperationalActivities().stream().map(ModelElement::getId).collect(Collectors.toList());
            stringArray = activitiesToAllocate;
            n2 = activitiesToAllocate.length;
            n = 0;
            while (n < n2) {
                String allocatedActivityId = stringArray[n];
                if (!allocatedActivitiesIds.contains(allocatedActivityId)) {
                    Assert.fail((String)("Activity with ID: " + allocatedActivityId + " should be allocated to target Role with ID " + targetOperationalRoleId));
                }
                ++n;
            }
        }
        if (activitiesToDeallocate != null && activitiesToDeallocate.length != 0) {
            this.removeElements(targetOperationalRoleId, "manage.activity.allocation", activitiesToDeallocate);
            opRole = (Role)this.getSessionContext().getSemanticElement(targetOperationalRoleId);
            allocatedActivitiesIds = opRole.getAllocatedOperationalActivities().stream().map(ModelElement::getId).collect(Collectors.toList());
            stringArray = activitiesToDeallocate;
            n2 = activitiesToDeallocate.length;
            n = 0;
            while (n < n2) {
                String deallocatedActivityId = stringArray[n];
                if (allocatedActivitiesIds.contains(deallocatedActivityId)) {
                    Assert.fail((String)("Activity with ID: " + deallocatedActivityId + " should not be allocated to target Role with ID " + targetOperationalRoleId));
                }
                ++n;
            }
        }
    }

    public void dragAndDropChangeAllocation(String idDraggedElement, String containerId) {
        this.dragAndDrop(idDraggedElement, containerId, "change allocation");
    }

    public void dragAndDropOperationalActivitiesFromExplorer(String idDraggedElement, String containerId) {
        this.dragAndDropFromExplorer(idDraggedElement, containerId, "D&D OperationalActivities From Project Explorer");
    }

    public void dragAndDropRoleFromExplorer(String idDraggedElement, String containerId) {
        this.dragAndDropFromExplorer(idDraggedElement, containerId, "D&D Role From Project Explorer");
    }
}

