/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.common.ju.context;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.DiagramPackage;
import org.junit.Assert;
import org.polarsys.capella.common.ef.ExecutionManager;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.core.data.capellacore.AbstractDependenciesPkg;
import org.polarsys.capella.core.model.helpers.AbstractDependenciesPkgExt;
import org.polarsys.capella.core.sirius.analysis.DiagramServices;
import org.polarsys.capella.core.sirius.analysis.InformationServices;
import org.polarsys.capella.test.diagram.common.ju.context.CommonDiagram;
import org.polarsys.capella.test.diagram.common.ju.context.DiagramContext;
import org.polarsys.capella.test.diagram.common.ju.step.crud.CreateDiagramStep;
import org.polarsys.capella.test.diagram.common.ju.step.crud.OpenDiagramStep;
import org.polarsys.capella.test.diagram.common.ju.wrapper.utils.DiagramHelper;
import org.polarsys.capella.test.framework.context.SessionContext;

public class PDDiagram
extends CommonDiagram {
    public PDDiagram(SessionContext context, DDiagram diagram) {
        super(context, diagram);
    }

    public static PDDiagram createDiagram(SessionContext executionContext, String targetIdentifier) {
        String name = "Package Dependencies";
        return (PDDiagram)((DiagramContext)new CreateDiagramStep(executionContext, targetIdentifier, name){

            @Override
            public DiagramContext getResult() {
                return new PDDiagram(this.getExecutionContext(), this.diagram);
            }
        }.run()).open();
    }

    public static PDDiagram openDiagram(SessionContext executionContext, String name) {
        return (PDDiagram)((DiagramContext)new OpenDiagramStep(executionContext, name){

            @Override
            public DiagramContext getResult() {
                return new PDDiagram(this.getExecutionContext(), this.diagram);
            }
        }.run()).open();
    }

    public void insertDataPackages(String parentContainerId, String ... elementsToBeInsertedIds) {
        this.insertElements(parentContainerId, "data.packages", elementsToBeInsertedIds);
    }

    public void removeDataPackages(String parentContainerId, String ... elementsToBeRemovedIds) {
        this.removeElements(parentContainerId, "data.packages", elementsToBeRemovedIds);
    }

    public void insertInterfacePackages(String parentContainerId, String ... elementsToBeInsertedIds) {
        this.insertElements(parentContainerId, "interface.packages", elementsToBeInsertedIds);
    }

    public void removeInterfacePackages(String parentContainerId, String ... elementsToBeRemovedIds) {
        this.removeElements(parentContainerId, "interface.packages", elementsToBeRemovedIds);
    }

    public void dragAndDropInterfacePackage(String containerId, String elementId) {
        this.dragAndDropFromExplorer(elementId, containerId, "Allocate InterfacePkg from Model");
    }

    private List<AbstractDependenciesPkg> getAllDependenciesOfPackage(String packageID) {
        AbstractDependenciesPkg semanticPackage = (AbstractDependenciesPkg)this.getSessionContext().getSemanticElement(packageID);
        Collection deps = AbstractDependenciesPkgExt.getDependencies((AbstractDependenciesPkg)semanticPackage);
        Collection inverseDeps = AbstractDependenciesPkgExt.getInverseDependencies((AbstractDependenciesPkg)semanticPackage);
        ArrayList<AbstractDependenciesPkg> allDependencies = new ArrayList<AbstractDependenciesPkg>(deps);
        allDependencies.addAll(inverseDeps);
        return allDependencies;
    }

    private List<AbstractDependenciesPkg> getAlreadyInsertedPackages(List<AbstractDependenciesPkg> packageList) {
        ArrayList<AbstractDependenciesPkg> alreadyInsertedPackages = new ArrayList<AbstractDependenciesPkg>();
        for (AbstractDependenciesPkg pkg : packageList) {
            if (DiagramServices.getDiagramServices().getDiagramElement(this.getDiagram(), (EObject)pkg) == null) continue;
            alreadyInsertedPackages.add(pkg);
        }
        return alreadyInsertedPackages;
    }

    private void executeInsertRemoveCommandOnDependencies(List<AbstractDependenciesPkg> sameResourceSetPackages, final List<AbstractDependenciesPkg> packagesToBeDisplayed, final List<AbstractDependenciesPkg> allDependenciesOfAPackage) {
        AbstractReadWriteCommand insertRemoveCommand = new AbstractReadWriteCommand(){

            public void run() {
                InformationServices.getService().showHidePDDependentPkgs((EObject)PDDiagram.this.getDiagram(), packagesToBeDisplayed, allDependenciesOfAPackage);
            }
        };
        ExecutionManager manager = TransactionHelper.getExecutionManager(sameResourceSetPackages);
        manager.execute((ICommand)insertRemoveCommand);
    }

    public void insertDependencies(String parentContainerId, String ... elementsToBeInsertedIds) {
        List<AbstractDependenciesPkg> dependencyPackagesToInsert = Arrays.asList(elementsToBeInsertedIds).stream().map(id -> this.getSessionContext().getSemanticElement(id)).map(AbstractDependenciesPkg.class::cast).collect(Collectors.toList());
        List<AbstractDependenciesPkg> allDependencies = this.getAllDependenciesOfPackage(parentContainerId);
        List<AbstractDependenciesPkg> dependenciesToBeDisplayed = this.getAlreadyInsertedPackages(allDependencies);
        dependenciesToBeDisplayed.addAll(dependencyPackagesToInsert);
        this.executeInsertRemoveCommandOnDependencies(dependencyPackagesToInsert, dependenciesToBeDisplayed, allDependencies);
        DiagramHelper.refreshDiagram(this.getDiagram());
        for (AbstractDependenciesPkg pkg : dependencyPackagesToInsert) {
            this.hasView(pkg.getId());
        }
    }

    public void removeDependencies(String parentContainerId, String ... elementsToBeRemovedIds) {
        List<AbstractDependenciesPkg> dependencyPackagesToRemove = Arrays.asList(elementsToBeRemovedIds).stream().map(id -> this.getSessionContext().getSemanticElement(id)).map(AbstractDependenciesPkg.class::cast).collect(Collectors.toList());
        List<AbstractDependenciesPkg> allDependencies = this.getAllDependenciesOfPackage(parentContainerId);
        List<AbstractDependenciesPkg> dependenciesToBeDisplayed = this.getAlreadyInsertedPackages(allDependencies);
        dependenciesToBeDisplayed.removeAll(dependencyPackagesToRemove);
        this.executeInsertRemoveCommandOnDependencies(dependencyPackagesToRemove, dependenciesToBeDisplayed, allDependencies);
        DiagramHelper.refreshDiagram(this.getDiagram());
        for (AbstractDependenciesPkg pkg : dependencyPackagesToRemove) {
            this.hasntView(pkg.getId());
        }
    }

    public void checkIfDependencyIsCorrect(AbstractDependenciesPkg subPkg, AbstractDependenciesPkg superPkg) {
        DDiagramElement dependencyEdge = DiagramHelper.getDDiagramElementByEClass(this.getDiagram(), (EObject)subPkg, DiagramPackage.Literals.DEDGE);
        DDiagramElement superPkgView = this.getView((EObject)superPkg);
        Assert.assertTrue((String)("Target Dependency for subPackage " + subPkg.getName() + " is not " + superPkg.getName()), (superPkgView == ((DEdge)dependencyEdge).getTargetNode() ? 1 : 0) != 0);
    }
}

