/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.common.ju.context;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DNodeContainer;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.junit.Assert;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.information.InformationPackage;
import org.polarsys.capella.core.data.interaction.CombinedFragment;
import org.polarsys.capella.core.data.interaction.InstanceRole;
import org.polarsys.capella.core.data.interaction.InteractionOperand;
import org.polarsys.capella.core.data.interaction.InteractionOperatorKind;
import org.polarsys.capella.core.data.interaction.InteractionPackage;
import org.polarsys.capella.core.data.interaction.InteractionUse;
import org.polarsys.capella.core.data.interaction.Scenario;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.test.diagram.common.ju.context.CommonDiagram;
import org.polarsys.capella.test.diagram.common.ju.context.DiagramContext;
import org.polarsys.capella.test.diagram.common.ju.step.tools.AbstractToolStep;
import org.polarsys.capella.test.diagram.common.ju.step.tools.CreateAbstractDNodeTool;
import org.polarsys.capella.test.diagram.common.ju.step.tools.CreateAbstractDNodeWithSelectionTool;
import org.polarsys.capella.test.diagram.common.ju.step.tools.CreateDEdgeTool;
import org.polarsys.capella.test.diagram.common.ju.step.tools.InsertRemoveTool;
import org.polarsys.capella.test.diagram.common.ju.step.tools.ReconnectTool;
import org.polarsys.capella.test.diagram.common.ju.step.tools.sequence.CombinedFragmentCreationTool;
import org.polarsys.capella.test.diagram.common.ju.step.tools.sequence.MessageCreationTool;
import org.polarsys.capella.test.diagram.common.ju.step.tools.sequence.TimerCreationTool;
import org.polarsys.capella.test.framework.context.SessionContext;

public class SequenceDiagram
extends CommonDiagram {
    BlockArchitectureExt.Type type = null;

    public SequenceDiagram(SessionContext context, DDiagram diagram) {
        super(context, diagram);
    }

    public SequenceDiagram(BlockArchitectureExt.Type type, SessionContext context, DDiagram diagram) {
        super(context, diagram);
        this.type = type;
    }

    public String createActor() {
        return this.createNodeElement(this.getDiagramId(), "actor");
    }

    public void insertActor(String id) {
        new InsertRemoveInstanceRoleTool((DiagramContext)this, "actors").insert(id);
    }

    public void insertActors(String[] ids) {
        new InsertRemoveInstanceRoleTool((DiagramContext)this, "actors").insert(ids);
    }

    public void removeActor(String id) {
        new InsertRemoveInstanceRoleTool((DiagramContext)this, "actors").remove(id);
    }

    public void removeActors(String[] ids) {
        new InsertRemoveInstanceRoleTool((DiagramContext)this, "actors").remove(ids);
    }

    public String insertState(String containerId, String id) {
        new InsertRemoveStateFragmentStateTool((DiagramContext)this, "state.mode", containerId).insert(id);
        return id;
    }

    public String insertAllocatedFunction(String containerId, String id) {
        new InsertRemoveStateFragmentAbstractFunctionTool((DiagramContext)this, "allocated.function", containerId).insert(id);
        return id;
    }

    public void createFunctionalExchange(String functionalExchange, String source, String target) {
        new MessageCreationTool((DiagramContext)this, "functional.exchange", functionalExchange, source, target).run();
    }

    public void createFunctionalExchangeWithReturnBranch(String functionalExchange, String source, String target) {
        new MessageCreationTool((DiagramContext)this, "functional.exchange.with.return.branch", functionalExchange, source, target, true).run();
    }

    public void createArmTimer(String source, String target) {
        String name = "arm.timer";
        new TimerCreationTool(this, name, source, target).run();
    }

    public void cancelArmTimer(String source, String target) {
        String name = "cancel.timer";
        new TimerCreationTool(this, name, source, target).run();
    }

    public void addMultipleLifeLinesForExistingComponent(String id) {
        String name = "add.multiple.lifelines.for.an.existing.component";
        new InsertRemovePartTool((DiagramContext)this, name).insert(id);
    }

    public void dragAndDropComponentFromExplorer(String idDraggedElement, String containerId) {
        this.dragAndDropFromExplorer(idDraggedElement, containerId, "Drop Component");
    }

    public String createCombinedFragment(InteractionOperatorKind operatorKind, String containerId) {
        String name = "";
        boolean selectOperand = false;
        switch (operatorKind) {
            case ALT: {
                name = "alt";
                break;
            }
            case LOOP: {
                name = "loop";
                break;
            }
            case PAR: {
                name = "par";
                break;
            }
            default: {
                name = "other.combined.fragment";
                selectOperand = true;
            }
        }
        DNodeContainer container = (DNodeContainer)new CombinedFragmentCreationTool((DiagramContext)this, name, this.getDiagramId(), containerId, operatorKind, selectOperand).run();
        return ((CombinedFragment)container.getTarget()).getId();
    }

    public void ceateReference(String selectedScenarioid, String containerId) {
        new ReferenceCreationTool(this, "reference", this.getDiagramId(), containerId, selectedScenarioid).run();
    }

    public void ceateDuration(String sourceId, String targetId) {
        new CreateDEdgeTool(this, "duration", sourceId, targetId);
    }

    public void createOperand(String containerId) {
        new OperandCreationTool(this, "operand", containerId).run();
    }

    public void insertExchangeContext(String id) {
        new InsertRemoveTool((DiagramContext)this, "exchange.context").insert(id);
    }

    public List<Part> getContainedParts(String scenarioId) {
        ArrayList<Part> result = new ArrayList<Part>();
        EObject obj = this.getSessionContext().getSemanticElement(scenarioId);
        if (obj instanceof Scenario) {
            result.addAll((Collection<Part>)((Scenario)obj).getContainedParts());
        }
        return result;
    }

    @Override
    public Collection<EObject> adaptTool(AbstractToolStep<?> tool, Map<String, Object> parameters, Collection<EObject> semanticElements) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        for (EObject element : semanticElements) {
            if (element instanceof InstanceRole) {
                result.add((EObject)((InstanceRole)element).getRepresentedInstance());
                continue;
            }
            result.add(element);
        }
        return result;
    }

    public void reconnectConstraint(String toolName, String id, String oldTargetId, String newTargetId) {
        new ReconnectTool(this, toolName, id, oldTargetId, newTargetId).run();
    }

    public BlockArchitectureExt.Type getDiagramBlockArchitecture() {
        return this.type;
    }

    protected static class InsertRemoveInstanceRoleTool
    extends InsertRemoveTool {
        static EReference representing = InformationPackage.Literals.ABSTRACT_INSTANCE__REPRESENTING_INSTANCE_ROLES;
        static EReference represented = InteractionPackage.Literals.INSTANCE_ROLE__REPRESENTED_INSTANCE;
        static EReference[] features = new EReference[]{represented, representing};

        public InsertRemoveInstanceRoleTool(DiagramContext context, String toolName) {
            super(context, toolName);
            this.insertedReferencedElementsFeatures = features;
        }

        @Override
        protected String[] filterResults(Collection<CapellaElement> objs) {
            DRepresentationDescriptor cRDescriptor = this.getDiagramContext().getDiagramDescriptor();
            String[] results = (String[])objs.stream().filter(x -> !(x instanceof InstanceRole) ? true : x.eContainer() == cRDescriptor.getTarget()).map(x -> x.getId()).toArray(String[]::new);
            Assert.assertTrue((results.length > 0 ? 1 : 0) != 0);
            return results;
        }
    }

    protected static class InsertRemovePartTool
    extends InsertRemoveTool {
        static EReference representing = InformationPackage.Literals.ABSTRACT_INSTANCE__REPRESENTING_INSTANCE_ROLES;
        static EReference[] features = new EReference[]{representing};

        public InsertRemovePartTool(DiagramContext context, String toolName) {
            super(context, toolName);
            this.insertedReferencedElementsFeatures = features;
        }
    }

    protected static class InsertRemoveStateFragmentAbstractFunctionTool
    extends InsertRemoveTool {
        static EReference feature = InteractionPackage.Literals.STATE_FRAGMENT__RELATED_ABSTRACT_FUNCTION;
        static EReference[] features = new EReference[]{feature};

        public InsertRemoveStateFragmentAbstractFunctionTool(DiagramContext context, String toolName, String containerId) {
            super(context, toolName, containerId);
            this.insertedReferencingElementsFeatures = features;
        }
    }

    protected static class InsertRemoveStateFragmentStateTool
    extends InsertRemoveTool {
        static EReference representing = InteractionPackage.Literals.STATE_FRAGMENT__RELATED_ABSTRACT_STATE;
        static EReference[] features = new EReference[]{representing};

        public InsertRemoveStateFragmentStateTool(DiagramContext context, String toolName, String containerId) {
            super(context, toolName, containerId);
            this.insertedReferencingElementsFeatures = features;
        }
    }

    protected class OperandCreationTool
    extends CreateAbstractDNodeTool<DNodeContainer> {
        public OperandCreationTool(DiagramContext context, String toolName, String containerId) {
            super(context, toolName, containerId, containerId, DNodeContainer.class, InteractionOperand.class);
        }
    }

    protected class ReferenceCreationTool
    extends CreateAbstractDNodeWithSelectionTool<DNodeContainer> {
        public ReferenceCreationTool(DiagramContext context, String toolName, String targetContainerId, String containerId, String selectedId) {
            super(context, toolName, targetContainerId, containerId, selectedId, DNodeContainer.class, InteractionUse.class);
        }

        @Override
        protected DSemanticDecorator getContainerView() {
            return this.getDiagramContext().getView(this.containerViewTarget);
        }
    }
}

