/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.common.ju.context;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DDiagramElementContainer;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.DNode;
import org.junit.Assert;
import org.polarsys.capella.common.data.activity.AbstractAction;
import org.polarsys.capella.common.helpers.EObjectLabelProviderHelper;
import org.polarsys.capella.core.data.capellacore.CapellacorePackage;
import org.polarsys.capella.core.data.capellacore.Constraint;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.ctx.CtxPackage;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.fa.FaPackage;
import org.polarsys.capella.core.data.fa.FunctionInputPort;
import org.polarsys.capella.core.data.fa.FunctionOutputPort;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.core.data.la.LaPackage;
import org.polarsys.capella.core.data.oa.OaPackage;
import org.polarsys.capella.core.data.oa.OperationalActivity;
import org.polarsys.capella.core.data.pa.PaPackage;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.sirius.analysis.DiagramServices;
import org.polarsys.capella.core.sirius.analysis.helpers.ToolProviderHelper;
import org.polarsys.capella.core.sirius.ui.handlers.CreateFunctionalChainActionHandler;
import org.polarsys.capella.test.diagram.common.ju.availableXDFBDiagramTools.XDFBCreateContainerTools;
import org.polarsys.capella.test.diagram.common.ju.availableXDFBDiagramTools.XDFBCreateEdgeTools;
import org.polarsys.capella.test.diagram.common.ju.availableXDFBDiagramTools.XDFBCreateNodeTools;
import org.polarsys.capella.test.diagram.common.ju.availableXDFBDiagramTools.XDFBInsertRemoveTools;
import org.polarsys.capella.test.diagram.common.ju.context.CommonDiagram;
import org.polarsys.capella.test.diagram.common.ju.context.DiagramContext;
import org.polarsys.capella.test.diagram.common.ju.step.crud.CreateDiagramStep;
import org.polarsys.capella.test.diagram.common.ju.step.crud.OpenDiagramStep;
import org.polarsys.capella.test.diagram.common.ju.step.tools.CreateAbstractDNodeTool;
import org.polarsys.capella.test.diagram.common.ju.step.tools.CreateContainerTool;
import org.polarsys.capella.test.diagram.common.ju.step.tools.CreateDEdgeTool;
import org.polarsys.capella.test.diagram.common.ju.step.tools.InitializationFromExistingDiagramTool;
import org.polarsys.capella.test.diagram.common.ju.step.tools.InsertRemoveTool;
import org.polarsys.capella.test.diagram.common.ju.step.tools.ReconnectTool;
import org.polarsys.capella.test.diagram.common.ju.step.tools.SelectFromListTool;
import org.polarsys.capella.test.diagram.common.ju.step.tools.SwitchTool;
import org.polarsys.capella.test.framework.context.SessionContext;

public class XDFBDiagram
extends CommonDiagram {
    BlockArchitectureExt.Type type = null;

    public XDFBDiagram(BlockArchitectureExt.Type type, SessionContext context, DDiagram diagram) {
        super(context, diagram);
        this.type = type;
    }

    public static XDFBDiagram createDiagram(SessionContext executionContext, String targetIdentifier) {
        BlockArchitecture architecture = BlockArchitectureExt.getRootBlockArchitecture((EObject)executionContext.getSemanticElement(targetIdentifier));
        final BlockArchitectureExt.Type type = BlockArchitectureExt.getBlockArchitectureType((BlockArchitecture)architecture);
        String name = null;
        if (type == BlockArchitectureExt.Type.OA) {
            name = "Operational Activity Interaction Blank";
        } else if (type == BlockArchitectureExt.Type.SA) {
            name = "System Data Flow Blank";
        } else if (type == BlockArchitectureExt.Type.LA) {
            name = "Logical Data Flow Blank";
        } else if (type == BlockArchitectureExt.Type.PA) {
            name = "Physical Data Flow Blank";
        }
        return (XDFBDiagram)((DiagramContext)new CreateDiagramStep(executionContext, targetIdentifier, name){

            @Override
            public DiagramContext getResult() {
                return new XDFBDiagram(type, this.getExecutionContext(), this.diagram);
            }
        }.run()).open();
    }

    public static XDFBDiagram openDiagram(SessionContext executionContext, String name, final BlockArchitectureExt.Type type) {
        return (XDFBDiagram)((DiagramContext)new OpenDiagramStep(executionContext, name){

            @Override
            public DiagramContext getResult() {
                return new XDFBDiagram(type, this.getExecutionContext(), this.diagram);
            }
        }.run()).open();
    }

    @Deprecated
    public void createFunction(String elementId, String containerId) {
        new CreateContainerTool((DiagramContext)this, "function", containerId, elementId).run();
    }

    @Deprecated
    public void createFunction(String elementId) {
        this.createFunction(elementId, this.getDiagramId());
    }

    public String createNode(String containerId, XDFBCreateNodeTools toolName) {
        DNode graphicalElement = (DNode)new CreateAbstractDNodeTool((DiagramContext)this, toolName.getToolName(), containerId).run();
        this.customVerificationOnCreatedNode(toolName, (DDiagramElement)graphicalElement, containerId);
        return this.getSemanticIdFromView((DDiagramElement)graphicalElement);
    }

    public String createContainer(String containerId, XDFBCreateContainerTools toolName) {
        DDiagramElementContainer graphicalElement = (DDiagramElementContainer)new CreateContainerTool((DiagramContext)this, toolName.getToolName(), containerId).run();
        this.customVerificationOnCreatedContainer(toolName, (DDiagramElement)graphicalElement, containerId);
        return this.getSemanticIdFromView((DDiagramElement)graphicalElement);
    }

    public String createEdge(String sourceViewId, String targetViewId, XDFBCreateEdgeTools toolName) {
        DEdge graphicalElement = (DEdge)new CreateDEdgeTool((DiagramContext)this, toolName.getToolName(), sourceViewId, targetViewId, null, null, null).run();
        this.customVerificationOnCreatedEdge(toolName, (DDiagramElement)graphicalElement, sourceViewId, targetViewId);
        return this.getSemanticIdFromView((DDiagramElement)graphicalElement);
    }

    @Deprecated
    public void createFunctionalExchange(String id, String sourceViewId, String targetViewId, String newSourceIdentifier, String newTargetIdentifier) {
        new CreateDEdgeTool((DiagramContext)this, "functional.exchange", sourceViewId, targetViewId, id, newSourceIdentifier, newTargetIdentifier).run();
    }

    @Deprecated
    public void createFunctionalExchange(String id, String sourceViewId, String targetViewId) {
        this.createFunctionalExchange(id, sourceViewId, targetViewId, null, null);
    }

    public void createFunctionalChain(String path, String ... links) {
        List decorators = Arrays.stream(links).map(string -> this.getView((String)string)).collect(Collectors.toList());
        final List correspondingEditPart = decorators.stream().map(decorator -> DiagramServices.getDiagramServices().getEditPart((DDiagramElement)decorator)).collect(Collectors.toList());
        ExecutionEvent event = this.createExecutionEvent(correspondingEditPart);
        CreateFunctionalChainActionHandler handler = new CreateFunctionalChainActionHandler(){

            protected IStructuredSelection getSelection() {
                StructuredSelection selection = new StructuredSelection(correspondingEditPart);
                return selection;
            }
        };
        Object result = null;
        try {
            result = handler.execute(event);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        this.putView(path, (DDiagramElement)result);
        this.getSessionContext().putSemanticElement(path, ((DDiagramElement)result).getTarget());
    }

    public void showElements(String containerId, XDFBInsertRemoveTools toolName, String ... elementsToBeInsertedIds) {
        new InsertRemoveTool((DiagramContext)this, toolName.getToolName(), containerId).insert(elementsToBeInsertedIds);
    }

    public void hideElements(String containerId, XDFBInsertRemoveTools toolName, String ... elementsToBeRemovedIds) {
        new InsertRemoveTool((DiagramContext)this, toolName.getToolName(), containerId).remove(elementsToBeRemovedIds);
    }

    public void switchInFunctionalExchangesCategories(String id) {
        new SwitchTool(this, "switch.functional.exchanges.categories").insert(id);
    }

    public void switchOutFunctionalExchangesCategories(String id) {
        new SwitchTool(this, "switch.functional.exchanges.categories").remove(id);
    }

    public void reconnectFunctionalExchange(String edgeId, String oldSourceId, String newSourceId) {
        new ReconnectTool(this, ToolProviderHelper.getToolReconnectComponentExchangeSource((DDiagram)this.getDiagram()), edgeId, oldSourceId, newSourceId).run();
    }

    public void cannotReconnectFunctionalExchange(String edgeId, String oldSourceId, String newSourceId) {
        new ReconnectTool(this, ToolProviderHelper.getToolReconnectComponentExchangeSource((DDiagram)this.getDiagram()), edgeId, oldSourceId, newSourceId).shouldFail();
    }

    public void initializationFromExistingDiagram(DiagramContext existingContext) {
        new InitializationFromExistingDiagramTool((DiagramContext)this, "initialization.from.existing.diagram", existingContext).insert(existingContext.getDiagramId());
    }

    public void insertElementsFromScenario(String[] selectedScenarioIds, String ... inserted) {
        new SelectFromListTool((DiagramContext)this, "elements.from.scenario", this.getDiagramId(), inserted).select(selectedScenarioIds);
    }

    public void insertElementsFromModeStateMachine(String[] selectedModesIds, String ... inserted) {
        String name = null;
        switch (this.type) {
            case OA: {
                name = "activities.from.mode.state";
                break;
            }
            default: {
                name = "functions.from.mode.state";
            }
        }
        new SelectFromListTool((DiagramContext)this, name, this.getDiagramId(), inserted).select(selectedModesIds);
    }

    public void dragAndDropFunctionPort(String idDraggedElement, String containerId) {
        this.dragAndDrop(idDraggedElement, containerId, "DnD DF FunctionPort");
    }

    public void dragAndDropAbstractFunction(String idDraggedElement, String containerId) {
        this.dragAndDrop(idDraggedElement, containerId, this.getDragAndDropAbstractFunctionToolName());
    }

    public void dragAndDropFunctionFromExplorer(String idDraggedElement, String containerId) {
        this.dragAndDropFromExplorer(idDraggedElement, containerId, this.getDragAndDropFunctionFromExplorerToolName());
    }

    private String getDragAndDropAbstractFunctionToolName() {
        if (this.type == BlockArchitectureExt.Type.OA) {
            return "DnD DF AbstractFunction";
        }
        return "DnD DF AbstractFunction";
    }

    private String getDragAndDropFunctionFromExplorerToolName() {
        if (this.type == BlockArchitectureExt.Type.OA) {
            return "D&D OperationalActivity From Project Explorer";
        }
        return "D&D Function From Project Explorer";
    }

    private void customVerificationOnCreatedNode(XDFBCreateNodeTools toolName, DDiagramElement view, String containerId) {
        switch (toolName) {
            case CREATE_INPUT_PORT: {
                this.checkClassOfDiagramElement(view, FaPackage.Literals.FUNCTION_INPUT_PORT);
                this.checkParentOfCreatedElement(view, containerId);
                break;
            }
            case CREATE_OUTPUT_PORT: {
                this.checkClassOfDiagramElement(view, FaPackage.Literals.FUNCTION_OUTPUT_PORT);
                this.checkParentOfCreatedElement(view, containerId);
                break;
            }
            case CREATE_CONSTRAINT: {
                this.checkClassOfDiagramElement(view, CapellacorePackage.Literals.CONSTRAINT);
                break;
            }
        }
    }

    private void customVerificationOnCreatedContainer(XDFBCreateContainerTools toolName, DDiagramElement view, String containerId) {
        switch (toolName) {
            // Empty switch
        }
        this.checkClassOfFunctionType(view);
        this.checkParentOfCreatedElement(view, containerId);
    }

    private void customVerificationOnCreatedEdge(XDFBCreateEdgeTools toolName, DDiagramElement view, String sourceId, String targetId) {
        switch (toolName) {
            case CREATE_FUNCTIONAL_EXCHANGE: {
                this.checkClassOfDiagramElement(view, FaPackage.Literals.FUNCTIONAL_EXCHANGE);
                this.checkSourceAndTargetOfFunctionalExchange(view, sourceId, targetId);
                break;
            }
            case CREATE_CONSTRAINT_LINK: {
                this.checkClassOfDiagramElement(view, CapellacorePackage.Literals.CONSTRAINT);
                this.checkConstraintOnElement(view, targetId);
                break;
            }
        }
    }

    private void checkClassOfDiagramElement(DDiagramElement view, EClass expectedClass) {
        EObject semanticElement = view.getTarget();
        boolean result = expectedClass == semanticElement.eClass();
        Assert.assertTrue((String)NLS.bind((String)("Created Object has the WRONG class. Expected Class: " + expectedClass.getName() + " ; Actual Class:" + semanticElement.getClass().getSimpleName()), (Object)EObjectLabelProviderHelper.getText((Object)semanticElement)), (boolean)result);
    }

    private void checkParentOfCreatedElement(DDiagramElement view, String containerId) {
        EObject semanticElement = view.getTarget();
        EObject containerElement = this.getSessionContext().getSemanticElement(containerId);
        if (containerElement instanceof AbstractFunction) {
            AbstractFunction functionContainer = (AbstractFunction)containerElement;
            boolean result = functionContainer.getSubFunctions().contains((Object)semanticElement);
            if (!result && !(result = functionContainer.getInputs().contains((Object)semanticElement))) {
                result = functionContainer.getOutputs().contains((Object)semanticElement);
            }
            Assert.assertTrue((String)NLS.bind((String)"Created Element has the WRONG parent.", (Object)EObjectLabelProviderHelper.getText((Object)semanticElement)), (boolean)result);
        }
    }

    private void checkClassOfFunctionType(DDiagramElement view) {
        EObject semanticElement = view.getTarget();
        EClass expectedClass = null;
        switch (this.type) {
            case OA: {
                expectedClass = OaPackage.Literals.OPERATIONAL_ACTIVITY;
                break;
            }
            case SA: {
                expectedClass = CtxPackage.Literals.SYSTEM_FUNCTION;
                break;
            }
            case LA: {
                expectedClass = LaPackage.Literals.LOGICAL_FUNCTION;
                break;
            }
            case PA: {
                expectedClass = PaPackage.Literals.PHYSICAL_FUNCTION;
                break;
            }
        }
        boolean result = expectedClass == semanticElement.eClass();
        Assert.assertTrue((String)NLS.bind((String)("Created Function has the WRONG class. Expected Class: " + expectedClass.getName() + " ; Actual Class:" + semanticElement.getClass().getSimpleName()), (Object)EObjectLabelProviderHelper.getText((Object)semanticElement)), (boolean)result);
    }

    private void checkSourceAndTargetOfFunctionalExchange(DDiagramElement view, String sourceId, String targetId) {
        EObject source = this.getSessionContext().getSemanticElement(sourceId);
        EObject target = this.getSessionContext().getSemanticElement(targetId);
        FunctionalExchange exchange = (FunctionalExchange)view.getTarget();
        if (this.type != BlockArchitectureExt.Type.OA) {
            FunctionInputPort inputPort = (FunctionInputPort)exchange.getTarget();
            FunctionOutputPort outputPort = (FunctionOutputPort)exchange.getSource();
            boolean inputResult = false;
            if (target instanceof AbstractAction) {
                inputResult = ((AbstractAction)target).getInputs().contains((Object)inputPort);
            } else if (target instanceof FunctionInputPort) {
                inputResult = (FunctionInputPort)target == inputPort;
            }
            Assert.assertTrue((String)NLS.bind((String)"Target Element is not equal to the expected one", (Object)EObjectLabelProviderHelper.getText((Object)target)), (boolean)inputResult);
            boolean outputResult = false;
            if (source instanceof AbstractAction) {
                outputResult = ((AbstractAction)source).getOutputs().contains((Object)outputPort);
            } else if (source instanceof FunctionOutputPort) {
                outputResult = (FunctionOutputPort)source == outputPort;
            }
            Assert.assertTrue((String)NLS.bind((String)"Source Element is not equal to the expected one", (Object)EObjectLabelProviderHelper.getText((Object)source)), (boolean)outputResult);
        } else {
            OperationalActivity sourceOA = (OperationalActivity)exchange.getSource();
            OperationalActivity targetOA = (OperationalActivity)exchange.getTarget();
            boolean inputResult = sourceOA == source;
            Assert.assertTrue((String)NLS.bind((String)"Source OA of Interaction is not the one provided", (Object)EObjectLabelProviderHelper.getText((Object)source)), (boolean)inputResult);
            boolean outputResult = targetOA == target;
            Assert.assertTrue((String)NLS.bind((String)"Target OA of Interaction is not the one provided", (Object)EObjectLabelProviderHelper.getText((Object)source)), (boolean)outputResult);
        }
    }

    private void checkConstraintOnElement(DDiagramElement view, String targetId) {
        Constraint semanticElement = (Constraint)view.getTarget();
        EObject constraintTarget = this.getSessionContext().getSemanticElement(targetId);
        boolean result = semanticElement.getConstrainedElements().contains((Object)constraintTarget);
        Assert.assertTrue((String)NLS.bind((String)"Target element does not have the Constraint attached", (Object)EObjectLabelProviderHelper.getText((Object)semanticElement)), (boolean)result);
    }

    public BlockArchitectureExt.Type getDiagramType() {
        return this.type;
    }
}

