/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.common.ju.step.crud;

import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.junit.Assert;
import org.polarsys.capella.common.helpers.EObjectExt;
import org.polarsys.capella.test.diagram.common.ju.context.DiagramContext;
import org.polarsys.capella.test.diagram.common.ju.step.Messages;
import org.polarsys.capella.test.diagram.common.ju.wrapper.utils.DiagramHelper;
import org.polarsys.capella.test.framework.api.step.AbstractTestStep;
import org.polarsys.capella.test.framework.context.SessionContext;

public class OpenDiagramStep
extends AbstractTestStep<DiagramContext> {
    private boolean _mustBeRefreshed;
    protected DiagramContext diagramContext;
    protected DDiagram diagram;

    public OpenDiagramStep(DiagramContext diagramContext_p) {
        this(diagramContext_p, false);
    }

    public OpenDiagramStep(DiagramContext diagramContext, boolean mustBeRefreshed) {
        super(diagramContext.getSessionContext());
        this._mustBeRefreshed = mustBeRefreshed;
        this.diagram = diagramContext.getDiagram();
    }

    public OpenDiagramStep(SessionContext context_p, String diagramName, boolean mustBeRefreshed) {
        super(context_p);
        this.diagram = (DDiagram)DiagramHelper.getDRepresentation(context_p.getSession(), diagramName);
        this._mustBeRefreshed = mustBeRefreshed;
    }

    public OpenDiagramStep(SessionContext context_p, String diagramName) {
        this(context_p, diagramName, false);
    }

    protected void preRunTest() {
        super.preRunTest();
        Assert.assertNotNull((String)Messages.nullDiagram, (Object)this.diagram);
    }

    protected void runTest() {
        DiagramHelper.opendiagramEditor(this.getExecutionContext().getSession(), (DRepresentation)this.diagram);
        if (this._mustBeRefreshed || this.diagram.getOwnedRepresentationElements().isEmpty()) {
            boolean ret = DiagramHelper.refreshDiagram(this.diagram);
            Assert.assertTrue((String)NLS.bind((String)Messages.failToRefreshDiagram, (Object[])new Object[]{EObjectExt.getText((EObject)this.diagram)}), (boolean)ret);
        }
    }

    public DiagramContext getResult() {
        String diagramIdentifier = EObjectExt.getText((EObject)this.diagram);
        Map semanticMap = this.getExecutionContext().getSemanticObjectMap();
        if (semanticMap.containsKey(diagramIdentifier) && this.diagramContext != null) {
            return this.diagramContext;
        }
        DiagramContext diagramContext = new DiagramContext(this.getExecutionContext(), this.diagram);
        this.getExecutionContext().putSemanticElement(diagramIdentifier, (EObject)this.diagram);
        return diagramContext;
    }
}

