/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.common.ju.step.tools;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.junit.Assert;
import org.polarsys.capella.test.diagram.common.ju.context.DiagramContext;
import org.polarsys.capella.test.diagram.common.ju.step.tools.AbstractToolStep;
import org.polarsys.capella.test.diagram.common.ju.wrapper.utils.ArgumentType;
import org.polarsys.capella.test.diagram.common.ju.wrapper.utils.DiagramHelper;

public class CreateDEdgeTool
extends AbstractToolStep<DEdge> {
    protected String _sourceView;
    protected String _targetView;
    @Deprecated
    String _newSourceIdentifier;
    @Deprecated
    String _newTargetIdentifier;
    @Deprecated
    protected String _newIdentifier;
    Collection<DDiagramElement> _sourceElements;
    Collection<DDiagramElement> _targetElements;
    Collection<DDiagramElement> _newSourceElements;
    Collection<DDiagramElement> _newTargetElements;
    Collection<DDiagramElement> _edgesElements;
    protected Collection<DDiagramElement> _newEdgesElements;
    protected int expectedNumberOfNewEdges;
    protected int expectedNumberOfNewElementsOnSource;
    protected int expectedNumberOfNewElementsOnTarget;

    public CreateDEdgeTool(DiagramContext context, String toolName, String sourceView, String targetView, int expectedNumberOfNewEdges, int expectedNumberOfNewElementsOnSource, int expectedNumberOfNewElementsOnTarget) {
        super(context, toolName);
        this._sourceView = sourceView;
        this._targetView = targetView;
        this.expectedNumberOfNewEdges = expectedNumberOfNewEdges;
        this.expectedNumberOfNewElementsOnSource = expectedNumberOfNewElementsOnSource;
        this.expectedNumberOfNewElementsOnTarget = expectedNumberOfNewElementsOnTarget;
    }

    public CreateDEdgeTool(DiagramContext context, String toolName, String sourceView, String targetView) {
        super(context, toolName);
        this._sourceView = sourceView;
        this._targetView = targetView;
        this.expectedNumberOfNewEdges = -1;
        this.expectedNumberOfNewElementsOnSource = -1;
        this.expectedNumberOfNewElementsOnTarget = -1;
    }

    @Deprecated
    public CreateDEdgeTool(DiagramContext context, String toolName, String sourceView, String targetView, String newIdentifier) {
        this(context, toolName, sourceView, targetView, -1, -1, -1);
        this._newIdentifier = newIdentifier;
    }

    @Deprecated
    public CreateDEdgeTool(DiagramContext context, String toolName, String sourceView, String targetView, String newIdentifier, String newSourceIdentifier, String newTargetIdentifier) {
        this(context, toolName, sourceView, targetView, -1, -1, -1);
        this._newIdentifier = newIdentifier;
        this._newSourceIdentifier = newSourceIdentifier;
        this._newTargetIdentifier = newTargetIdentifier;
    }

    @Override
    protected void preRunTest() {
        super.preRunTest();
        this._sourceElements = DiagramHelper.getOwnedElements(this.getDiagramContext().getView(this._sourceView));
        this._targetElements = DiagramHelper.getOwnedElements(this.getDiagramContext().getView(this._targetView));
        this._edgesElements = new ArrayList<DDiagramElement>((Collection<DDiagramElement>)this.getDiagramContext().getDiagram().getEdges());
    }

    protected void dispose() {
        super.dispose();
        this._sourceElements = null;
        this._targetElements = null;
    }

    protected void postRunTest() {
        super.postRunTest();
        this._newSourceElements = DiagramHelper.getOwnedElements(this.getDiagramContext().getView(this._sourceView));
        this._newSourceElements.removeAll(this._sourceElements);
        this._newTargetElements = DiagramHelper.getOwnedElements(this.getDiagramContext().getView(this._targetView));
        this._newTargetElements.removeAll(this._targetElements);
        this._newEdgesElements = new ArrayList<DDiagramElement>((Collection<DDiagramElement>)this.getDiagramContext().getDiagram().getEdges());
        this._newEdgesElements.removeAll(this._edgesElements);
        if (!(this._newEdgesElements.iterator().next() instanceof DEdge)) {
            Assert.fail((String)"The crated element is not of type DEdge");
        }
        if (this.expectedNumberOfNewEdges != -1 && this._newEdgesElements.size() != this.expectedNumberOfNewEdges) {
            Assert.fail((String)("The number of created edges is not equal to " + this.expectedNumberOfNewEdges));
        }
        if (this.expectedNumberOfNewElementsOnSource != -1 && this._newSourceElements.size() != this.expectedNumberOfNewElementsOnSource) {
            Assert.fail((String)("The number of created edges is not equal to " + this.expectedNumberOfNewElementsOnSource));
        }
        if (this.expectedNumberOfNewElementsOnTarget != -1 && this._newTargetElements.size() != this.expectedNumberOfNewElementsOnTarget) {
            Assert.fail((String)("The number of created edges is not equal to " + this.expectedNumberOfNewElementsOnTarget));
        }
    }

    public DEdge getResult() {
        DEdge createdEdgeView = (DEdge)this._newEdgesElements.iterator().next();
        String edgeId = EcoreUtil.getID((EObject)createdEdgeView.getTarget());
        if (this._newIdentifier != null) {
            this.getExecutionContext().putSemanticElement(this._newIdentifier, createdEdgeView.getTarget());
            this.getDiagramContext().putView(this._newIdentifier, (DDiagramElement)createdEdgeView);
        }
        if (this._newSourceIdentifier != null && !this._newSourceElements.isEmpty()) {
            DDiagramElement sView = this._newSourceElements.iterator().next();
            this.getExecutionContext().putSemanticElement(this._newSourceIdentifier, sView.getTarget());
            this.getDiagramContext().putView(this._newSourceIdentifier, sView);
        }
        if (this._newTargetIdentifier != null && !this._newTargetElements.isEmpty()) {
            DDiagramElement tView = this._newTargetElements.iterator().next();
            this.getExecutionContext().putSemanticElement(this._newTargetIdentifier, tView.getTarget());
            this.getDiagramContext().putView(this._newTargetIdentifier, tView);
        }
        if (this._newIdentifier == null && this._newSourceIdentifier == null && this._newTargetIdentifier == null) {
            this.getExecutionContext().putSemanticElement(edgeId, createdEdgeView.getTarget());
            this.getDiagramContext().putView(edgeId, (DDiagramElement)createdEdgeView);
        }
        return createdEdgeView;
    }

    @Override
    protected void initToolArguments() {
        DSemanticDecorator edgeSourceView = this.getDiagramContext().getView(this._sourceView);
        this._toolWrapper.setArgumentValue(ArgumentType.SOURCE, edgeSourceView);
        DSemanticDecorator edgeTargetView = this.getDiagramContext().getView(this._targetView);
        this._toolWrapper.setArgumentValue(ArgumentType.TARGET, edgeTargetView);
    }
}

