/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.common.ju.step.tools;

import com.google.common.base.Predicate;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.diagram.AbstractDNode;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.ui.business.api.view.SiriusGMFHelper;
import org.eclipse.sirius.diagram.ui.internal.refresh.GMFHelper;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.junit.Assert;
import org.polarsys.capella.core.sirius.analysis.DiagramServices;
import org.polarsys.capella.test.diagram.common.ju.context.DiagramContext;
import org.polarsys.capella.test.diagram.common.ju.step.tools.InsertRemoveTool;
import org.polarsys.capella.test.diagram.common.ju.wrapper.utils.DiagramHelper;
import org.polarsys.capella.test.framework.helpers.GuiActions;

public class InitializationFromExistingDiagramTool
extends InsertRemoveTool {
    private DiagramContext existingDiagramContext;
    private int tolerance = 0;
    Predicate<Node> nodePredicate = new Predicate<Node>(){

        public boolean apply(Node input) {
            return input.eContainer() != null && input.getElement() != null;
        }
    };

    public InitializationFromExistingDiagramTool(DiagramContext context, String toolName, String containerId, DiagramContext existingDiagramContext) {
        super(context, toolName, containerId);
        this.existingDiagramContext = existingDiagramContext;
    }

    public InitializationFromExistingDiagramTool(DiagramContext context, String toolName, DiagramContext existingDiagramContext) {
        super(context, toolName);
        this.existingDiagramContext = existingDiagramContext;
    }

    public InitializationFromExistingDiagramTool(DiagramContext context, String[] toolIdentifier, String containerId, DiagramContext existingDiagramContext) {
        super(context, toolIdentifier, containerId);
        this.existingDiagramContext = existingDiagramContext;
    }

    public InitializationFromExistingDiagramTool(DiagramContext context, String[] toolIdentifier, DiagramContext existingDiagramContext) {
        super(context, toolIdentifier);
        this.existingDiagramContext = existingDiagramContext;
    }

    public void setTolerance(int value) {
        this.tolerance = value;
    }

    @Override
    protected void postRunTest() {
        DiagramHelper.refreshDiagram(this.getDiagramContext().getDiagram());
        GuiActions.flushASyncGuiThread();
        Map<String, Point> existingLocationMap = this.getNameToLocationMap(this.existingDiagramContext.getDiagram());
        Map<String, Point> initializedDiagramLocationMap = this.getNameToLocationMap(this.getDiagramContext().getDiagram());
        boolean atLeastOneCheck = false;
        for (String key : initializedDiagramLocationMap.keySet()) {
            Point existingLocation = existingLocationMap.get(key);
            if (existingLocation == null) continue;
            atLeastOneCheck = true;
            Point initializedLocation = initializedDiagramLocationMap.get(key);
            if (Math.abs(existingLocation.y - initializedLocation.y) <= this.tolerance && Math.abs(existingLocation.x - initializedLocation.x) <= this.tolerance) continue;
            Assert.assertFalse((boolean)true);
        }
        Assert.assertTrue((boolean)atLeastOneCheck);
    }

    private Map<String, Point> getNameToLocationMap(DDiagram dDiagram) {
        HashMap<String, Point> locationMap = new HashMap<String, Point>();
        Session session = SessionManager.INSTANCE.getSession(((DSemanticDecorator)dDiagram).getTarget());
        for (DDiagramElement element : dDiagram.getDiagramElements()) {
            if (!(element instanceof AbstractDNode)) continue;
            Node node = SiriusGMFHelper.getGmfNode((DDiagramElement)element, (Session)session);
            Point location = GMFHelper.getAbsoluteLocation((Node)node);
            Object name = element.getName();
            if (DiagramServices.getDiagramServices().isABorderedNode((AbstractDNode)element)) {
                name = (String)name + ((AbstractDNode)element.eContainer()).getName();
            }
            locationMap.put((String)name, location);
        }
        return locationMap;
    }
}

