/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.common.ju.step.tools;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.junit.Assert;
import org.polarsys.capella.core.sirius.analysis.actions.extensions.AbstractExternalJavaAction;
import org.polarsys.capella.test.diagram.common.ju.context.DiagramContext;
import org.polarsys.capella.test.diagram.common.ju.headless.HeadlessResultOpProvider;
import org.polarsys.capella.test.diagram.common.ju.headless.IHeadlessResult;
import org.polarsys.capella.test.diagram.common.ju.step.tools.AbstractToolStep;
import org.polarsys.capella.test.diagram.common.ju.wrapper.utils.ArgumentType;
import org.polarsys.capella.test.diagram.common.ju.wrapper.utils.DiagramHelper;
import org.polarsys.capella.test.framework.context.SessionContext;

public class SelectFromListTool
extends AbstractToolStep<Object> {
    boolean initialized = false;
    boolean selectAll = false;
    boolean autoRefresh = true;
    String containerId;
    protected String[] insertedElements;
    protected String[] selectedElements;

    public SelectFromListTool(DiagramContext context, String toolName, String containerId, String ... insertedElements) {
        super(context, toolName);
        this.containerId = containerId;
        this.insertedElements = insertedElements;
        if (insertedElements == null) {
            this.insertedElements = new String[0];
        }
    }

    public SelectFromListTool(DiagramContext context, String toolName, String containerId, boolean autoRefresh, String ... insertedElements) {
        this(context, toolName, containerId, insertedElements);
        this.autoRefresh = autoRefresh;
    }

    protected void initialize(boolean selectAll) {
        this.selectAll = selectAll;
        this.initialized = true;
    }

    protected void initialize(String ... selectedElements) {
        this.selectedElements = selectedElements;
        if (selectedElements == null) {
            this.selectedElements = new String[0];
        }
        this.initialized = true;
    }

    public Object run() {
        if (!this.initialized) {
            Assert.fail((String)"Please use select methods instead of run.");
        }
        return super.run();
    }

    public void select(String ... ids) {
        this.initialize(ids);
        this.run();
    }

    public void selectAll() {
        this.initialize(true);
        this.run();
    }

    @Override
    protected void preRunTest() {
        HeadlessResultOpProvider.INSTANCE.setCurrentOp(this.createOperation());
        super.preRunTest();
    }

    protected IHeadlessResult createOperation() {
        return new IHeadlessResult(){

            @Override
            public Object getResult(Collection<? extends EObject> selections, Map<String, Object> parameters) {
                if (SelectFromListTool.this.selectAll) {
                    return AbstractExternalJavaAction.getScope(parameters);
                }
                HashSet objects = new HashSet();
                DiagramContext diagramContext = SelectFromListTool.this.getDiagramContext();
                SessionContext sessionContext = SelectFromListTool.this.getExecutionContext();
                Collection<EObject> selected = diagramContext.adaptTool(SelectFromListTool.this, parameters, sessionContext.getSemanticElements(SelectFromListTool.this.selectedElements));
                objects.addAll(AbstractExternalJavaAction.getScope(parameters));
                return new ArrayList(objects);
            }
        };
    }

    @Override
    protected void initToolArguments() {
        DSemanticDecorator containerView = this.getDiagramContext().getView(this.containerId);
        this._toolWrapper.setArgumentValue(ArgumentType.CONTAINER, containerView.getTarget());
        this._toolWrapper.setArgumentValue(ArgumentType.CONTAINER_VIEW, containerView);
    }

    protected void postRunTest() {
        super.postRunTest();
        if (this.autoRefresh) {
            DiagramHelper.refreshDiagram(this.getDiagramContext().getDiagram());
        }
        String[] stringArray = this.insertedElements;
        int n = this.insertedElements.length;
        int n2 = 0;
        while (n2 < n) {
            String identifier = stringArray[n2];
            this.getDiagramContext().hasView(identifier);
            ++n2;
        }
    }

    public Object getResult() {
        return null;
    }
}

