/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.common.ju.step.tools.sequence;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DNodeContainer;
import org.junit.Assert;
import org.polarsys.capella.core.data.interaction.CombinedFragment;
import org.polarsys.capella.core.data.interaction.InteractionOperand;
import org.polarsys.capella.core.data.interaction.InteractionOperatorKind;
import org.polarsys.capella.test.diagram.common.ju.context.DiagramContext;
import org.polarsys.capella.test.diagram.common.ju.headless.HeadlessResultOpProvider;
import org.polarsys.capella.test.diagram.common.ju.headless.IHeadlessResult;
import org.polarsys.capella.test.diagram.common.ju.step.tools.CreateAbstractDNodeTool;
import org.polarsys.capella.test.diagram.common.ju.wrapper.utils.DiagramHelper;

public class CombinedFragmentCreationTool
extends CreateAbstractDNodeTool<DNodeContainer> {
    private InteractionOperatorKind operatorKind;
    private boolean selectOperand;

    public CombinedFragmentCreationTool(DiagramContext context, String toolName, String targetContainerView, String containerView, InteractionOperatorKind operatorKind, boolean selectOperand) {
        super(context, toolName, targetContainerView, containerView);
        this.operatorKind = operatorKind;
        this.selectOperand = selectOperand;
    }

    @Override
    protected void preRunTest() {
        super.preRunTest();
        if (this.selectOperand) {
            HeadlessResultOpProvider.INSTANCE.setCurrentOp(new IHeadlessResult(){

                @Override
                public Object getResult(Collection<? extends EObject> selections, Map<String, Object> parameters) {
                    return CombinedFragmentCreationTool.this.operatorKind;
                }
            });
        }
        this.elements = DiagramHelper.getDiagramElements(this.getDiagramContext().getDiagram());
    }

    @Override
    protected int expectedNewElements() {
        return 2;
    }

    @Override
    protected void postRunTest() {
        this.newElements = new ArrayList();
        this.newElements.addAll(DiagramHelper.getDiagramElements(this.getDiagramContext().getDiagram()));
        this.newElements.removeAll(this.elements);
        if (this.newElements.size() != this.expectedNewElements()) {
            Assert.fail();
        }
        boolean createdCombinedFragment = false;
        boolean createdOperand = false;
        for (DDiagramElement dElement : this.newElements) {
            if (dElement.getTarget() instanceof CombinedFragment) {
                createdCombinedFragment = true;
                InteractionOperatorKind kind = ((CombinedFragment)dElement.getTarget()).getOperator();
                Assert.assertTrue((String)("Operator should be of kind " + String.valueOf(this.operatorKind) + " but is of kind " + String.valueOf(kind)), (kind == this.operatorKind ? 1 : 0) != 0);
            }
            if (!(dElement.getTarget() instanceof InteractionOperand)) continue;
            createdOperand = true;
        }
        Assert.assertTrue((String)"CombinedFragment is not created", (boolean)createdCombinedFragment);
        Assert.assertTrue((String)"Operand is not created", (boolean)createdOperand);
    }
}

