/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.common.ju.wrapper.factory;

import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sirius.diagram.sequence.description.tool.ToolPackage;
import org.eclipse.sirius.diagram.tools.api.command.DiagramCommandFactoryService;
import org.eclipse.sirius.diagram.tools.api.command.IDiagramCommandFactory;
import org.eclipse.sirius.tools.api.command.ICommandFactory;
import org.eclipse.sirius.viewpoint.description.tool.AbstractToolDescription;
import org.polarsys.capella.common.ef.ExecutionManager;
import org.polarsys.capella.common.ef.ExecutionManagerRegistry;
import org.polarsys.capella.test.diagram.common.ju.wrapper.AbstractCommonToolWrapper;
import org.polarsys.capella.test.diagram.common.ju.wrapper.AbstractToolWrapper;
import org.polarsys.capella.test.diagram.common.ju.wrapper.factory.AbstractToolWrapperFactory;
import org.polarsys.capella.test.diagram.common.ju.wrapper.sequence.CombinedFragmentCreationDescriptionWrapper;
import org.polarsys.capella.test.diagram.common.ju.wrapper.sequence.InstanceRoleCreationDescriptionWrapper;
import org.polarsys.capella.test.diagram.common.ju.wrapper.sequence.InteractionUseCreationDescriptionWrapper;
import org.polarsys.capella.test.diagram.common.ju.wrapper.sequence.MessageCreationDescriptionWrapper;
import org.polarsys.capella.test.diagram.common.ju.wrapper.sequence.OperandCreationDescriptionWrapper;
import org.polarsys.capella.test.diagram.common.ju.wrapper.sequence.StateCreationDescriptionWrapper;
import org.polarsys.capella.test.framework.helpers.TestHelper;

public class SequenceToolWrapperFactory
extends AbstractToolWrapperFactory {
    @Override
    public EPackage getTargetEPackage() {
        return ToolPackage.eINSTANCE;
    }

    @Override
    public ICommandFactory getDefaultCommandFactory() {
        TransactionalEditingDomain editingDomain = TestHelper.getEditingDomain();
        if (editingDomain == null) {
            ExecutionManager manager = ExecutionManagerRegistry.getInstance().addNewManager();
            editingDomain = manager.getEditingDomain();
        }
        return DiagramCommandFactoryService.getInstance().getNewProvider().getCommandFactory(editingDomain);
    }

    @Override
    public AbstractToolWrapper createToolCommandWrapper(AbstractToolDescription tool_p, ICommandFactory cmdFactory_p) {
        Assert.isNotNull((Object)tool_p);
        Assert.isTrue((boolean)(cmdFactory_p instanceof IDiagramCommandFactory));
        IDiagramCommandFactory commandFactory = (IDiagramCommandFactory)cmdFactory_p;
        AbstractCommonToolWrapper result = null;
        EClass eclass = tool_p.eClass();
        switch (eclass.getClassifierID()) {
            case 5: {
                result = new MessageCreationDescriptionWrapper(tool_p, commandFactory);
                break;
            }
            case 3: {
                result = new InstanceRoleCreationDescriptionWrapper(tool_p, commandFactory);
                break;
            }
            case 9: {
                result = new CombinedFragmentCreationDescriptionWrapper(tool_p, commandFactory);
                break;
            }
            case 10: {
                result = new OperandCreationDescriptionWrapper(tool_p, commandFactory);
                break;
            }
            case 7: {
                result = new StateCreationDescriptionWrapper(tool_p, commandFactory);
                break;
            }
            case 8: {
                result = new InteractionUseCreationDescriptionWrapper(tool_p, commandFactory);
                break;
            }
            default: {
                result = null;
            }
        }
        return result;
    }
}

