/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.common.ju.wrapper.utils;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.common.tools.api.interpreter.EvaluationException;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.business.api.helper.display.DisplayService;
import org.eclipse.sirius.diagram.business.api.helper.display.DisplayServiceManager;
import org.eclipse.sirius.diagram.business.api.helper.filter.FilterService;
import org.eclipse.sirius.diagram.description.DiagramDescription;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.diagram.description.filter.CompositeFilterDescription;
import org.eclipse.sirius.diagram.description.filter.Filter;
import org.eclipse.sirius.diagram.description.filter.FilterDescription;
import org.eclipse.sirius.diagram.description.filter.FilterKind;
import org.eclipse.sirius.diagram.description.filter.MappingFilter;
import org.eclipse.sirius.tools.api.SiriusPlugin;
import org.eclipse.sirius.tools.api.interpreter.InterpreterRegistry;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.junit.Assert;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.common.helpers.EObjectExt;
import org.polarsys.capella.test.diagram.common.ju.wrapper.utils.Messages;
import org.polarsys.capella.test.framework.helpers.TestHelper;

public class FilterOnDiagramHelper {
    public static void checkShowElementsInDiagram(DDiagram diagram, CompositeFilterDescription compositeFilterDescription) {
        Map<DiagramElementMapping, String> mappings = FilterOnDiagramHelper.getMappingsFromCompositeFilter(compositeFilterDescription);
        EList diagramElements = diagram.getDiagramElements();
        DisplayService displayService = DisplayServiceManager.INSTANCE.getDisplayService();
        for (DDiagramElement dDiagramElement : diagramElements) {
            if (!mappings.containsKey(dDiagramElement.getMapping())) continue;
            boolean visible = displayService.isDisplayed(diagram, dDiagramElement);
            if (!visible) {
                FilterOnDiagramHelper.checkUnCollapseFilter(compositeFilterDescription, dDiagramElement);
                continue;
            }
            Assert.assertTrue((String)MessageFormat.format(Messages.elementShouldBeVisible, dDiagramElement.getName(), compositeFilterDescription.getName()), (boolean)visible);
        }
    }

    private static boolean checkUnCollapseFilter(CompositeFilterDescription compositeFilterDescription, DDiagramElement dDiagramElement) {
        EList filters = compositeFilterDescription.getFilters();
        boolean found = false;
        int i = 0;
        while (i < filters.size() && !found) {
            Filter filter = (Filter)filters.get(i);
            if (filter.getFilterKind().equals((Object)FilterKind.COLLAPSE_LITERAL)) {
                found = true;
                boolean visible = FilterService.isVisible((Filter)filter, (DDiagramElement)dDiagramElement);
                Assert.assertTrue((String)MessageFormat.format(Messages.elementNotCollapsedPropertly, dDiagramElement.getName()), (boolean)visible);
            }
            ++i;
        }
        return found;
    }

    public static FilterDescription applyFilterOnDiagram(final DDiagram diagram, String filterName) {
        final FilterDescription filterDescription = FilterOnDiagramHelper.getFilterDescription(diagram, filterName);
        Assert.assertNotNull((String)MessageFormat.format("Filter \"{0}\" can not be found for diagram \"{1}\"", filterName, EObjectExt.getText((EObject)diagram)), (Object)filterDescription);
        AbstractReadWriteCommand cmd = new AbstractReadWriteCommand(){

            public void run() {
                EList activatedFilters = diagram.getActivatedFilters();
                activatedFilters.add((Object)filterDescription);
                DialectManager.INSTANCE.refresh((DRepresentation)diagram, (IProgressMonitor)new NullProgressMonitor());
            }
        };
        TestHelper.getExecutionManager((EObject)diagram).execute((ICommand)cmd);
        return filterDescription;
    }

    public static FilterDescription getFilterDescription(DDiagram diagram, String filterName) {
        DiagramDescription description = diagram.getDescription();
        EList filters = description.getFilters();
        for (FilterDescription filterDescription : filters) {
            if (!filterDescription.getName().equalsIgnoreCase(filterName)) continue;
            return filterDescription;
        }
        return null;
    }

    public static void checkFilteredElementsInDiagram(DDiagram diagram, CompositeFilterDescription compositeFilterDescription) {
        Map<DiagramElementMapping, String> mappings = FilterOnDiagramHelper.getMappingsFromCompositeFilter(compositeFilterDescription);
        EList diagramElements = diagram.getDiagramElements();
        DisplayService displayService = DisplayServiceManager.INSTANCE.getDisplayService();
        String expression = null;
        for (DDiagramElement dDiagramElement : diagramElements) {
            if (!mappings.containsKey(dDiagramElement.getMapping()) || dDiagramElement.getTarget() == null) continue;
            expression = mappings.get(dDiagramElement.getMapping());
            if (FilterOnDiagramHelper.isValidExpressiontoEvaluate(expression)) {
                FilterOnDiagramHelper.handleCheckWithSemanticConditionOnDDiagramElement(diagram, compositeFilterDescription, displayService, expression, dDiagramElement);
                continue;
            }
            FilterOnDiagramHelper.handleCheckWithoutSemanticConditionExpression(diagram, compositeFilterDescription, displayService, dDiagramElement);
        }
    }

    private static Map<DiagramElementMapping, String> getMappingsFromCompositeFilter(CompositeFilterDescription compositeFilterDescription) {
        EList filters = compositeFilterDescription.getFilters();
        HashMap<DiagramElementMapping, String> mappings = new HashMap<DiagramElementMapping, String>();
        for (Filter filter : filters) {
            MappingFilter mp = (MappingFilter)filter;
            for (DiagramElementMapping aMapping : mp.getMappings()) {
                mappings.put(aMapping, mp.getSemanticConditionExpression());
            }
        }
        Assert.assertFalse((String)MessageFormat.format(Messages.mappingEmpty, compositeFilterDescription.getName()), (boolean)mappings.isEmpty());
        return mappings;
    }

    private static void handleCheckWithSemanticConditionOnDDiagramElement(DDiagram diagram, CompositeFilterDescription compositeFilterDescription, DisplayService displayService, String expression, DDiagramElement dDiagramElement) {
        InterpreterRegistry interpreterRegistry = SiriusPlugin.getDefault().getInterpreterRegistry();
        IInterpreter acceleoInterpreter = interpreterRegistry.getInterpreter(dDiagramElement.getTarget());
        try {
            if (!acceleoInterpreter.evaluateBoolean(dDiagramElement.getTarget(), expression)) {
                FilterOnDiagramHelper.additionalCheckOnDDiagramElementWithSemanticCondition(diagram, compositeFilterDescription, displayService, dDiagramElement);
            }
        }
        catch (EvaluationException exception_p) {
            System.err.println(exception_p.fillInStackTrace());
            Assert.assertTrue((String)MessageFormat.format(Messages.evaluationExceptionForExpression, expression), (boolean)false);
        }
    }

    private static void additionalCheckOnDDiagramElementWithSemanticCondition(DDiagram diagram, CompositeFilterDescription compositeFilterDescription, DisplayService displayService, DDiagramElement dDiagramElement) {
        boolean displayed = displayService.isDisplayed(diagram, dDiagramElement);
        if (displayed) {
            FilterOnDiagramHelper.checkCollapseFilter(compositeFilterDescription, dDiagramElement);
        } else {
            Assert.assertFalse((String)MessageFormat.format(Messages.elementNotHiddenPropertly, dDiagramElement.getName()), (boolean)displayed);
        }
    }

    private static void handleCheckWithoutSemanticConditionExpression(DDiagram diagram, CompositeFilterDescription compositeFilterDescription, DisplayService displayService, DDiagramElement dDiagramElement) {
        boolean displayed = displayService.isDisplayed(diagram, dDiagramElement);
        if (displayed) {
            FilterOnDiagramHelper.checkCollapseFilter(compositeFilterDescription, dDiagramElement);
        } else {
            Assert.assertFalse((String)MessageFormat.format(Messages.elementNotHiddenPropertly, dDiagramElement.getName()), (boolean)displayed);
        }
    }

    private static boolean isValidExpressiontoEvaluate(String expression) {
        return expression != null && !expression.trim().equals("");
    }

    private static void checkCollapseFilter(CompositeFilterDescription compositeFilterDescription, DDiagramElement dDiagramElement) {
        EList filters = compositeFilterDescription.getFilters();
        boolean found = false;
        int i = 0;
        while (i < filters.size() && !found) {
            Filter filter = (Filter)filters.get(i);
            if (filter.getFilterKind().equals((Object)FilterKind.COLLAPSE_LITERAL)) {
                found = true;
                boolean visible = FilterService.isVisible((Filter)filter, (DDiagramElement)dDiagramElement);
                Assert.assertFalse((String)MessageFormat.format(Messages.elementNotCollapsedPropertly, dDiagramElement.getName()), (boolean)visible);
            }
            ++i;
        }
    }

    public static FilterDescription removeFilterOnDiagram(final DDiagram diagram, String filterName) {
        final FilterDescription filterDescription = FilterOnDiagramHelper.getFilterDescription(diagram, filterName);
        Assert.assertNotNull((String)MessageFormat.format("Filter \"{0}\" can not be found for diagram \"{1}\"", filterName, EObjectExt.getText((EObject)diagram)), (Object)filterDescription);
        AbstractReadWriteCommand cmd = new AbstractReadWriteCommand(){

            public void run() {
                EList activatedFilters = diagram.getActivatedFilters();
                activatedFilters.remove((Object)filterDescription);
                DialectManager.INSTANCE.refresh((DRepresentation)diagram, (IProgressMonitor)new NullProgressMonitor());
            }
        };
        TestHelper.getExecutionManager((EObject)diagram).execute((ICommand)cmd);
        return filterDescription;
    }
}

