/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.common.ju.wrapper.utils;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.sirius.diagram.description.DescriptionPackage;
import org.eclipse.sirius.diagram.description.DiagramDescription;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.viewpoint.description.DescriptionPackage;
import org.eclipse.sirius.viewpoint.description.IdentifiedElement;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.eclipse.sirius.viewpoint.description.RepresentationElementMapping;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.test.framework.helpers.EObjectHelper;

public class ODesignHelper {
    public static final String ODESIGN_EXT = "odesign";

    public static List<Resource> getAvailableODesignFile(ResourceSet resourceSet) {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        for (Resource resource : resourceSet.getResources()) {
            if (!resource.getURI().toString().endsWith(ODESIGN_EXT)) continue;
            resources.add(resource);
        }
        return resources;
    }

    public static List<DiagramDescription> getAllDiagramDescription(List<Resource> resources) {
        ArrayList<DiagramDescription> result = new ArrayList<DiagramDescription>();
        for (Resource current : resources) {
            result.addAll(ODesignHelper.getAllDiagramDescription(current));
        }
        return result;
    }

    public static List<DiagramDescription> getAllDiagramDescription(Resource resource) {
        ArrayList<DiagramDescription> result = new ArrayList<DiagramDescription>();
        EObject root = (EObject)resource.getContents().get(0);
        EClass eClass = DescriptionPackage.Literals.DIAGRAM_DESCRIPTION;
        for (EObject current : EObjectHelper.getAllEObjectOfType((EObject)root, (EClass)eClass, (boolean)true)) {
            result.add((DiagramDescription)current);
        }
        return result;
    }

    public static String computeModelPath(RepresentationElementMapping mappingToolDescription) {
        StringBuilder sb = new StringBuilder(mappingToolDescription.getName());
        EObject container = mappingToolDescription.eContainer();
        while (container != null && container instanceof IdentifiedElement) {
            sb.insert(0, ((IdentifiedElement)container).getName() + "/");
            container = container.eContainer();
        }
        return sb.toString();
    }

    public static boolean isNotDeprecatedMapping(RepresentationElementMapping mapping) {
        if (mapping instanceof DiagramElementMapping && "false".equalsIgnoreCase(((DiagramElementMapping)mapping).getPreconditionExpression())) {
            return false;
        }
        if (mapping.getName().contains("Dummy")) {
            return false;
        }
        RepresentationDescription description = (RepresentationDescription)EcoreUtil2.getFirstContainer((EObject)mapping, (EClass)DescriptionPackage.Literals.REPRESENTATION_DESCRIPTION);
        return !(description instanceof DiagramDescription) || !"false".equalsIgnoreCase(((DiagramDescription)description).getPreconditionExpression());
    }
}

