/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.layout.ju.layout.compare;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.diffmerge.diffdata.EAttributeValuePresence;
import org.eclipse.emf.diffmerge.diffdata.impl.EComparisonImpl;
import org.eclipse.emf.diffmerge.generic.api.IDiffPolicy;
import org.eclipse.emf.diffmerge.generic.api.IMatchPolicy;
import org.eclipse.emf.diffmerge.generic.api.IMergePolicy;
import org.eclipse.emf.diffmerge.generic.api.Role;
import org.eclipse.emf.diffmerge.generic.api.diff.IAttributeValuePresence;
import org.eclipse.emf.diffmerge.generic.api.diff.IDifference;
import org.eclipse.emf.diffmerge.generic.api.scopes.IEditableTreeDataScope;
import org.eclipse.emf.diffmerge.generic.gdiffdata.GComparison;
import org.eclipse.emf.diffmerge.impl.policies.DefaultMergePolicy;
import org.eclipse.emf.diffmerge.impl.scopes.RootedModelScope;
import org.eclipse.emf.diffmerge.ui.util.DiffMergeDialog;
import org.eclipse.emf.diffmerge.ui.viewers.AbstractComparisonViewer;
import org.eclipse.emf.diffmerge.ui.viewers.ComparisonViewer;
import org.eclipse.emf.diffmerge.ui.viewers.EMFDiffNode;
import org.eclipse.emf.diffmerge.ui.viewers.HeaderViewer;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.Shape;
import org.eclipse.gmf.runtime.notation.ShapeStyle;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.common.tools.api.resource.ImageFileFormat;
import org.eclipse.sirius.diagram.AbstractDNode;
import org.eclipse.sirius.diagram.AppliedCompositeFilters;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.GraphicalFilter;
import org.eclipse.sirius.diagram.description.Layer;
import org.eclipse.sirius.diagram.description.filter.FilterDescription;
import org.eclipse.sirius.ui.tools.api.actions.export.ExportAction;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.junit.Assert;
import org.polarsys.capella.common.helpers.EObjectExt;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.common.ui.toolkit.viewers.menu.ModalContextMenuExtender;
import org.polarsys.capella.shared.id.handler.IdManager;
import org.polarsys.capella.test.diagram.common.ju.wrapper.utils.DiagramHelper;
import org.polarsys.capella.test.diagram.layout.ju.layout.DiagramLayout;
import org.polarsys.capella.test.diagram.layout.ju.layout.EdgeLayout;
import org.polarsys.capella.test.diagram.layout.ju.layout.ILayout;
import org.polarsys.capella.test.diagram.layout.ju.layout.ISemanticLayout;
import org.polarsys.capella.test.diagram.layout.ju.layout.LayoutFactory;
import org.polarsys.capella.test.diagram.layout.ju.layout.LayoutPackage;
import org.polarsys.capella.test.diagram.layout.ju.layout.Location;
import org.polarsys.capella.test.diagram.layout.ju.layout.NodeLayout;
import org.polarsys.capella.test.diagram.layout.ju.layout.NoteLayout;
import org.polarsys.capella.test.diagram.layout.ju.layout.SessionLayout;
import org.polarsys.capella.test.diagram.layout.ju.layout.Size;
import org.polarsys.capella.test.diagram.layout.ju.layout.compare.LayoutDiffPolicy;
import org.polarsys.capella.test.diagram.layout.ju.layout.compare.LayoutMatchPolicy;
import org.polarsys.capella.test.diagram.layout.ju.layout.compare.ShapeHelper;
import org.polarsys.capella.test.diagram.layout.ju.layout.compare.StyleHelper;
import org.polarsys.capella.test.diagram.layout.ju.layout.provider.LayoutItemProviderAdapterFactory;
import org.polarsys.capella.test.diagram.layout.ju.layout.util.LayoutAdapterFactory;
import org.polarsys.capella.test.diagram.layout.ju.layout.util.LayoutResourceImpl;

public class CompareLayoutManager {
    protected LayoutMatchPolicy matchPolicy;

    public DiagramLayout getCurrentLayout(Session session, DDiagram representation) {
        ISemanticLayout n;
        DiagramLayout layout = LayoutFactory.eINSTANCE.createDiagramLayout();
        DDiagram currentDiagram = representation;
        layout.setName(EObjectExt.getText((EObject)currentDiagram));
        layout.setId(IdManager.getInstance().getId(((DSemanticDecorator)currentDiagram).getTarget()));
        layout.setSynchronized(representation.isSynchronized());
        layout.setDescription(representation.getDescription().getName());
        IEditorPart editorWasOpened = DiagramHelper.getDiagramEditor((Session)session, (DDiagram)representation);
        if (editorWasOpened == null) {
            DiagramHelper.opendiagramEditor((Session)session, (DRepresentation)representation);
        } else {
            editorWasOpened.getSite().getPage().activate((IWorkbenchPart)editorWasOpened);
        }
        Diagram diag = DiagramHelper.getDiagram((DDiagram)currentDiagram);
        Point refPoint = ShapeHelper.getClosestPointToOriginInDiagram(currentDiagram);
        HashMap<EObject, ILayout> layouts = new HashMap<EObject, ILayout>();
        layouts.put((EObject)representation, layout);
        for (FilterDescription description : currentDiagram.getActivatedFilters()) {
            layout.getAppliedFilters().add((Object)description.getName());
        }
        for (Layer layer : currentDiagram.getActivatedLayers()) {
            layout.getAppliedLayers().add((Object)layer.getName());
        }
        for (DDiagramElement element : currentDiagram.getDiagramElements()) {
            if (!(element instanceof AbstractDNode)) continue;
            n = this.node(diag, refPoint, (AbstractDNode)element);
            layouts.put((EObject)element, n);
        }
        for (DDiagramElement element : currentDiagram.getDiagramElements()) {
            if (!(element instanceof DEdge)) continue;
            n = this.edge(diag, refPoint, (DEdge)element);
            layouts.put((EObject)element, n);
        }
        for (DDiagramElement element : currentDiagram.getDiagramElements()) {
            if (!(element instanceof AbstractDNode)) continue;
            this.addChildLayout((ILayout)layouts.get(element.eContainer()), (ILayout)layouts.get(element));
        }
        for (ShapeStyle currentNote : DiagramHelper.getDiagramNotes((DDiagram)currentDiagram)) {
            n = this.note(currentDiagram, refPoint, currentNote, layouts);
            this.addChildLayout(layouts.get(currentDiagram), n);
        }
        for (DDiagramElement element : currentDiagram.getDiagramElements()) {
            if (!(element instanceof DEdge)) continue;
            n = (EdgeLayout)layouts.get(element);
            n.setSource((ISemanticLayout)layouts.get(((DEdge)element).getSourceNode()));
            n.setTarget((ISemanticLayout)layouts.get(((DEdge)element).getTargetNode()));
            this.addChildLayout(layouts.get(element.eContainer()), n);
        }
        for (ShapeStyle currentNote : DiagramHelper.getDiagramNotes((DDiagram)currentDiagram)) {
            this.noteEdges(currentDiagram, refPoint, currentNote, layouts);
        }
        try {
            if (editorWasOpened != null) {
                DiagramHelper.closeEditor((Session)session, (DDiagram)currentDiagram);
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return layout;
    }

    private void addChildLayout(ILayout parent, ILayout n) {
        if (parent instanceof DiagramLayout) {
            ((DiagramLayout)parent).getOwnedLayouts().add((Object)n);
        } else if (parent instanceof NodeLayout) {
            ((NodeLayout)parent).getOwnedLayouts().add((Object)n);
        }
    }

    public SessionLayout getCurrentLayout(Session session) {
        SessionLayout sessionLayout = LayoutFactory.eINSTANCE.createSessionLayout();
        for (DRepresentation representation : DialectManager.INSTANCE.getAllRepresentations(session)) {
            if (!(representation instanceof DDiagram)) continue;
            DiagramLayout layout = this.getCurrentLayout(session, (DDiagram)representation);
            sessionLayout.getOwnedLayouts().add((Object)layout);
        }
        return sessionLayout;
    }

    public LayoutMatchPolicy getLayoutMatchPolicy() {
        if (this.matchPolicy == null) {
            this.matchPolicy = new LayoutMatchPolicy();
        }
        return this.matchPolicy;
    }

    public EComparisonImpl compare(SessionLayout layout1, SessionLayout layout2) {
        RootedModelScope source = new RootedModelScope(Collections.singletonList(layout1));
        RootedModelScope target = new RootedModelScope(Collections.singletonList(layout2));
        EComparisonImpl impl = new EComparisonImpl((IEditableTreeDataScope)target, (IEditableTreeDataScope)source);
        impl.compute((IMatchPolicy)this.getLayoutMatchPolicy(), (IDiffPolicy)new LayoutDiffPolicy(), (IMergePolicy)new DefaultMergePolicy(), (IProgressMonitor)new NullProgressMonitor());
        return impl;
    }

    public URI getLayoutUri(Session session) {
        return session.getSessionResource().getURI().appendFileExtension(Platform.getOS()).appendFileExtension("layout");
    }

    public SessionLayout getPersistedLayout(Session session) {
        Resource res = null;
        try {
            res = session.getTransactionalEditingDomain().getResourceSet().getResource(this.getLayoutUri(session), false);
            if ((res == null || res.getContents().isEmpty() || !(res.getContents().get(0) instanceof SessionLayout)) && res != null) {
                session.getTransactionalEditingDomain().getResourceSet().getResources().remove((Object)res);
            }
            if ((res = session.getTransactionalEditingDomain().getResourceSet().getResource(this.getLayoutUri(session), true)) == null || res.getContents().isEmpty() || !(res.getContents().get(0) instanceof SessionLayout)) {
                if (res != null) {
                    session.getTransactionalEditingDomain().getResourceSet().getResources().remove((Object)res);
                }
                return null;
            }
        }
        catch (RuntimeException e) {
            if (res != null) {
                session.getTransactionalEditingDomain().getResourceSet().getResources().remove((Object)res);
            }
            return null;
        }
        return (SessionLayout)res.getContents().get(0);
    }

    public void saveLayout(Session session, SessionLayout sessionLayout) {
        this.saveLayout(session, sessionLayout, this.getLayoutUri(session));
    }

    public void saveLayout(Session session, SessionLayout sessionLayout, URI uri) {
        try {
            LayoutResourceImpl resource = new LayoutResourceImpl(uri);
            resource.getContents().add((Object)sessionLayout);
            resource.save(new HashMap());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public NoteLayout note(DDiagram diagram, Point ref, ShapeStyle currentNote, HashMap<EObject, ILayout> layouts) {
        NoteLayout layout = LayoutFactory.eINSTANCE.createNoteLayout();
        String currentNoteDesc = currentNote.getDescription();
        layout.setId(currentNoteDesc);
        Location location = ShapeHelper.getDNoteLocation(diagram, currentNote, ref);
        Size size = ShapeHelper.getDNoteSize(diagram, currentNote);
        if (location != null || size != null) {
            layout.setBounds(LayoutFactory.eINSTANCE.createBounds());
        }
        if (location != null) {
            layout.getBounds().setRelative(location.isRelative());
            layout.getBounds().setX(location.getX());
            layout.getBounds().setY(location.getY());
        }
        if (size != null) {
            layout.getBounds().setWidth(size.getWidth());
            layout.getBounds().setHeight(size.getHeight());
        }
        this.addStyle(layout, StyleHelper.TEXT_ALIGNMENT, StyleHelper.getTextAlignment(currentNote));
        View noteView = null;
        noteView = currentNote instanceof Shape ? (View)currentNote : (View)currentNote.eContainer();
        layouts.put((EObject)noteView, layout);
        return layout;
    }

    public void noteEdges(DDiagram diagram, Point ref, ShapeStyle currentNote, HashMap<EObject, ILayout> layouts) {
        View noteView = null;
        noteView = currentNote instanceof Shape ? (View)currentNote : (View)currentNote.eContainer();
        ArrayList list = new ArrayList();
        list.addAll(noteView.getSourceEdges());
        list.addAll(noteView.getTargetEdges());
        for (Edge currentEdge : list) {
            EdgeLayout edgeLayout = LayoutFactory.eINSTANCE.createEdgeLayout();
            View source = currentEdge.getSource().getElement() instanceof DSemanticDecorator ? currentEdge.getSource().getElement() : currentEdge.getSource();
            View target = currentEdge.getTarget().getElement() instanceof DSemanticDecorator ? currentEdge.getTarget().getElement() : currentEdge.getTarget();
            this.addChildLayout(layouts.get(diagram), edgeLayout);
            edgeLayout.setSource((ISemanticLayout)layouts.get(source));
            edgeLayout.setTarget((ISemanticLayout)layouts.get(target));
            edgeLayout.getBendpoints().addAll(ShapeHelper.getDEdgePointsForNoteAttachment(diagram, currentEdge, ref));
        }
    }

    public NodeLayout node(Diagram diagram, Point ref, AbstractDNode anElement) {
        String elementName = "";
        if (anElement.getName() != null) {
            elementName = anElement.getName();
        }
        EObject target = anElement.getTarget();
        String id = IdManager.getInstance().getId(target);
        NodeLayout layout = LayoutFactory.eINSTANCE.createNodeLayout();
        layout.setId(id);
        layout.setName(elementName);
        layout.setActualMapping(anElement.getMapping().getName());
        layout.getAppliedFilters().addAll(this.getFilters((DDiagramElement)anElement));
        Location location = ShapeHelper.getDNodeLocation(diagram, (DDiagramElement)anElement, ref);
        Size size = ShapeHelper.getDNodeSize(diagram, anElement);
        if (location != null || size != null) {
            layout.setBounds(LayoutFactory.eINSTANCE.createBounds());
        }
        if (location != null) {
            layout.getBounds().setRelative(location.isRelative());
            layout.getBounds().setX(location.getX());
            layout.getBounds().setY(location.getY());
        }
        if (size != null) {
            layout.getBounds().setWidth(size.getWidth());
            layout.getBounds().setHeight(size.getHeight());
        }
        this.addStyle(layout, StyleHelper.BACKGROUND_COLOR, StyleHelper.getBackgroundColor(anElement));
        this.addStyle(layout, StyleHelper.FOREGROUND_COLOR, StyleHelper.getForegroundColor(anElement));
        this.addStyle(layout, StyleHelper.COLOR, StyleHelper.getColor(anElement));
        this.addStyle(layout, StyleHelper.BORDERED_COLOR, StyleHelper.getBorderedColor(anElement));
        return layout;
    }

    protected Collection<String> getFilters(DDiagramElement anElement) {
        ArrayList<String> filters = new ArrayList<String>();
        for (GraphicalFilter filter : anElement.getGraphicalFilters()) {
            if (filter instanceof AppliedCompositeFilters) {
                for (FilterDescription description : ((AppliedCompositeFilters)filter).getCompositeFilterDescriptions()) {
                    filters.add(description.getName());
                }
                continue;
            }
            filters.add(filter.getClass().getInterfaces()[0].getSimpleName());
        }
        return filters;
    }

    public EdgeLayout edge(Diagram diagram, Point ref, DEdge anElement) {
        String elementName = "";
        if (anElement.getName() != null) {
            elementName = anElement.getName();
        }
        EObject target = anElement.getTarget();
        String id = IdManager.getInstance().getId(target);
        EdgeLayout layout = LayoutFactory.eINSTANCE.createEdgeLayout();
        layout.setId(id);
        layout.setName(elementName);
        layout.setActualMapping(anElement.getMapping().getName());
        layout.getAppliedFilters().addAll(this.getFilters((DDiagramElement)anElement));
        this.addStyle(layout, StyleHelper.BEGIN_COLOR, StyleHelper.getBeginColor(anElement));
        this.addStyle(layout, StyleHelper.STROKE_COLOR, StyleHelper.getStrokeColor(anElement));
        this.addStyle(layout, StyleHelper.CENTERED_COLOR, StyleHelper.getCenteredColor(anElement));
        this.addStyle(layout, StyleHelper.END_COLOR, StyleHelper.getEndColor(anElement));
        this.addStyle(layout, "edgeRouting", StyleHelper.getRouting(anElement));
        layout.getBendpoints().addAll(ShapeHelper.getDEdgePoints(diagram, anElement, ref));
        return layout;
    }

    public void addStyle(ISemanticLayout layout, String key, String value) {
        if (value != null) {
            layout.getAppliedStyles().add((Object)(key + ": " + value));
        }
    }

    public void uiAnalysis(SessionLayout current, SessionLayout persisted) {
        EComparisonImpl comparison = this.compare(current, persisted);
        EMFDiffNode node = new EMFDiffNode((GComparison)comparison);
        DiffMergeDialog dialog = new DiffMergeDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), DiffMergeDialog.class.getSimpleName(), node){

            protected AbstractComparisonViewer createComparisonViewer(Composite parent_p) {
                return new ComparisonViewer(parent_p){

                    protected IWorkbenchPartSite getSite() {
                        return null;
                    }

                    protected ActionContributionItem createItemSyncExternal(IContributionManager context) {
                        return null;
                    }

                    protected MenuManager createViewerContextMenus(HeaderViewer<?> viewer, boolean useLocalSelectionProvider) {
                        MenuManager manager = super.createViewerContextMenus(viewer, useLocalSelectionProvider);
                        Viewer selectionProvider = useLocalSelectionProvider ? viewer.getInnerViewer() : this.getMultiViewerSelectionProvider();
                        ModalContextMenuExtender.registerContextMenu((MenuManager)manager, (String)"org.polarsys.capella.test.compareLayout.ui.diffmerge", (ISelectionProvider)selectionProvider);
                        return manager;
                    }
                };
            }
        };
        dialog.open();
    }

    public void analysis(SessionLayout current, SessionLayout persisted) {
        EComparisonImpl comparison = this.compare(current, persisted);
        Collection diffs = comparison.getDifferences(Role.REFERENCE);
        Collection diffs2 = comparison.getDifferences(Role.TARGET);
        ArrayList allDiffs = new ArrayList();
        allDiffs.addAll(diffs);
        allDiffs.addAll(diffs2);
        ArrayList<IDifference> allAttributeValueDiffs = new ArrayList<IDifference>();
        List<EClass> locations = Arrays.asList(LayoutPackage.Literals.BOUNDS, LayoutPackage.Literals.SIZE, LayoutPackage.Literals.LOCATION);
        for (IDifference difference : diffs) {
            if (!(difference instanceof IAttributeValuePresence)) continue;
            allAttributeValueDiffs.add(difference);
        }
        if (!allAttributeValueDiffs.isEmpty()) {
            HashMap<DiagramLayout, StringBuffer> buffers = new HashMap<DiagramLayout, StringBuffer>();
            StringBuffer result = new StringBuffer();
            result.append("There should not have layout modification\n");
            result.append(String.valueOf(ResourcesPlugin.getWorkspace().getRoot().getLocation()) + "\n");
            LayoutItemProviderAdapterFactory factory = new LayoutItemProviderAdapterFactory();
            for (IDifference difference : allAttributeValueDiffs) {
                if (!(difference instanceof EAttributeValuePresence)) continue;
                if (locations.contains(((EAttribute)((EAttributeValuePresence)difference).getFeature()).eContainer())) {
                    String sourceText;
                    EObject source = (EObject)((EAttributeValuePresence)difference).getElementMatch().get(Role.REFERENCE);
                    EObject target = (EObject)((EAttributeValuePresence)difference).getElementMatch().get(Role.TARGET);
                    DiagramLayout layout = (DiagramLayout)EcoreUtil2.getFirstContainer((EObject)source, (EClass)LayoutPackage.Literals.DIAGRAM_LAYOUT);
                    if (!buffers.containsKey(layout)) {
                        buffers.put(layout, new StringBuffer());
                    }
                    if (source.eContainer() instanceof NodeLayout) {
                        sourceText = this.getText(factory, source.eContainer());
                        String sourceBounds = this.getText(factory, source);
                        String targetBounds = this.getText(factory, target);
                        ((StringBuffer)buffers.get(layout)).append(NLS.bind((String)"[NodeLayout] {0}: {1} > {2}\n", (Object[])new String[]{sourceText, sourceBounds, targetBounds}));
                        continue;
                    }
                    if (source.eContainer() instanceof EdgeLayout) {
                        sourceText = this.getText(factory, source.eContainer());
                        String sourcePoints = this.toString(factory, (List<Location>)((EdgeLayout)source.eContainer()).getBendpoints());
                        String targetPoints = this.toString(factory, (List<Location>)((EdgeLayout)target.eContainer()).getBendpoints());
                        ((StringBuffer)buffers.get(layout)).append(NLS.bind((String)"[EdgeLayout] {0}: {1} > {2}\n", (Object[])new String[]{sourceText, sourcePoints, targetPoints}));
                        continue;
                    }
                    ((StringBuffer)buffers.get(layout)).append(NLS.bind((String)"[!NodeLayout|EdgeLayout] {0}, {1}, {2}\n", (Object[])new String[]{source.toString(), target.toString(), difference.toString()}));
                    continue;
                }
                result.append(NLS.bind((String)"[!BOUNDS|SIZE|LOCATION] {0}\n", (Object[])new String[]{difference.toString()}));
            }
            for (DiagramLayout layout : buffers.keySet()) {
                result.append("\n\n" + layout.getName() + "\n");
                result.append((StringBuffer)buffers.get(layout));
            }
            Assert.fail((String)result.toString());
        }
    }

    private String getText(LayoutAdapterFactory factory, EObject obj) {
        IItemLabelProvider provider = (IItemLabelProvider)factory.adapt((Notifier)obj, IItemLabelProvider.class);
        return provider.getText((Object)obj);
    }

    private String toString(LayoutAdapterFactory factory, List<Location> locations) {
        Object result = "";
        for (Location location : locations) {
            result = (String)result + this.getText(factory, location) + ";";
        }
        return result;
    }

    public void exportImages(Session session, IPath outputPath) {
        ArrayList toExport = new ArrayList(DialectManager.INSTANCE.getAllRepresentations(session));
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        ExportAction exportAction = new ExportAction(session, toExport, outputPath, ImageFileFormat.PNG, false, false);
        try (ProgressMonitorDialog pmd = new ProgressMonitorDialog(shell);){
            try {
                pmd.run(false, false, (IRunnableWithProgress)exportAction);
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
                pmd.close();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                pmd.close();
            }
        }
    }
}

