/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.layout.ju.testcases;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.gef.EditPart;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.ui.tools.internal.actions.layout.CopyFormatAction;
import org.eclipse.sirius.diagram.ui.tools.internal.actions.layout.PasteFormatAction;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.polarsys.capella.core.sirius.analysis.DiagramServices;
import org.polarsys.capella.test.diagram.common.ju.context.DiagramContext;
import org.polarsys.capella.test.diagram.common.ju.wrapper.utils.DiagramHelper;
import org.polarsys.capella.test.diagram.layout.ju.handlers.CompareLayoutHandler;
import org.polarsys.capella.test.diagram.layout.ju.model.ModelCopyLayout;
import org.polarsys.capella.test.framework.context.SessionContext;
import org.polarsys.capella.test.framework.helpers.GuiActions;

public class CopyPasteLayoutFunctionalChains
extends ModelCopyLayout {
    public static String SDFB1_SOURCE = "_fQuBoJAhEe2OYc1QJcaS8Q";
    public static String SDFB1_TARGET = "_FolqbpgLEe2ucetYitOqVw";
    public static String SAB_SDFB1_EXPECTED = "_V7sz4ZgIEe2ucetYitOqVw";
    public static String SDFB2_SOURCE = "_8fQRAJAkEe2OYc1QJcaS8Q";
    public static String SDFB2_TARGET = "_HwsmlJgLEe2ucetYitOqVw";
    public static String SAB_SDFB2_EXPECTED = "_fMvhUJgIEe2ucetYitOqVw";
    public static String SAB_SOURCE = "_FFU5gJAmEe2OYc1QJcaS8Q";
    public static String SAB_FC1 = "_DpU9qpjOEe2tE5fuNR9Q9g";
    public static String SAB_FC2 = "_2O3jy5jNEe2tE5fuNR9Q9g";
    public static String FC1_TARGET1 = "_tCtDcJAkEe2OYc1QJcaS8Q";
    public static String FC1_TARGET2 = "_9Srkp5jNEe2tE5fuNR9Q9g";
    public static String SDFB1_FC1_EXPECTED = "_uvGG2pgGEe2ucetYitOqVw";
    public static String FC2_SOURCE = "_lHY6EJAhEe2OYc1QJcaS8Q";
    public static String FC2_TARGET1 = "_HUJfKZjNEe2tE5fuNR9Q9g";
    public static String FC2_TARGET2 = "_JBPTG5jNEe2tE5fuNR9Q9g";
    public static String FC2_TARGET3 = "_0asQaZjNEe2tE5fuNR9Q9g";
    public static String CLONE_FC2_TARGET = "_6f7TwpgKEe2ucetYitOqVw";
    public static String FC2_FC2_CLONE_EXPECTED = "_CgV5MJgGEe2ucetYitOqVw";
    public static String SDFB1_FC2_EXPECTED = "_Nr4dOpjNEe2tE5fuNR9Q9g";
    public static String FC1_FC2_EXPECTED = "_nkwAAJgGEe2ucetYitOqVw";
    public static String FC3_SOURCE = "_AJPPcJAlEe2OYc1QJcaS8Q";
    public static String LFC3 = "_6MCw4JAnEe2OYc1QJcaS8Q";
    public static String FC3_CLONE_TARGET = "_0uwmYJgKEe2ucetYitOqVw";
    public static String FC3_FC3_CLONE_EXPECTED = "_TyNpoJgGEe2ucetYitOqVw";
    public static String FC3_LFC3_EXPECTED = "_sFofbpgIEe2ucetYitOqVw";
    public static String PP1 = "_Tr_eEJjQEe299sGa9inWTA";
    public static String PP2 = "_Yhz9gJjQEe299sGa9inWTA";
    public static String PP1_PP2_EXPECTED = "_rOvWsJjQEe299sGa9inWTA";
    public static String PAB1 = "_BaakIJjQEe299sGa9inWTA";
    public static String PAB2 = "_agvvYJjQEe299sGa9inWTA";
    public static String PAB1_PAB2_EXPECTED = "_h8B1cZjQEe299sGa9inWTA";
    public static String FC3_FC4_EXPECTED = "_wzY8ipx9Ee2Qeqzp7wDG4g";
    public static String FC4 = "_upl-YJx9Ee2Qeqzp7wDG4g";
    public static String FC4_TARGET = "_EFkXwJx-Ee2Qeqzp7wDG4g";
    public static String SAB_LAB_EXPECTED = "_3X1DYZyJEe2Qeqzp7wDG4g";
    public static String LAB = "_nBbdsJx-Ee2Qeqzp7wDG4g";
    public static String LAB_TARGET = "_17-JYJyJEe2Qeqzp7wDG4g";
    public static String COPY_FC3_TARGET = "_iWlU0JyiEe2YDZvvaEnOfA";
    public static String FC3_COPY_FC3_EXPECTED = "_m-8nEJyiEe2YDZvvaEnOfA";
    public static final String FCI_TO_SYSTEMFUNCTION_3 = "8fb284c2-3d07-4bb4-a4a5-ffbe7b0f3885";
    public static final String FUNCTIONAL_CHAIN_REFERENCE_TOP_FUNCTIONALCHAIN_1 = "5efc59e2-e5ec-4cb2-a1e5-a9118e083537";
    public static final String FCI_TO_SYSTEMFUNCTION_4 = "3600e7d2-0a33-4c00-8f0d-18849e1cc48c";
    public static final String FUNCTIONAL_CHAIN_REFERENCE_BOTTOM_FUNCTIONALCHAIN_1 = "bd1a3136-5be3-432b-8114-953bd2370440";
    public static final String FCI_TO_SYSTEMFUNCTION_5 = "403f9a86-341e-4d01-857a-3001528febbe";
    public static final String FCI_TO_SYSTEMFUNCTION_6 = "b77c1ac1-b3f9-404a-8a00-a1a48b79e99f";
    public static final String FCI_TO_SYSTEMFUNCTION_7 = "f9b22004-a5c7-4ac6-ac2b-f530f58a3d52";
    public static final String FCI_TO_SYSTEMFUNCTION_8 = "f119ac19-1886-47df-9a7d-fa47ef63960a";
    public static final String FCI_TO_SYSTEMFUNCTION_52 = "681b7f82-ece1-4faa-9837-0a44647708a8";
    public static final String FCI_TO_SYSTEMFUNCTION_9 = "e859eeba-8668-4456-862d-d141c23be9b5";
    public static final String LFCI_TO_SYSTEMFUNCTION_5 = "345742d9-2742-43e8-8fb3-4da07a6fb615";
    public static final String LFCI_TO_SYSTEMFUNCTION_6 = "8734099b-e894-416a-8045-989bf3fb4eb9";
    public static final String LFCI_TO_SYSTEMFUNCTION_7 = "19a793c9-f311-491d-853e-e47d69a8f0c7";
    public static final String LFCI_TO_SYSTEMFUNCTION_8 = "2107a4be-d82d-4d8d-ae2c-9a520cc70e28";
    public static final String LFCI_TO_SYSTEMFUNCTION_52 = "c7e808cf-49cc-4dbe-85c9-f273429aab53";
    public static final String LFCI_TO_SYSTEMFUNCTION_9 = "13140f28-c321-4cfd-b669-458002b1152a";

    public void test() throws Exception {
        DiagramHelper.setPreferenceAutoRefresh((boolean)true);
        DiagramHelper.setPrefereneRefreshOnOpening((boolean)true);
        DiagramHelper.setPreferenceCopyLayoutPrompt((boolean)false);
        DiagramHelper.setPreferenceCopyLayoutMode((boolean)false);
        Session session = this.getSessionForTestModel(this.getRequiredTestModels().get(0));
        SessionContext context = new SessionContext(session);
        this.checkFC3toFC4(context);
        this.checkSABtoLAB(context);
        this.checkFC1toFC2(context);
        this.checkSDFB1toFC2(context);
        this.checkSABtoSDFB1(context);
        this.checkSABtoSDFB2(context);
        this.checkSABtoFC1(context);
        this.checkSABtoFC2(context);
        this.checkFC3toLFC3(context);
        this.checkPP1toPP2(context);
        this.checkPAB1toPAB2(context);
        DiagramHelper.setPreferenceCopyLayoutMode((boolean)true);
        this.checkFC2toFC2Clone(context);
        this.checkFC3toCopyFC3(context);
        this.checkFC3toFC3Clone(context);
        this.checkSDFB1toFC1(context);
    }

    protected void checkFC2toFC2Clone(SessionContext context) {
        CompareLayoutHandler handler = new CompareLayoutHandler();
        this.copyLayout(context, FC2_SOURCE, FCI_TO_SYSTEMFUNCTION_3, FUNCTIONAL_CHAIN_REFERENCE_TOP_FUNCTIONALCHAIN_1, FCI_TO_SYSTEMFUNCTION_4);
        this.pasteLayout(context, CLONE_FC2_TARGET, FCI_TO_SYSTEMFUNCTION_3, FUNCTIONAL_CHAIN_REFERENCE_TOP_FUNCTIONALCHAIN_1, FCI_TO_SYSTEMFUNCTION_4);
        this.copyLayout(context, FC2_SOURCE, FCI_TO_SYSTEMFUNCTION_3, FUNCTIONAL_CHAIN_REFERENCE_BOTTOM_FUNCTIONALCHAIN_1, FCI_TO_SYSTEMFUNCTION_4);
        this.pasteLayout(context, CLONE_FC2_TARGET, FCI_TO_SYSTEMFUNCTION_3, FUNCTIONAL_CHAIN_REFERENCE_BOTTOM_FUNCTIONALCHAIN_1, FCI_TO_SYSTEMFUNCTION_4);
        handler.compare(DiagramContext.getDiagram((SessionContext)context, (String)CLONE_FC2_TARGET).getDiagramDescriptor(), DiagramContext.getDiagram((SessionContext)context, (String)FC2_FC2_CLONE_EXPECTED).getDiagramDescriptor(), false);
    }

    protected void checkFC3toCopyFC3(SessionContext context) {
        CompareLayoutHandler handler = new CompareLayoutHandler();
        DiagramContext source = DiagramContext.getDiagram((SessionContext)context, (String)FC3_SOURCE);
        DiagramContext target = DiagramContext.getDiagram((SessionContext)context, (String)COPY_FC3_TARGET);
        handler.copyPasteLayout(source.getDiagramDescriptor(), target.getDiagramDescriptor());
        target.refreshDiagram();
        handler.compare(DiagramContext.getDiagram((SessionContext)context, (String)COPY_FC3_TARGET).getDiagramDescriptor(), DiagramContext.getDiagram((SessionContext)context, (String)FC3_COPY_FC3_EXPECTED).getDiagramDescriptor(), false);
    }

    protected void checkFC3toFC4(SessionContext context) {
        CompareLayoutHandler handler = new CompareLayoutHandler();
        DiagramContext source = DiagramContext.getDiagram((SessionContext)context, (String)FC3_SOURCE);
        DiagramContext target = DiagramContext.getDiagram((SessionContext)context, (String)FC4_TARGET);
        handler.copyPasteLayout(source.getDiagramDescriptor(), target.getDiagramDescriptor());
        handler.compare(DiagramContext.getDiagram((SessionContext)context, (String)FC4_TARGET).getDiagramDescriptor(), DiagramContext.getDiagram((SessionContext)context, (String)FC3_FC4_EXPECTED).getDiagramDescriptor(), false);
    }

    protected void checkSABtoLAB(SessionContext context) {
        CompareLayoutHandler handler = new CompareLayoutHandler();
        DiagramContext source = DiagramContext.getDiagram((SessionContext)context, (String)SAB_SOURCE);
        DiagramContext target = DiagramContext.getDiagram((SessionContext)context, (String)LAB_TARGET);
        handler.copyPasteLayout(source.getDiagramDescriptor(), target.getDiagramDescriptor());
        target.refreshDiagram();
        handler.compare(DiagramContext.getDiagram((SessionContext)context, (String)LAB_TARGET).getDiagramDescriptor(), DiagramContext.getDiagram((SessionContext)context, (String)SAB_LAB_EXPECTED).getDiagramDescriptor(), false);
    }

    protected void checkFC1toFC2(SessionContext context) {
        CompareLayoutHandler handler = new CompareLayoutHandler();
        DiagramContext source = DiagramContext.getDiagram((SessionContext)context, (String)FC1_TARGET1);
        DiagramContext target = DiagramContext.getDiagram((SessionContext)context, (String)FC2_TARGET1);
        handler.copyPasteLayout(source.getDiagramDescriptor(), target.getDiagramDescriptor());
        handler.compare(DiagramContext.getDiagram((SessionContext)context, (String)FC2_TARGET1).getDiagramDescriptor(), DiagramContext.getDiagram((SessionContext)context, (String)FC1_FC2_EXPECTED).getDiagramDescriptor(), false);
    }

    protected void checkFC3toFC3Clone(SessionContext context) {
        CompareLayoutHandler handler = new CompareLayoutHandler();
        this.copyLayout(context, FC3_SOURCE, FCI_TO_SYSTEMFUNCTION_5, FCI_TO_SYSTEMFUNCTION_6, FCI_TO_SYSTEMFUNCTION_7);
        this.pasteLayout(context, FC3_CLONE_TARGET, FCI_TO_SYSTEMFUNCTION_5, FCI_TO_SYSTEMFUNCTION_6, FCI_TO_SYSTEMFUNCTION_7);
        this.copyLayout(context, FC3_SOURCE, FCI_TO_SYSTEMFUNCTION_8, FCI_TO_SYSTEMFUNCTION_52, FCI_TO_SYSTEMFUNCTION_9);
        this.pasteLayout(context, FC3_CLONE_TARGET, FCI_TO_SYSTEMFUNCTION_8, FCI_TO_SYSTEMFUNCTION_52, FCI_TO_SYSTEMFUNCTION_9);
        handler.compare(DiagramContext.getDiagram((SessionContext)context, (String)FC3_CLONE_TARGET).getDiagramDescriptor(), DiagramContext.getDiagram((SessionContext)context, (String)FC3_FC3_CLONE_EXPECTED).getDiagramDescriptor(), false);
    }

    protected void checkSDFB1toFC1(SessionContext context) {
        CompareLayoutHandler handler = new CompareLayoutHandler();
        DiagramContext source = DiagramContext.getDiagram((SessionContext)context, (String)SDFB1_SOURCE);
        DiagramContext target = DiagramContext.getDiagram((SessionContext)context, (String)FC1_TARGET1);
        handler.copyPasteLayout(source.getDiagramDescriptor(), target.getDiagramDescriptor());
        target.refreshDiagram();
        handler.compare(DiagramContext.getDiagram((SessionContext)context, (String)FC1_TARGET1).getDiagramDescriptor(), DiagramContext.getDiagram((SessionContext)context, (String)SDFB1_FC1_EXPECTED).getDiagramDescriptor(), false);
    }

    protected void checkSDFB1toFC2(SessionContext context) {
        CompareLayoutHandler handler = new CompareLayoutHandler();
        DiagramContext source = DiagramContext.getDiagram((SessionContext)context, (String)SDFB1_SOURCE);
        DiagramContext target = DiagramContext.getDiagram((SessionContext)context, (String)FC2_TARGET2);
        handler.copyPasteLayout(source.getDiagramDescriptor(), target.getDiagramDescriptor());
        target.refreshDiagram();
        handler.compare(DiagramContext.getDiagram((SessionContext)context, (String)FC2_TARGET2).getDiagramDescriptor(), DiagramContext.getDiagram((SessionContext)context, (String)SDFB1_FC2_EXPECTED).getDiagramDescriptor(), false);
    }

    protected void checkSABtoSDFB1(SessionContext context) {
        CompareLayoutHandler handler = new CompareLayoutHandler();
        DiagramContext source = DiagramContext.getDiagram((SessionContext)context, (String)SAB_SOURCE);
        DiagramContext target = DiagramContext.getDiagram((SessionContext)context, (String)SDFB1_TARGET);
        handler.copyPasteLayout(source.getDiagramDescriptor(), target.getDiagramDescriptor());
        target.refreshDiagram();
        handler.compare(DiagramContext.getDiagram((SessionContext)context, (String)SDFB1_TARGET).getDiagramDescriptor(), DiagramContext.getDiagram((SessionContext)context, (String)SAB_SDFB1_EXPECTED).getDiagramDescriptor(), false);
    }

    protected void checkSABtoSDFB2(SessionContext context) {
        CompareLayoutHandler handler = new CompareLayoutHandler();
        DiagramContext source = DiagramContext.getDiagram((SessionContext)context, (String)SAB_SOURCE);
        DiagramContext target = DiagramContext.getDiagram((SessionContext)context, (String)SDFB2_TARGET);
        handler.copyPasteLayout(source.getDiagramDescriptor(), target.getDiagramDescriptor());
        target.refreshDiagram();
        handler.compare(DiagramContext.getDiagram((SessionContext)context, (String)SDFB2_TARGET).getDiagramDescriptor(), DiagramContext.getDiagram((SessionContext)context, (String)SAB_SDFB2_EXPECTED).getDiagramDescriptor(), false);
    }

    protected void checkFC3toLFC3(SessionContext context) {
        CompareLayoutHandler handler = new CompareLayoutHandler();
        this.copyLayout(context, FC3_SOURCE, FCI_TO_SYSTEMFUNCTION_5, FCI_TO_SYSTEMFUNCTION_6, FCI_TO_SYSTEMFUNCTION_7);
        this.pasteLayout(context, LFC3, LFCI_TO_SYSTEMFUNCTION_5, LFCI_TO_SYSTEMFUNCTION_6, LFCI_TO_SYSTEMFUNCTION_7);
        this.copyLayout(context, FC3_SOURCE, FCI_TO_SYSTEMFUNCTION_8, FCI_TO_SYSTEMFUNCTION_52, FCI_TO_SYSTEMFUNCTION_9);
        this.pasteLayout(context, LFC3, LFCI_TO_SYSTEMFUNCTION_8, LFCI_TO_SYSTEMFUNCTION_52, LFCI_TO_SYSTEMFUNCTION_9);
        handler.compare(DiagramContext.getDiagram((SessionContext)context, (String)LFC3).getDiagramDescriptor(), DiagramContext.getDiagram((SessionContext)context, (String)FC3_LFC3_EXPECTED).getDiagramDescriptor(), false);
    }

    protected void checkSABtoFC1(SessionContext context) {
        CompareLayoutHandler handler = new CompareLayoutHandler();
        DiagramContext source = DiagramContext.getDiagram((SessionContext)context, (String)SAB_SOURCE);
        DiagramContext target = DiagramContext.getDiagram((SessionContext)context, (String)FC1_TARGET2);
        handler.copyPasteLayout(source.getDiagramDescriptor(), target.getDiagramDescriptor());
        target.refreshDiagram();
        handler.compare(DiagramContext.getDiagram((SessionContext)context, (String)FC1_TARGET2).getDiagramDescriptor(), DiagramContext.getDiagram((SessionContext)context, (String)SAB_FC1).getDiagramDescriptor(), false);
    }

    protected void checkSABtoFC2(SessionContext context) {
        CompareLayoutHandler handler = new CompareLayoutHandler();
        DiagramContext source = DiagramContext.getDiagram((SessionContext)context, (String)SAB_SOURCE);
        DiagramContext target = DiagramContext.getDiagram((SessionContext)context, (String)FC2_TARGET3);
        handler.copyPasteLayout(source.getDiagramDescriptor(), target.getDiagramDescriptor());
        target.refreshDiagram();
        handler.compare(DiagramContext.getDiagram((SessionContext)context, (String)FC2_TARGET3).getDiagramDescriptor(), DiagramContext.getDiagram((SessionContext)context, (String)SAB_FC2).getDiagramDescriptor(), false);
    }

    protected void checkPP1toPP2(SessionContext context) {
        CompareLayoutHandler handler = new CompareLayoutHandler();
        DiagramContext source = DiagramContext.getDiagram((SessionContext)context, (String)PP1);
        DiagramContext target = DiagramContext.getDiagram((SessionContext)context, (String)PP2);
        handler.copyPasteLayout(source.getDiagramDescriptor(), target.getDiagramDescriptor());
        target.refreshDiagram();
        handler.compare(DiagramContext.getDiagram((SessionContext)context, (String)PP2).getDiagramDescriptor(), DiagramContext.getDiagram((SessionContext)context, (String)PP1_PP2_EXPECTED).getDiagramDescriptor(), false);
    }

    protected void checkPAB1toPAB2(SessionContext context) {
        CompareLayoutHandler handler = new CompareLayoutHandler();
        DiagramContext source = DiagramContext.getDiagram((SessionContext)context, (String)PAB1);
        DiagramContext target = DiagramContext.getDiagram((SessionContext)context, (String)PAB2);
        handler.copyPasteLayout(source.getDiagramDescriptor(), target.getDiagramDescriptor());
        target.refreshDiagram();
        handler.compare(DiagramContext.getDiagram((SessionContext)context, (String)PAB2).getDiagramDescriptor(), DiagramContext.getDiagram((SessionContext)context, (String)PAB1_PAB2_EXPECTED).getDiagramDescriptor(), false);
    }

    public void copyLayout(SessionContext sessionContext, String diagramName, String ... ids) {
        DiagramContext sourceContext = DiagramContext.getDiagram((SessionContext)sessionContext, (String)diagramName);
        DDiagram sourceDiagram = sourceContext.getDiagram();
        sourceContext.open();
        Session session = SessionManager.INSTANCE.getSession(((DSemanticDecorator)sourceDiagram).getTarget());
        IEditorPart part = DiagramHelper.getDiagramEditor((Session)session, (DDiagram)sourceDiagram);
        ArrayList<EditPart> editPartsToBeSelected = new ArrayList<EditPart>();
        String[] stringArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            EditPart editPart;
            String id = stringArray[n2];
            DDiagramElement diagramElement = DiagramHelper.getOnDiagramByID((DDiagram)sourceDiagram, (String)id);
            if (diagramElement != null && (editPart = DiagramServices.getDiagramServices().getEditPart(diagramElement)) != null) {
                editPartsToBeSelected.add(editPart);
            }
            ++n2;
        }
        StructuredSelection selection = new StructuredSelection(editPartsToBeSelected);
        part.getSite().getSelectionProvider().setSelection((ISelection)selection);
        CopyFormatAction copyAction = new CopyFormatAction(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IWorkbenchPart)part);
        copyAction.init();
        copyAction.run();
        part.getSite().getSelectionProvider().setSelection((ISelection)new StructuredSelection());
        GuiActions.flushASyncGuiThread();
    }

    public void pasteLayout(SessionContext sessionContext, String diagramName, String ... ids) {
        DiagramContext targetContext = DiagramContext.getDiagram((SessionContext)sessionContext, (String)diagramName);
        DDiagram targetDiagram = targetContext.getDiagram();
        targetContext.open();
        Session session = SessionManager.INSTANCE.getSession(((DSemanticDecorator)targetDiagram).getTarget());
        IEditorPart part = DiagramHelper.getDiagramEditor((Session)session, (DDiagram)targetDiagram);
        ArrayList<EditPart> editPartsToBeSelected = new ArrayList<EditPart>();
        String[] stringArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            EditPart editPart;
            String id = stringArray[n2];
            DDiagramElement diagramElement = DiagramHelper.getOnDiagramByID((DDiagram)targetDiagram, (String)id);
            if (diagramElement != null && (editPart = DiagramServices.getDiagramServices().getEditPart(diagramElement)) != null) {
                editPartsToBeSelected.add(editPart);
            }
            ++n2;
        }
        StructuredSelection selection = new StructuredSelection(editPartsToBeSelected);
        part.getSite().getSelectionProvider().setSelection((ISelection)selection);
        PasteFormatAction pasteAction = new PasteFormatAction(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IWorkbenchPart)part);
        pasteAction.init();
        pasteAction.run();
        part.getSite().getSelectionProvider().setSelection((ISelection)new StructuredSelection());
        GuiActions.flushASyncGuiThread();
    }

    @Override
    public List<String> getRequiredTestModels() {
        return Arrays.asList("FC");
    }
}

