/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.misc.ju.testcases;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.sirius.analysis.DiagramServices;
import org.polarsys.capella.test.framework.api.BasicTestCase;

public class BreakdownDiagramElements
extends BasicTestCase {
    private static final String PROJECT_NAME = "component-breakdown";
    private Map<String, ExpectedResult> controlData;

    public List<String> getRequiredTestModels() {
        return Arrays.asList(PROJECT_NAME);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.controlData = this.getControlData();
    }

    protected Map<String, ExpectedResult> getControlData() {
        HashMap<String, ExpectedResult> data = new HashMap<String, ExpectedResult>();
        data.put("[OEBD] Root", new ExpectedResult(8, false, false));
        data.put("[OEBD] OE 1", new ExpectedResult(7, true, false));
        data.put("[LCBD] Structure", new ExpectedResult(10, false, true));
        data.put("[LCBD] Logical System", new ExpectedResult(5, false, false));
        data.put("[LCBD] LC 6", new ExpectedResult(1, true, false));
        data.put("[PCBD] Structure", new ExpectedResult(10, false, true));
        data.put("[PCBD] Physical System", new ExpectedResult(3, false, false));
        data.put("[PCBD] PC 1", new ExpectedResult(3, true, false));
        return data;
    }

    public void test() throws Exception {
        Session session = this.getSession(PROJECT_NAME);
        BreakdownDiagramElements.assertNotNull((Object)session);
        Collection representationDescriptors = DialectManager.INSTANCE.getAllRepresentationDescriptors(session);
        for (DRepresentationDescriptor descriptor : representationDescriptors) {
            DRepresentation representation;
            String name = descriptor.getName();
            ExpectedResult expectedResult = this.controlData.get(name);
            if (expectedResult == null || !((representation = descriptor.getRepresentation()) instanceof DSemanticDiagram)) continue;
            DSemanticDiagram diagram = (DSemanticDiagram)representation;
            BreakdownDiagramElements.assertEquals((String)(name + " contains a wrong number of elements"), (int)expectedResult.nbOfExpectedElements, (int)diagram.getDiagramElements().size());
            EObject diagramTarget = diagram.getTarget();
            DDiagramElement diagramElementElement = DiagramServices.getDiagramServices().getDiagramElement((DDiagram)diagram, diagramTarget);
            BreakdownDiagramElements.assertEquals((String)(name + " contains an error regarding the target element"), (boolean)expectedResult.containsTarget, (diagramElementElement != null ? 1 : 0) != 0);
            BlockArchitecture rootBlockArchitecture = BlockArchitectureExt.getRootBlockArchitecture((EObject)diagramTarget);
            Component system = rootBlockArchitecture.getSystem();
            if (system == null) continue;
            DDiagramElement systemElement = DiagramServices.getDiagramServices().getDiagramElement((DDiagram)diagram, (EObject)system);
            BreakdownDiagramElements.assertEquals((String)(name + " contains an error regarding the system element"), (boolean)expectedResult.containsSystem, (systemElement != null ? 1 : 0) != 0);
        }
    }

    private class ExpectedResult {
        int nbOfExpectedElements;
        boolean containsTarget;
        boolean containsSystem;

        public ExpectedResult(int nbOfExpectedElements, boolean containsTarget, boolean containsSystem) {
            this.nbOfExpectedElements = nbOfExpectedElements;
            this.containsTarget = containsTarget;
            this.containsSystem = containsSystem;
        }
    }
}

