/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.misc.ju.testcases;

import java.util.Arrays;
import java.util.List;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.LineStyle;
import org.eclipse.sirius.diagram.NodeStyle;
import org.polarsys.capella.test.diagram.common.ju.context.DiagramContext;
import org.polarsys.capella.test.diagram.common.ju.step.crud.OpenDiagramStep;
import org.polarsys.capella.test.framework.api.BasicTestCase;
import org.polarsys.capella.test.framework.context.SessionContext;

public class Bug2145TestCase
extends BasicTestCase {
    private String LAB__LC2__LF2 = "40d6033f-e751-4101-a195-bae2c91e0da2";
    private String PAB__PC2__LF1 = "23e61aa6-b59f-4eee-aa57-a194ec92f2e1";
    private String LAB3__LOGICALSYSTEM__LF3 = "f4235f74-9c07-408e-97cb-37d64da94713";
    private String LAB3__LOGICALSYSTEM__LF4 = "f8b8b6ef-cb6e-4253-b6ec-adef276421e8";
    private String pABDiagramName = "[PAB] 1";
    private String lABDiagramName = "[LAB] 2";
    private String lAB3DiagramName = "[LAB] 3";
    private String projectTestName = "DashFunctionBug";

    public List<String> getRequiredTestModels() {
        return Arrays.asList(this.projectTestName);
    }

    public void test() throws Exception {
        Session session = this.getSession(this.projectTestName);
        Bug2145TestCase.assertNotNull((Object)session);
        SessionContext context = new SessionContext(session);
        DiagramContext lABdiagramContext = (DiagramContext)new OpenDiagramStep(context, this.lABDiagramName).run();
        DNode lF2View = (DNode)lABdiagramContext.getView(this.LAB__LC2__LF2);
        Bug2145TestCase.assertTrue((String)"LF2 should not be dashed", (this.getBorderLineStyle(lF2View) == 0 ? 1 : 0) != 0);
        DiagramContext lAB3diagramContext = (DiagramContext)new OpenDiagramStep(context, this.lAB3DiagramName).run();
        DNode lF3View = (DNode)lAB3diagramContext.getView(this.LAB3__LOGICALSYSTEM__LF3);
        Bug2145TestCase.assertTrue((String)"LF3 border should be dashed", (this.getBorderLineStyle(lF3View) == 1 ? 1 : 0) != 0);
        DNode lF4View = (DNode)lAB3diagramContext.getView(this.LAB3__LOGICALSYSTEM__LF4);
        Bug2145TestCase.assertTrue((String)"LF4 border should be solid", (this.getBorderLineStyle(lF4View) == 0 ? 1 : 0) != 0);
        DiagramContext pABdiagramContext = (DiagramContext)new OpenDiagramStep(context, this.pABDiagramName).run();
        DNode lF1View = (DNode)pABdiagramContext.getView(this.PAB__PC2__LF1);
        Bug2145TestCase.assertTrue((String)"LF1 should not be dashed", (this.getBorderLineStyle(lF1View) == 0 ? 1 : 0) != 0);
    }

    private int getBorderLineStyle(DNode node) {
        NodeStyle ownedStyle = node.getOwnedStyle();
        LineStyle borderLineStyle = ownedStyle.getBorderLineStyle();
        return borderLineStyle.getValue();
    }
}

