/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.misc.ju.testcases;

import java.util.Arrays;
import java.util.List;
import org.eclipse.sirius.business.api.session.Session;
import org.polarsys.capella.core.common.ui.wizards.LCDecompositionController;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.la.LogicalComponent;
import org.polarsys.capella.core.data.la.LogicalComponentPkg;
import org.polarsys.capella.test.diagram.common.ju.context.XABDiagram;
import org.polarsys.capella.test.framework.api.BasicTestCase;
import org.polarsys.capella.test.framework.context.SessionContext;
import org.polarsys.capella.test.framework.helpers.SkeletonHelper;

public class DecompositionWizardTestCase
extends BasicTestCase {
    private static final String PROJECT_NAME = "component-breakdown";

    public List<String> getRequiredTestModels() {
        return Arrays.asList(PROJECT_NAME);
    }

    public void test() throws Exception {
        Session session = this.getSession(PROJECT_NAME);
        DecompositionWizardTestCase.assertNotNull((Object)session);
        String systemId = "2a3acffb-da23-4caf-a526-96887c94d447";
        SessionContext context = new SessionContext(session);
        XABDiagram diagram = XABDiagram.createDiagram((SessionContext)context, (String)systemId);
        String idAct_01 = diagram.createActor("LA 00_01", diagram.getDiagramId());
        String idAct_02 = diagram.createActor("LA 00_02", diagram.getDiagramId());
        String idCmp_01 = diagram.createComponent("LC 00_01", diagram.getDiagramId());
        String idCmp_12 = diagram.createComponent("LC 01_02", idCmp_01);
        String idAct_13 = diagram.createActor("LA 01_03", diagram.getDiagramId());
        Part prtAct_01 = (Part)context.getSemanticElement(idAct_01);
        LogicalComponent logAct_01 = (LogicalComponent)prtAct_01.getAbstractType();
        Part prtAct_02 = (Part)context.getSemanticElement(idAct_02);
        LogicalComponent logAct_02 = (LogicalComponent)prtAct_02.getAbstractType();
        Part prtCmp_01 = (Part)context.getSemanticElement(idCmp_01);
        LogicalComponent logCmp_01 = (LogicalComponent)prtCmp_01.getAbstractType();
        Part prtCmp_11 = (Part)context.getSemanticElement(idCmp_12);
        LogicalComponent logCmp_11 = (LogicalComponent)prtCmp_11.getAbstractType();
        this.checkIsDecomposable(logAct_01, 0);
        this.checkIsDecomposable(logAct_02, 0);
        this.checkIsDecomposable(logCmp_01, 1);
        this.checkIsDecomposable(logCmp_11, 0);
        SkeletonHelper.createComponentPkg((String)logAct_01.getId(), (String)"LogCompPkg_00_03", (SessionContext)context);
        LogicalComponentPkg objPkg_03 = (LogicalComponentPkg)context.getSemanticElement("LogCompPkg_00_03");
        SkeletonHelper.moveObject((String)idAct_02, (String)objPkg_03.getId(), (SessionContext)context);
        SkeletonHelper.moveObject((String)idAct_13, (String)objPkg_03.getId(), (SessionContext)context);
        this.checkIsDecomposable(logAct_01, 2);
    }

    protected void checkIsDecomposable(LogicalComponent logicalComp, int numComponents) {
        LCDecompositionController controller = new LCDecompositionController();
        controller.createDecompositionModel(logicalComp);
        List listCmp = controller.getDecomposition(logicalComp).getTargetComponents();
        DecompositionWizardTestCase.assertTrue((listCmp.size() == numComponents ? 1 : 0) != 0);
    }
}

