/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.misc.ju.testcases;

import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.polarsys.capella.common.data.modellingcore.AbstractType;
import org.polarsys.capella.core.data.capellamodeller.Project;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.model.handler.helpers.CapellaProjectHelper;
import org.polarsys.capella.test.diagram.common.ju.wrapper.utils.DiagramHelper;
import org.polarsys.capella.test.framework.api.BasicTestCase;
import org.polarsys.capella.test.framework.context.SessionContext;
import org.polarsys.capella.test.framework.helpers.TestHelper;

public class DiagramTargetUpdateDuringRefreshTest
extends BasicTestCase {
    private static final String MODEL_NAME = "diagrams-having-parts-as-targets";
    private static final String PROJECT_ID = "e712857e-aeec-49de-8bb2-5536c4fb6dd3";
    private static final List<String> DIAGRAM_NAMES = Arrays.asList("[LAB] Logical System", "[PAB] Physical System", "[EAB] System");
    private Session session;
    private Project project;

    protected void setUp() throws Exception {
        super.setUp();
        this.session = this.getSession(MODEL_NAME);
        DiagramTargetUpdateDuringRefreshTest.assertNotNull((Object)this.session);
        SessionContext context = new SessionContext(this.session);
        this.project = (Project)context.getSemanticElement(PROJECT_ID);
        DiagramTargetUpdateDuringRefreshTest.assertNotNull((Object)this.project);
    }

    public void test() throws Exception {
        this.ensureThatTargetRemainsUnchaingedInMultiPartMode();
        this.ensureThatTargetIsUpdatedInMonoPartMode();
    }

    private void ensureThatTargetRemainsUnchaingedInMultiPartMode() {
        CapellaProjectHelper.ProjectApproach originalApproach = CapellaProjectHelper.getProjectApproach((Project)this.project);
        TestHelper.setProjectApproach((Project)this.project, (CapellaProjectHelper.ProjectApproach)CapellaProjectHelper.ProjectApproach.ReusableComponents);
        for (String diagramName : DIAGRAM_NAMES) {
            DRepresentation representation = DiagramHelper.getDRepresentation((Session)this.session, (String)diagramName);
            DiagramTargetUpdateDuringRefreshTest.assertTrue((boolean)(representation instanceof DSemanticDiagram));
            DSemanticDiagram diagram = (DSemanticDiagram)representation;
            EObject initialTarget = diagram.getTarget();
            DiagramTargetUpdateDuringRefreshTest.assertTrue((boolean)(initialTarget instanceof Part));
            DiagramHelper.refreshDiagram((DDiagram)diagram);
            EObject updatedTarget = diagram.getTarget();
            DiagramTargetUpdateDuringRefreshTest.assertEquals((Object)initialTarget, (Object)updatedTarget);
        }
        TestHelper.setProjectApproach((Project)this.project, (CapellaProjectHelper.ProjectApproach)originalApproach);
    }

    private void ensureThatTargetIsUpdatedInMonoPartMode() {
        CapellaProjectHelper.ProjectApproach originalApproach = CapellaProjectHelper.getProjectApproach((Project)this.project);
        TestHelper.setProjectApproach((Project)this.project, (CapellaProjectHelper.ProjectApproach)CapellaProjectHelper.ProjectApproach.SingletonComponents);
        for (String diagramName : DIAGRAM_NAMES) {
            DRepresentation representation = DiagramHelper.getDRepresentation((Session)this.session, (String)diagramName);
            DiagramTargetUpdateDuringRefreshTest.assertTrue((boolean)(representation instanceof DSemanticDiagram));
            DSemanticDiagram diagram = (DSemanticDiagram)representation;
            EObject initialTarget = diagram.getTarget();
            DiagramTargetUpdateDuringRefreshTest.assertTrue((boolean)(initialTarget instanceof Part));
            Part part = (Part)initialTarget;
            AbstractType type = part.getAbstractType();
            DiagramHelper.refreshDiagram((DDiagram)diagram);
            EObject updatedTarget = diagram.getTarget();
            DiagramTargetUpdateDuringRefreshTest.assertEquals((Object)type, (Object)updatedTarget);
        }
        TestHelper.setProjectApproach((Project)this.project, (CapellaProjectHelper.ProjectApproach)originalApproach);
    }

    public List<String> getRequiredTestModels() {
        return Arrays.asList(MODEL_NAME);
    }
}

