/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.misc.ju.testcases;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.la.LogicalComponent;
import org.polarsys.capella.core.sirius.analysis.ContextServices;
import org.polarsys.capella.core.sirius.analysis.CsServices;
import org.polarsys.capella.core.sirius.analysis.DiagramServices;
import org.polarsys.capella.core.sirius.analysis.OAServices;
import org.polarsys.capella.test.diagram.common.ju.wrapper.utils.DiagramHelper;
import org.polarsys.capella.test.framework.api.BasicTestCase;
import org.polarsys.capella.test.framework.context.SessionContext;

public class InsertRemoveComponentsWithNoParts
extends BasicTestCase {
    private static final String PROJECT_NAME = "insert-remove-components-with-no-parts";
    public static final String LOGICAL_SYSTEM = "0f76d62b-5ba5-435c-b3a9-d3ce55934cd6";
    public static final String LC_1 = "dbcac4d4-a4c2-4bfc-a937-93af979ff1c2";
    public static final String CII_LOGICAL_SYSTEM = "[CII] Logical System";
    public static final String IDB_LOGICAL_SYSTEM = "[IDB] Logical System";
    public static final String CRI_CAPABILITY_REALIZATION = "[CRI] CapabilityRealization";
    public static final String OAB_OPERATIONAL_ENTITIES = "[OAB] Operational Entities";
    public static final String OCB_OPERATIONAL_CAPABILITIES = "[OCB] Operational Capabilities";
    public static final String PAB_PHYSICAL_SYSTEM = "[PAB] Physical System";
    protected Session session;
    protected SessionContext context;

    public List<String> getRequiredTestModels() {
        return Arrays.asList(PROJECT_NAME);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.session = this.getSession(PROJECT_NAME);
        this.context = new SessionContext(this.session);
    }

    public void test() throws Exception {
        ArrayList<String> errorMessages = new ArrayList<String>();
        this.testCCEI(errorMessages);
        this.testCCII(errorMessages);
        this.testIDB(errorMessages);
        this.testCRI_CRB_CM_MB_CC_MCB(errorMessages);
        this.testOCB_COC(errorMessages);
        this.testSAB_LAB_PAB(errorMessages);
        InsertRemoveComponentsWithNoParts.assertTrue((String)errorMessages.stream().collect(Collectors.joining("\n")), (boolean)errorMessages.isEmpty());
    }

    protected void testCCEI(Collection<String> errorMessages) {
        LogicalComponent logicalSystem = (LogicalComponent)this.context.getSemanticElement(LOGICAL_SYSTEM);
        Function<Component, Collection> componentMethod = arg_0 -> ((CsServices)CsServices.getService()).getCCEIShowHideComponent(arg_0);
        Function<Component, Collection> actorMethod = arg_0 -> ((CsServices)CsServices.getService()).getCCEIShowHideActors(arg_0);
        this.evaluateAndAccumulateErrors(Arrays.asList(componentMethod, actorMethod), logicalSystem, errorMessages);
    }

    protected void testCCII(Collection<String> errorMessages) {
        LogicalComponent logicalSystem = (LogicalComponent)this.context.getSemanticElement(LOGICAL_SYSTEM);
        DDiagram diagram = (DDiagram)DiagramHelper.getDRepresentation((Session)this.session, (String)CII_LOGICAL_SYSTEM);
        DDiagramElement logicalSystemElement = DiagramServices.getDiagramServices().getDiagramElement(diagram, (EObject)logicalSystem);
        Function<DSemanticDecorator, Collection> componentMethod = arg_0 -> ((CsServices)CsServices.getService()).getCCIIShowHideComponent(arg_0);
        Function<DSemanticDecorator, Collection> actorMethod = arg_0 -> ((CsServices)CsServices.getService()).getCCIIShowHideActor(arg_0);
        this.evaluateAndAccumulateErrors(Arrays.asList(componentMethod, actorMethod), logicalSystemElement, errorMessages);
    }

    protected void testIDB(Collection<String> errorMessages) {
        LogicalComponent lc1 = (LogicalComponent)this.context.getSemanticElement(LC_1);
        DDiagram diagram = (DDiagram)DiagramHelper.getDRepresentation((Session)this.session, (String)IDB_LOGICAL_SYSTEM);
        DDiagramElement lc1Element = DiagramServices.getDiagramServices().getDiagramElement(diagram, (EObject)lc1);
        Function<DSemanticDecorator, Collection> componentMethod = arg_0 -> ((CsServices)CsServices.getService()).getIBShowHideComponent(arg_0);
        Function<DSemanticDecorator, Collection> actorMethod = arg_0 -> ((CsServices)CsServices.getService()).getIBShowHideActor(arg_0);
        this.evaluateAndAccumulateErrors(Arrays.asList(componentMethod, actorMethod), lc1Element, errorMessages);
    }

    protected void testCRI_CRB_CM_MB_CC_MCB(Collection<String> errorMessages) {
        DSemanticDecorator diagram = (DSemanticDecorator)DiagramHelper.getDRepresentation((Session)this.session, (String)CRI_CAPABILITY_REALIZATION);
        Function<DSemanticDecorator, Collection> componentMethod = arg_0 -> ((ContextServices)ContextServices.getServices()).getCRBComponents(arg_0);
        this.evaluateAndAccumulateErrors(componentMethod, diagram, errorMessages);
        Function<DSemanticDecorator, List> actorMethod = arg_0 -> ((ContextServices)ContextServices.getServices()).getMCBActors(arg_0);
        this.evaluateAndAccumulateErrors(actorMethod, diagram, errorMessages);
    }

    protected void testOAB(Collection<String> errorMessages) {
        DSemanticDecorator diagram = (DSemanticDecorator)DiagramHelper.getDRepresentation((Session)this.session, (String)OAB_OPERATIONAL_ENTITIES);
        Function<DSemanticDecorator, Collection> actorEntitiesMethod = arg_0 -> ((OAServices)OAServices.getService()).getOEBEntities(arg_0);
        this.evaluateAndAccumulateErrors(actorEntitiesMethod, diagram, errorMessages);
    }

    protected void testOCB_COC(Collection<String> errorMessages) {
        DSemanticDecorator diagram = (DSemanticDecorator)DiagramHelper.getDRepresentation((Session)this.session, (String)OAB_OPERATIONAL_ENTITIES);
        Function<DSemanticDecorator, List> components = arg_0 -> ((ContextServices)ContextServices.getServices()).getOCBEntities(arg_0);
        Function<DSemanticDecorator, List> actors = arg_0 -> ((ContextServices)ContextServices.getServices()).getOCBActors(arg_0);
        this.evaluateAndAccumulateErrors(Arrays.asList(components, actors), diagram, errorMessages);
    }

    protected void testSAB_LAB_PAB(Collection<String> errorMessages) {
        DSemanticDecorator diagram = (DSemanticDecorator)DiagramHelper.getDRepresentation((Session)this.session, (String)PAB_PHYSICAL_SYSTEM);
        Function<DSemanticDecorator, Collection> actors = arg_0 -> ((CsServices)CsServices.getService()).getABShowHideActor(arg_0);
        Function<DSemanticDecorator, Collection> components = arg_0 -> ((CsServices)CsServices.getService()).getABShowHideComponent(arg_0);
        this.evaluateAndAccumulateErrors(Arrays.asList(actors, components), diagram, errorMessages);
    }

    protected <P, R> void evaluateAndAccumulateErrors(List<Function<P, R>> functions, P parameter, Collection<String> errorsAcumulator) {
        for (Function<P, R> function : functions) {
            R result = function.apply(parameter);
            String message = null;
            if (!(result instanceof Collection)) {
                message = function.toString() + " did not return a Collection for " + parameter.toString();
            } else {
                Collection collectionResult = (Collection)result;
                if (collectionResult.isEmpty()) {
                    message = function.toString() + " returned a empty Collection for " + parameter.toString();
                } else {
                    Object first = collectionResult.iterator().next();
                    if (!(first instanceof Component)) {
                        message = function.toString() + "did not returned a Component Collection for " + parameter.toString();
                    } else {
                        Collection components = collectionResult;
                        for (Component component : components) {
                            if (!component.getRepresentingParts().isEmpty()) continue;
                            String error = "Component " + component.getName() + "[" + component.getId() + "][" + function.toString() + "] has no representing parts";
                            errorsAcumulator.add(error);
                        }
                    }
                }
            }
            if (message == null) continue;
            errorsAcumulator.add(message);
        }
    }

    protected <P, R> void evaluateAndAccumulateErrors(Function<P, R> function, P parameter, Collection<String> errorsAcumulator) {
        this.evaluateAndAccumulateErrors(Arrays.asList(function), parameter, errorsAcumulator);
    }
}

