/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.misc.ju.testcases;

import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.common.libraries.IModel;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.core.libraries.model.CapellaModel;
import org.polarsys.capella.core.libraries.utils.ScopeModelWrapper;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.sirius.analysis.OAServices;
import org.polarsys.capella.shared.id.handler.IScope;
import org.polarsys.capella.shared.id.handler.IdManager;
import org.polarsys.capella.test.diagram.common.ju.context.XDFBDiagram;
import org.polarsys.capella.test.diagram.common.ju.wrapper.utils.DiagramHelper;
import org.polarsys.capella.test.framework.api.BasicTestCase;
import org.polarsys.capella.test.framework.context.SessionContext;

public class InteractionSourceTarget
extends BasicTestCase {
    public static final String INTERACTION_1 = "f4756f78-ef42-4c35-9793-3c916bae710d";
    public static final String INTERACTION_2 = "c2ce75ec-32fa-46d6-8557-f995b8f3ce44";
    public static final String INTERACTION_3 = "dd31bcfa-0c08-4984-8358-47f4dfd79f7a";
    public static final String INTERACTION_4 = "a96b1b95-47fd-4e76-9dc3-f8bb979ce15f";
    public static final String OAIB = "[OAIB] Root Operational Activity";
    public static final String OA_2 = "f26b78a9-9109-4af6-840c-fc3d050e1f8e";
    public static final String OA_4 = "308bbc45-8cda-45a2-886f-8adc208e3b7b";
    public static final String OA_6 = "b157b346-59b3-438a-91fe-481e9cf8853c";
    public static final String OA_4_1 = "71356c27-1fbc-49f5-b453-0a1aa3026863";
    public static final String OA_6_1 = "c57618fa-d961-4670-8524-9434a0bb186e";
    private String projectTestName = "StatusLine";

    public List<String> getRequiredTestModels() {
        return Arrays.asList(this.projectTestName);
    }

    public void test() throws Exception {
        CapellaModel model = this.getTestModel(this.projectTestName);
        ScopeModelWrapper scope = new ScopeModelWrapper((IModel)model);
        EObject interaction_1 = IdManager.getInstance().getEObject(INTERACTION_1, (IScope)scope);
        EObject interaction_2 = IdManager.getInstance().getEObject(INTERACTION_2, (IScope)scope);
        EObject interaction_3 = IdManager.getInstance().getEObject(INTERACTION_3, (IScope)scope);
        EObject interaction_4 = IdManager.getInstance().getEObject(INTERACTION_4, (IScope)scope);
        final EObject oa_2 = IdManager.getInstance().getEObject(OA_2, (IScope)scope);
        EObject oa_4 = IdManager.getInstance().getEObject(OA_4, (IScope)scope);
        EObject oa_6 = IdManager.getInstance().getEObject(OA_6, (IScope)scope);
        final EObject oa_4_1 = IdManager.getInstance().getEObject(OA_4_1, (IScope)scope);
        final EObject oa_6_1 = IdManager.getInstance().getEObject(OA_6_1, (IScope)scope);
        Session session = this.getSession(this.projectTestName);
        SessionContext context = new SessionContext(session);
        final XDFBDiagram OAIBDiagram = XDFBDiagram.openDiagram((SessionContext)context, (String)OAIB, (BlockArchitectureExt.Type)BlockArchitectureExt.Type.OA);
        TransactionHelper.getExecutionManager((Session)session).execute((ICommand)new AbstractReadWriteCommand(){

            public void run() {
                DiagramHelper.removeView((DDiagramElement)OAIBDiagram.getView(oa_2));
                DiagramHelper.removeView((DDiagramElement)OAIBDiagram.getView(oa_4_1));
                DiagramHelper.removeView((DDiagramElement)OAIBDiagram.getView(oa_6_1));
            }
        });
        OAIBDiagram.refreshDiagram();
        InteractionSourceTarget.assertTrue((OAServices.getService().getInteractionTargetInDiagram((FunctionalExchange)interaction_1, OAIBDiagram.getDiagram()) == null ? 1 : 0) != 0);
        InteractionSourceTarget.assertTrue((OAServices.getService().getInteractionSourceInDiagram((FunctionalExchange)interaction_2, OAIBDiagram.getDiagram()) == null ? 1 : 0) != 0);
        InteractionSourceTarget.assertTrue((OAServices.getService().getInteractionSourceInDiagram((FunctionalExchange)interaction_3, OAIBDiagram.getDiagram()) == oa_4 ? 1 : 0) != 0);
        InteractionSourceTarget.assertTrue((OAServices.getService().getInteractionTargetInDiagram((FunctionalExchange)interaction_4, OAIBDiagram.getDiagram()) == oa_6 ? 1 : 0) != 0);
    }
}

