/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.misc.ju.testcases;

import java.util.Arrays;
import java.util.List;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.EdgeTarget;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.polarsys.capella.test.diagram.common.ju.context.DiagramContext;
import org.polarsys.capella.test.diagram.common.ju.step.crud.OpenDiagramStep;
import org.polarsys.capella.test.framework.api.BasicTestCase;
import org.polarsys.capella.test.framework.context.SessionContext;

public class InterfacePortSizeTestCase
extends BasicTestCase {
    public static String LA__CP_1 = "edd60521-edea-4436-9464-629c10c3e2c0";
    public static String LA__CP_2 = "8f9456ac-a1ab-4812-94a1-0b65789f51a7";
    private String cDIDiagramName = "[CDI] Logical System";
    private String cEIDiagramName = "[CEI] Logical System";
    private String cIIDiagramName = "[CII] Logical System";
    private String iDBDiagramName = "[IDB] Logical System";
    private String projectTestName = "testPortSize";

    public List<String> getRequiredTestModels() {
        return Arrays.asList(this.projectTestName);
    }

    public void test() throws Exception {
        Session session = this.getSession(this.projectTestName);
        InterfacePortSizeTestCase.assertNotNull((Object)session);
        SessionContext context = new SessionContext(session);
        this.checkPortSize(context, this.cDIDiagramName);
        this.checkPortSize(context, this.cEIDiagramName);
        this.checkPortSize(context, this.cIIDiagramName);
        this.checkPortSize(context, this.iDBDiagramName);
    }

    private void checkPortSize(SessionContext context, String diagramName) {
        DiagramContext diagramContext = (DiagramContext)new OpenDiagramStep(context, diagramName).run();
        DSemanticDecorator requiredPortView = diagramContext.getView(LA__CP_1);
        InterfacePortSizeTestCase.assertTrue((String)"View of required port not found", (requiredPortView != null && requiredPortView instanceof DEdge ? 1 : 0) != 0);
        DEdge requiredPortEdge = (DEdge)requiredPortView;
        EdgeTarget requiredPort = requiredPortEdge.getSourceNode();
        InterfacePortSizeTestCase.assertTrue((String)"Size of port is not correct", (requiredPort instanceof DNode && ((DNode)requiredPort).getHeight() == 3 && ((DNode)requiredPort).getWidth() == 3 ? 1 : 0) != 0);
        DSemanticDecorator providedPortView = diagramContext.getView(LA__CP_2);
        InterfacePortSizeTestCase.assertTrue((String)"View of provided port not found", (requiredPortView != null && requiredPortView instanceof DEdge ? 1 : 0) != 0);
        DEdge providedPortEdge = (DEdge)providedPortView;
        EdgeTarget providedPort = providedPortEdge.getSourceNode();
        InterfacePortSizeTestCase.assertTrue((String)"Size of port is not correct", (providedPort instanceof DNode && ((DNode)providedPort).getHeight() == 3 && ((DNode)providedPort).getWidth() == 3 ? 1 : 0) != 0);
    }
}

