/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.diagram.misc.ju.testcases;

import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.DEdgeBeginNameEditPart;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.DEdgeEndNameEditPart;
import org.eclipse.sirius.diagram.ui.tools.api.graphical.edit.styles.StyleConfiguration;
import org.eclipse.sirius.diagram.ui.tools.internal.graphical.edit.styles.StyleConfigurationRegistry;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.ui.IEditorPart;
import org.polarsys.capella.core.data.cs.PhysicalLink;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.core.sirius.analysis.CapellaServices;
import org.polarsys.capella.core.sirius.analysis.DiagramServices;
import org.polarsys.capella.core.sirius.analysis.cache.DEdgeIconCache;
import org.polarsys.capella.test.diagram.common.ju.wrapper.utils.DiagramHelper;
import org.polarsys.capella.test.framework.api.BasicTestCase;
import org.polarsys.capella.test.framework.context.SessionContext;

public class PieIconTest
extends BasicTestCase {
    private static final String PROJECT_NAME = "testPie";
    protected Session session;
    protected SessionContext context;
    public static String OAIB = "_uMIigLCvEe6Fv9U2y24pjw";
    public static String OAB = "_97h-ILCwEe6Fv9U2y24pjw";
    public static String SAB = "_CZ_7QLC2Ee6Fv9U2y24pjw";
    public static String SDFB = "_MWE0wLC0Ee6Fv9U2y24pjw";
    public static String LAB = "_1jTKwK-mEe6L-OKa_6GDIw";
    public static String LDFB = "_c61CELEYEe6Fv9U2y24pjw";
    public static String PAB = "_S542sLEaEe6Fv9U2y24pjw";
    public static String PDFB = "_0DlQ4LEZEe6Fv9U2y24pjw";

    public List<String> getRequiredTestModels() {
        return Arrays.asList(PROJECT_NAME);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.session = this.getSession(PROJECT_NAME);
        this.context = new SessionContext(this.session);
    }

    public void test() throws Exception {
        this.testOA();
        this.testSA();
        this.testLA();
        this.testPA();
    }

    public void testOA() {
        this.testPieIconsOnFunctionalExchanges(this.session, OAB, false);
        this.testPieIconsOnFunctionalExchanges(this.session, OAIB, false);
    }

    public void testSA() {
        this.testPieIconsOnFunctionalExchanges(this.session, SAB, true);
        this.testPieIconsOnFunctionalExchanges(this.session, SDFB, false);
    }

    public void testLA() {
        this.testPieIconsOnFunctionalExchanges(this.session, LAB, true);
        this.testPieIconsOnFunctionalExchanges(this.session, LDFB, false);
    }

    public void testPA() {
        this.testPieIconsOnFunctionalExchanges(this.session, PAB, true);
        this.testPieIconsOnFunctionalExchanges(this.session, PDFB, false);
    }

    public void testPieIconsOnFunctionalExchanges(Session session, String diagramUID, boolean testPL) {
        DEdgeIconCache.getInstance().reset();
        DiagramHelper.setPrefereneRefreshOnOpening((boolean)false);
        DiagramHelper.setPreferenceAutoRefresh((boolean)false);
        DDiagram diagram = (DDiagram)DiagramHelper.getDRepresentationByUID((Session)session, (String)diagramUID);
        IEditorPart editor = DiagramHelper.opendiagramEditor((Session)session, (DRepresentation)diagram);
        PieIconTest.assertFalse((boolean)this.hasPieIconOnFunctionalExchange(diagram));
        if (testPL) {
            PieIconTest.assertFalse((boolean)this.hasPieIconOnPhysicalLink(diagram));
        }
        DiagramHelper.refreshDiagram((DDiagram)diagram);
        PieIconTest.assertTrue((boolean)this.hasPieIconOnFunctionalExchange(diagram));
        if (testPL) {
            PieIconTest.assertTrue((boolean)this.hasPieIconOnPhysicalLink(diagram));
        }
        DiagramHelper.closeEditor((IEditorPart)editor);
        DiagramHelper.setPrefereneRefreshOnOpening((boolean)true);
        DiagramHelper.setPreferenceAutoRefresh((boolean)true);
        diagram = (DDiagram)DiagramHelper.getDRepresentationByUID((Session)session, (String)diagramUID);
        editor = DiagramHelper.opendiagramEditor((Session)session, (DRepresentation)diagram);
        PieIconTest.assertTrue((boolean)this.hasPieIconOnFunctionalExchange(diagram));
        if (testPL) {
            PieIconTest.assertTrue((boolean)this.hasPieIconOnPhysicalLink(diagram));
        }
        DiagramHelper.closeEditor((IEditorPart)editor);
    }

    public void testPieIconsOnPhysicalLinks(Session session, String diagramUID) {
        DEdgeIconCache.getInstance().reset();
        DiagramHelper.setPrefereneRefreshOnOpening((boolean)false);
        DiagramHelper.setPreferenceAutoRefresh((boolean)false);
        DDiagram diagram = (DDiagram)DiagramHelper.getDRepresentationByUID((Session)session, (String)diagramUID);
        IEditorPart editor = DiagramHelper.opendiagramEditor((Session)session, (DRepresentation)diagram);
        PieIconTest.assertFalse((boolean)this.hasPieIconOnPhysicalLink(diagram));
        DiagramHelper.refreshDiagram((DDiagram)diagram);
        PieIconTest.assertTrue((boolean)this.hasPieIconOnPhysicalLink(diagram));
        DiagramHelper.closeEditor((IEditorPart)editor);
        DiagramHelper.setPrefereneRefreshOnOpening((boolean)true);
        DiagramHelper.setPreferenceAutoRefresh((boolean)true);
        diagram = (DDiagram)DiagramHelper.getDRepresentationByUID((Session)session, (String)diagramUID);
        editor = DiagramHelper.opendiagramEditor((Session)session, (DRepresentation)diagram);
        PieIconTest.assertTrue((boolean)this.hasPieIconOnPhysicalLink(diagram));
        DiagramHelper.closeEditor((IEditorPart)editor);
    }

    private boolean hasPieIconOnFunctionalExchange(DDiagram diagram) {
        for (DEdge edge : diagram.getEdges()) {
            EObject target = edge.getTarget();
            if (!(target instanceof FunctionalExchange)) continue;
            FunctionalExchange fe = (FunctionalExchange)target;
            EditPart edgeEditPart = DiagramServices.getDiagramServices().getEditPart((DDiagramElement)edge);
            if (CapellaServices.getService().getDisplayedInvolvingFunctionalChains(edge).size() <= 1 || edgeEditPart == null) continue;
            EditPart nameEditPart = edgeEditPart.getChildren().stream().filter(child -> child instanceof DEdgeBeginNameEditPart || child instanceof DEdgeEndNameEditPart).findAny().get();
            if (nameEditPart != null) {
                StyleConfiguration c = StyleConfigurationRegistry.getInstance().getStyleConfiguration(edge.getDiagramElementMapping(), edge.getStyle());
                return c.getLabelIcon((DDiagramElement)edge, (IGraphicalEditPart)nameEditPart) != null;
            }
            return nameEditPart != null;
        }
        return false;
    }

    private boolean hasPieIconOnPhysicalLink(DDiagram diagram) {
        for (DEdge edge : diagram.getEdges()) {
            EObject target = edge.getTarget();
            if (!(target instanceof PhysicalLink)) continue;
            PhysicalLink fe = (PhysicalLink)target;
            EditPart edgeEditPart = DiagramServices.getDiagramServices().getEditPart((DDiagramElement)edge);
            if (CapellaServices.getService().getDisplayedInvolvingPhysicalPaths(edge).size() <= 1 || edgeEditPart == null) continue;
            EditPart nameEditPart = edgeEditPart.getChildren().stream().filter(child -> child instanceof DEdgeBeginNameEditPart || child instanceof DEdgeEndNameEditPart).findAny().get();
            if (nameEditPart != null) {
                StyleConfiguration c = StyleConfigurationRegistry.getInstance().getStyleConfiguration(edge.getDiagramElementMapping(), edge.getStyle());
                return c.getLabelIcon((DDiagramElement)edge, (IGraphicalEditPart)nameEditPart) != null;
            }
            return nameEditPart != null;
        }
        return false;
    }
}

